<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerPaymentMethodProfiles StructType
 * @subpackage Structs
 */
class GetCustomerPaymentMethodProfiles extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerToken;
    /**
     * Constructor method for GetCustomerPaymentMethodProfiles
     * @uses GetCustomerPaymentMethodProfiles::setSecurityToken()
     * @uses GetCustomerPaymentMethodProfiles::setCustomerToken()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerToken
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerToken = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerToken($customerToken);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfiles
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerToken value
     * @return string|null
     */
    public function getCustomerToken()
    {
        return $this->customerToken;
    }
    /**
     * Set customerToken value
     * @param string $customerToken
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfiles
     */
    public function setCustomerToken($customerToken = null)
    {
        // validation for constraint: string
        if (!is_null($customerToken) && !is_string($customerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerToken, true), gettype($customerToken)), __LINE__);
        }
        $this->customerToken = $customerToken;
        return $this;
    }
}
