<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AuthenticateSK
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AuthenticateSK $parameters
     * @return \eBizCharge\StructType\AuthenticateSKResponse|bool
     */
    public function AuthenticateSK(\eBizCharge\StructType\AuthenticateSK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AuthenticateSK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\AuthenticateSKResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
