<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaidDocument StructType
 * @subpackage Structs
 */
class PaidDocument extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SubCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCustomerId;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The DocumentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentInternalId;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidAmount;
    /**
     * Constructor method for PaidDocument
     * @uses PaidDocument::setCustomerId()
     * @uses PaidDocument::setSubCustomerId()
     * @uses PaidDocument::setDivisionId()
     * @uses PaidDocument::setDocumentNumber()
     * @uses PaidDocument::setDocumentInternalId()
     * @uses PaidDocument::setDocumentTypeId()
     * @uses PaidDocument::setPaidAmount()
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $divisionId
     * @param string $documentNumber
     * @param string $documentInternalId
     * @param string $documentTypeId
     * @param string $paidAmount
     */
    public function __construct($customerId = null, $subCustomerId = null, $divisionId = null, $documentNumber = null, $documentInternalId = null, $documentTypeId = null, $paidAmount = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setDivisionId($divisionId)
            ->setDocumentNumber($documentNumber)
            ->setDocumentInternalId($documentInternalId)
            ->setDocumentTypeId($documentTypeId)
            ->setPaidAmount($paidAmount);
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SubCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->SubCustomerId;
    }
    /**
     * Set SubCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->SubCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get DocumentInternalId value
     * @return string|null
     */
    public function getDocumentInternalId()
    {
        return $this->DocumentInternalId;
    }
    /**
     * Set DocumentInternalId value
     * @param string $documentInternalId
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setDocumentInternalId($documentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($documentInternalId) && !is_string($documentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentInternalId, true), gettype($documentInternalId)), __LINE__);
        }
        $this->DocumentInternalId = $documentInternalId;
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return $this->DocumentTypeId;
    }
    /**
     * Set DocumentTypeId value
     * @param string $documentTypeId
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        $this->DocumentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get PaidAmount value
     * @return string|null
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param string $paidAmount
     * @return \eBizCharge\StructType\PaidDocument
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paidAmount) && !is_string($paidAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->PaidAmount = $paidAmount;
        return $this;
    }
}
