<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaidDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaidDocument extends AbstractStructArrayBase
{
    /**
     * The PaidDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\PaidDocument[]
     */
    public $PaidDocument;
    /**
     * Constructor method for ArrayOfPaidDocument
     * @uses ArrayOfPaidDocument::setPaidDocument()
     * @param \eBizCharge\StructType\PaidDocument[] $paidDocument
     */
    public function __construct(array $paidDocument = array())
    {
        $this
            ->setPaidDocument($paidDocument);
    }
    /**
     * Get PaidDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\PaidDocument[]|null
     */
    public function getPaidDocument()
    {
        return isset($this->PaidDocument) ? $this->PaidDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaidDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaidDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaidDocumentForArrayConstraintsFromSetPaidDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaidDocumentPaidDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaidDocumentPaidDocumentItem instanceof \eBizCharge\StructType\PaidDocument) {
                $invalidValues[] = is_object($arrayOfPaidDocumentPaidDocumentItem) ? get_class($arrayOfPaidDocumentPaidDocumentItem) : sprintf('%s(%s)', gettype($arrayOfPaidDocumentPaidDocumentItem), var_export($arrayOfPaidDocumentPaidDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaidDocument property can only contain items of type \eBizCharge\StructType\PaidDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaidDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\PaidDocument[] $paidDocument
     * @return \eBizCharge\ArrayType\ArrayOfPaidDocument
     */
    public function setPaidDocument(array $paidDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($paidDocumentArrayErrorMessage = self::validatePaidDocumentForArrayConstraintsFromSetPaidDocument($paidDocument))) {
            throw new \InvalidArgumentException($paidDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($paidDocument) || (is_array($paidDocument) && empty($paidDocument))) {
            unset($this->PaidDocument);
        } else {
            $this->PaidDocument = $paidDocument;
        }
        return $this;
    }
    /**
     * Add item to PaidDocument value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\PaidDocument $item
     * @return \eBizCharge\ArrayType\ArrayOfPaidDocument
     */
    public function addToPaidDocument(\eBizCharge\StructType\PaidDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\PaidDocument) {
            throw new \InvalidArgumentException(sprintf('The PaidDocument property can only contain items of type \eBizCharge\StructType\PaidDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaidDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\PaidDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\PaidDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\PaidDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\PaidDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\PaidDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaidDocument
     */
    public function getAttributeName()
    {
        return 'PaidDocument';
    }
}
