<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckTrace StructType
 * @subpackage Structs
 */
class CheckTrace extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The BankNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankNote;
    /**
     * The Effective
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective;
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Processed;
    /**
     * The Returned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Returned;
    /**
     * The ReturnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnCode;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The Settled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Settled;
    /**
     * The TrackingNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNum;
    /**
     * Constructor method for CheckTrace
     * @uses CheckTrace::setStatus()
     * @uses CheckTrace::setStatusCode()
     * @uses CheckTrace::setBankNote()
     * @uses CheckTrace::setEffective()
     * @uses CheckTrace::setProcessed()
     * @uses CheckTrace::setReturned()
     * @uses CheckTrace::setReturnCode()
     * @uses CheckTrace::setReason()
     * @uses CheckTrace::setSettled()
     * @uses CheckTrace::setTrackingNum()
     * @param string $status
     * @param string $statusCode
     * @param string $bankNote
     * @param string $effective
     * @param string $processed
     * @param string $returned
     * @param string $returnCode
     * @param string $reason
     * @param string $settled
     * @param string $trackingNum
     */
    public function __construct($status = null, $statusCode = null, $bankNote = null, $effective = null, $processed = null, $returned = null, $returnCode = null, $reason = null, $settled = null, $trackingNum = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setBankNote($bankNote)
            ->setEffective($effective)
            ->setProcessed($processed)
            ->setReturned($returned)
            ->setReturnCode($returnCode)
            ->setReason($reason)
            ->setSettled($settled)
            ->setTrackingNum($trackingNum);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get BankNote value
     * @return string|null
     */
    public function getBankNote()
    {
        return $this->BankNote;
    }
    /**
     * Set BankNote value
     * @param string $bankNote
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setBankNote($bankNote = null)
    {
        // validation for constraint: string
        if (!is_null($bankNote) && !is_string($bankNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankNote, true), gettype($bankNote)), __LINE__);
        }
        $this->BankNote = $bankNote;
        return $this;
    }
    /**
     * Get Effective value
     * @return string|null
     */
    public function getEffective()
    {
        return $this->Effective;
    }
    /**
     * Set Effective value
     * @param string $effective
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setEffective($effective = null)
    {
        // validation for constraint: string
        if (!is_null($effective) && !is_string($effective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective, true), gettype($effective)), __LINE__);
        }
        $this->Effective = $effective;
        return $this;
    }
    /**
     * Get Processed value
     * @return string|null
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param string $processed
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: string
        if (!is_null($processed) && !is_string($processed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get Returned value
     * @return string|null
     */
    public function getReturned()
    {
        return $this->Returned;
    }
    /**
     * Set Returned value
     * @param string $returned
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setReturned($returned = null)
    {
        // validation for constraint: string
        if (!is_null($returned) && !is_string($returned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returned, true), gettype($returned)), __LINE__);
        }
        $this->Returned = $returned;
        return $this;
    }
    /**
     * Get ReturnCode value
     * @return string|null
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }
    /**
     * Set ReturnCode value
     * @param string $returnCode
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: string
        if (!is_null($returnCode) && !is_string($returnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->ReturnCode = $returnCode;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Settled value
     * @return string|null
     */
    public function getSettled()
    {
        return $this->Settled;
    }
    /**
     * Set Settled value
     * @param string $settled
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setSettled($settled = null)
    {
        // validation for constraint: string
        if (!is_null($settled) && !is_string($settled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settled, true), gettype($settled)), __LINE__);
        }
        $this->Settled = $settled;
        return $this;
    }
    /**
     * Get TrackingNum value
     * @return string|null
     */
    public function getTrackingNum()
    {
        return $this->TrackingNum;
    }
    /**
     * Set TrackingNum value
     * @param string $trackingNum
     * @return \eBizCharge\StructType\CheckTrace
     */
    public function setTrackingNum($trackingNum = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNum) && !is_string($trackingNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNum, true), gettype($trackingNum)), __LINE__);
        }
        $this->TrackingNum = $trackingNum;
        return $this;
    }
}
