<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecurringFrequency ArrayType
 * @subpackage Arrays
 */
class ArrayOfRecurringFrequency extends AbstractStructArrayBase
{
    /**
     * The RecurringFrequency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\RecurringFrequency[]
     */
    public $RecurringFrequency;
    /**
     * Constructor method for ArrayOfRecurringFrequency
     * @uses ArrayOfRecurringFrequency::setRecurringFrequency()
     * @param \eBizCharge\StructType\RecurringFrequency[] $recurringFrequency
     */
    public function __construct(array $recurringFrequency = array())
    {
        $this
            ->setRecurringFrequency($recurringFrequency);
    }
    /**
     * Get RecurringFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\RecurringFrequency[]|null
     */
    public function getRecurringFrequency()
    {
        return isset($this->RecurringFrequency) ? $this->RecurringFrequency : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecurringFrequency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecurringFrequency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecurringFrequencyForArrayConstraintsFromSetRecurringFrequency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecurringFrequencyRecurringFrequencyItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecurringFrequencyRecurringFrequencyItem instanceof \eBizCharge\StructType\RecurringFrequency) {
                $invalidValues[] = is_object($arrayOfRecurringFrequencyRecurringFrequencyItem) ? get_class($arrayOfRecurringFrequencyRecurringFrequencyItem) : sprintf('%s(%s)', gettype($arrayOfRecurringFrequencyRecurringFrequencyItem), var_export($arrayOfRecurringFrequencyRecurringFrequencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecurringFrequency property can only contain items of type \eBizCharge\StructType\RecurringFrequency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecurringFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\RecurringFrequency[] $recurringFrequency
     * @return \eBizCharge\ArrayType\ArrayOfRecurringFrequency
     */
    public function setRecurringFrequency(array $recurringFrequency = array())
    {
        // validation for constraint: array
        if ('' !== ($recurringFrequencyArrayErrorMessage = self::validateRecurringFrequencyForArrayConstraintsFromSetRecurringFrequency($recurringFrequency))) {
            throw new \InvalidArgumentException($recurringFrequencyArrayErrorMessage, __LINE__);
        }
        if (is_null($recurringFrequency) || (is_array($recurringFrequency) && empty($recurringFrequency))) {
            unset($this->RecurringFrequency);
        } else {
            $this->RecurringFrequency = $recurringFrequency;
        }
        return $this;
    }
    /**
     * Add item to RecurringFrequency value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\RecurringFrequency $item
     * @return \eBizCharge\ArrayType\ArrayOfRecurringFrequency
     */
    public function addToRecurringFrequency(\eBizCharge\StructType\RecurringFrequency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\RecurringFrequency) {
            throw new \InvalidArgumentException(sprintf('The RecurringFrequency property can only contain items of type \eBizCharge\StructType\RecurringFrequency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecurringFrequency[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\RecurringFrequency|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\RecurringFrequency|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\RecurringFrequency|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\RecurringFrequency|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\RecurringFrequency|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RecurringFrequency
     */
    public function getAttributeName()
    {
        return 'RecurringFrequency';
    }
}
