<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchSalesReps StructType
 * @subpackage Structs
 */
class SearchSalesReps extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The salesRepInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesRepInternalId;
    /**
     * The salesRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesRepId;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public $filters;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchSalesReps
     * @uses SearchSalesReps::setStart()
     * @uses SearchSalesReps::setLimit()
     * @uses SearchSalesReps::setSecurityToken()
     * @uses SearchSalesReps::setSalesRepInternalId()
     * @uses SearchSalesReps::setSalesRepId()
     * @uses SearchSalesReps::setFilters()
     * @uses SearchSalesReps::setSort()
     * @param int $start
     * @param int $limit
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $salesRepInternalId
     * @param string $salesRepId
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @param string $sort
     */
    public function __construct($start = null, $limit = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $salesRepInternalId = null, $salesRepId = null, \eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null, $sort = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setSecurityToken($securityToken)
            ->setSalesRepInternalId($salesRepInternalId)
            ->setSalesRepId($salesRepId)
            ->setFilters($filters)
            ->setSort($sort);
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get salesRepInternalId value
     * @return string|null
     */
    public function getSalesRepInternalId()
    {
        return $this->salesRepInternalId;
    }
    /**
     * Set salesRepInternalId value
     * @param string $salesRepInternalId
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setSalesRepInternalId($salesRepInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepInternalId) && !is_string($salesRepInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepInternalId, true), gettype($salesRepInternalId)), __LINE__);
        }
        $this->salesRepInternalId = $salesRepInternalId;
        return $this;
    }
    /**
     * Get salesRepId value
     * @return string|null
     */
    public function getSalesRepId()
    {
        return $this->salesRepId;
    }
    /**
     * Set salesRepId value
     * @param string $salesRepId
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        $this->salesRepId = $salesRepId;
        return $this;
    }
    /**
     * Get filters value
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setFilters(\eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchSalesReps
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
}
