<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EbizWebForm StructType
 * @subpackage Structs
 */
class EbizWebForm extends AbstractStructBase
{
    /**
     * The SendEmailToCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendEmailToCustomer;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountDue;
    /**
     * The TipAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TipAmount;
    /**
     * The ShippingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShippingAmount;
    /**
     * The DutyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DutyAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxAmount;
    /**
     * The DisplayDefaultResultPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DisplayDefaultResultPage;
    /**
     * The SavePaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SavePaymentMethod;
    /**
     * The ShowSavedPaymentMethods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowSavedPaymentMethods;
    /**
     * The ShowViewInvoiceLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowViewInvoiceLink;
    /**
     * The ShowViewSalesOrderLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowViewSalesOrderLink;
    /**
     * The FormType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormType;
    /**
     * The FromEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromEmail;
    /**
     * The FromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The CcEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CcEmailAddress;
    /**
     * The BccEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BccEmailAddress;
    /**
     * The ReplyToEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToEmailAddress;
    /**
     * The ReplyToDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToDisplayName;
    /**
     * The EmailNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailNotes;
    /**
     * The EmailNotesHTML
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailNotesHTML;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailSubject;
    /**
     * The EmailTemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTemplateID;
    /**
     * The EmailTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTemplateName;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The CustFullName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustFullName;
    /**
     * The TransId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransId;
    /**
     * The TransDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransDetail;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The PoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNum;
    /**
     * The SoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoNum;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The ApprovedURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedURL;
    /**
     * The DeclinedURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeclinedURL;
    /**
     * The ErrorURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorURL;
    /**
     * The PayByType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayByType;
    /**
     * The AllowedPaymentMethods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllowedPaymentMethods;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ProcessingCommand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcessingCommand;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * The TransactionLookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionLookupKey;
    /**
     * The LineItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfTransactionLineItem
     */
    public $LineItems;
    /**
     * The Clerk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Clerk;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Terminal;
    /**
     * The InvoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalId;
    /**
     * The DeviceSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\DeviceSettings
     */
    public $DeviceSettings;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The SalesOrderInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesOrderInternalId;
    /**
     * Constructor method for EbizWebForm
     * @uses EbizWebForm::setSendEmailToCustomer()
     * @uses EbizWebForm::setDate()
     * @uses EbizWebForm::setDueDate()
     * @uses EbizWebForm::setTotalAmount()
     * @uses EbizWebForm::setAmountDue()
     * @uses EbizWebForm::setTipAmount()
     * @uses EbizWebForm::setShippingAmount()
     * @uses EbizWebForm::setDutyAmount()
     * @uses EbizWebForm::setTaxAmount()
     * @uses EbizWebForm::setDisplayDefaultResultPage()
     * @uses EbizWebForm::setSavePaymentMethod()
     * @uses EbizWebForm::setShowSavedPaymentMethods()
     * @uses EbizWebForm::setShowViewInvoiceLink()
     * @uses EbizWebForm::setShowViewSalesOrderLink()
     * @uses EbizWebForm::setFormType()
     * @uses EbizWebForm::setFromEmail()
     * @uses EbizWebForm::setFromName()
     * @uses EbizWebForm::setEmailAddress()
     * @uses EbizWebForm::setCcEmailAddress()
     * @uses EbizWebForm::setBccEmailAddress()
     * @uses EbizWebForm::setReplyToEmailAddress()
     * @uses EbizWebForm::setReplyToDisplayName()
     * @uses EbizWebForm::setEmailNotes()
     * @uses EbizWebForm::setEmailNotesHTML()
     * @uses EbizWebForm::setEmailSubject()
     * @uses EbizWebForm::setEmailTemplateID()
     * @uses EbizWebForm::setEmailTemplateName()
     * @uses EbizWebForm::setCustomerId()
     * @uses EbizWebForm::setCustFullName()
     * @uses EbizWebForm::setTransId()
     * @uses EbizWebForm::setTransDetail()
     * @uses EbizWebForm::setInvoiceNumber()
     * @uses EbizWebForm::setPoNum()
     * @uses EbizWebForm::setSoNum()
     * @uses EbizWebForm::setOrderId()
     * @uses EbizWebForm::setDescription()
     * @uses EbizWebForm::setBillingAddress()
     * @uses EbizWebForm::setShippingAddress()
     * @uses EbizWebForm::setApprovedURL()
     * @uses EbizWebForm::setDeclinedURL()
     * @uses EbizWebForm::setErrorURL()
     * @uses EbizWebForm::setPayByType()
     * @uses EbizWebForm::setAllowedPaymentMethods()
     * @uses EbizWebForm::setCountryCode()
     * @uses EbizWebForm::setCurrencyCode()
     * @uses EbizWebForm::setProcessingCommand()
     * @uses EbizWebForm::setSoftwareId()
     * @uses EbizWebForm::setTransactionLookupKey()
     * @uses EbizWebForm::setLineItems()
     * @uses EbizWebForm::setClerk()
     * @uses EbizWebForm::setTerminal()
     * @uses EbizWebForm::setInvoiceInternalId()
     * @uses EbizWebForm::setDeviceSettings()
     * @uses EbizWebForm::setDocumentTypeId()
     * @uses EbizWebForm::setSalesOrderInternalId()
     * @param bool $sendEmailToCustomer
     * @param string $date
     * @param string $dueDate
     * @param float $totalAmount
     * @param float $amountDue
     * @param float $tipAmount
     * @param float $shippingAmount
     * @param float $dutyAmount
     * @param float $taxAmount
     * @param int $displayDefaultResultPage
     * @param bool $savePaymentMethod
     * @param bool $showSavedPaymentMethods
     * @param bool $showViewInvoiceLink
     * @param bool $showViewSalesOrderLink
     * @param string $formType
     * @param string $fromEmail
     * @param string $fromName
     * @param string $emailAddress
     * @param string $ccEmailAddress
     * @param string $bccEmailAddress
     * @param string $replyToEmailAddress
     * @param string $replyToDisplayName
     * @param string $emailNotes
     * @param string $emailNotesHTML
     * @param string $emailSubject
     * @param string $emailTemplateID
     * @param string $emailTemplateName
     * @param string $customerId
     * @param string $custFullName
     * @param string $transId
     * @param string $transDetail
     * @param string $invoiceNumber
     * @param string $poNum
     * @param string $soNum
     * @param string $orderId
     * @param string $description
     * @param \eBizCharge\StructType\Address $billingAddress
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @param string $approvedURL
     * @param string $declinedURL
     * @param string $errorURL
     * @param string $payByType
     * @param string $allowedPaymentMethods
     * @param string $countryCode
     * @param string $currencyCode
     * @param string $processingCommand
     * @param string $softwareId
     * @param string $transactionLookupKey
     * @param \eBizCharge\ArrayType\ArrayOfTransactionLineItem $lineItems
     * @param string $clerk
     * @param string $terminal
     * @param string $invoiceInternalId
     * @param \eBizCharge\StructType\DeviceSettings $deviceSettings
     * @param string $documentTypeId
     * @param string $salesOrderInternalId
     */
    public function __construct($sendEmailToCustomer = null, $date = null, $dueDate = null, $totalAmount = null, $amountDue = null, $tipAmount = null, $shippingAmount = null, $dutyAmount = null, $taxAmount = null, $displayDefaultResultPage = null, $savePaymentMethod = null, $showSavedPaymentMethods = null, $showViewInvoiceLink = null, $showViewSalesOrderLink = null, $formType = null, $fromEmail = null, $fromName = null, $emailAddress = null, $ccEmailAddress = null, $bccEmailAddress = null, $replyToEmailAddress = null, $replyToDisplayName = null, $emailNotes = null, $emailNotesHTML = null, $emailSubject = null, $emailTemplateID = null, $emailTemplateName = null, $customerId = null, $custFullName = null, $transId = null, $transDetail = null, $invoiceNumber = null, $poNum = null, $soNum = null, $orderId = null, $description = null, \eBizCharge\StructType\Address $billingAddress = null, \eBizCharge\StructType\Address $shippingAddress = null, $approvedURL = null, $declinedURL = null, $errorURL = null, $payByType = null, $allowedPaymentMethods = null, $countryCode = null, $currencyCode = null, $processingCommand = null, $softwareId = null, $transactionLookupKey = null, \eBizCharge\ArrayType\ArrayOfTransactionLineItem $lineItems = null, $clerk = null, $terminal = null, $invoiceInternalId = null, \eBizCharge\StructType\DeviceSettings $deviceSettings = null, $documentTypeId = null, $salesOrderInternalId = null)
    {
        $this
            ->setSendEmailToCustomer($sendEmailToCustomer)
            ->setDate($date)
            ->setDueDate($dueDate)
            ->setTotalAmount($totalAmount)
            ->setAmountDue($amountDue)
            ->setTipAmount($tipAmount)
            ->setShippingAmount($shippingAmount)
            ->setDutyAmount($dutyAmount)
            ->setTaxAmount($taxAmount)
            ->setDisplayDefaultResultPage($displayDefaultResultPage)
            ->setSavePaymentMethod($savePaymentMethod)
            ->setShowSavedPaymentMethods($showSavedPaymentMethods)
            ->setShowViewInvoiceLink($showViewInvoiceLink)
            ->setShowViewSalesOrderLink($showViewSalesOrderLink)
            ->setFormType($formType)
            ->setFromEmail($fromEmail)
            ->setFromName($fromName)
            ->setEmailAddress($emailAddress)
            ->setCcEmailAddress($ccEmailAddress)
            ->setBccEmailAddress($bccEmailAddress)
            ->setReplyToEmailAddress($replyToEmailAddress)
            ->setReplyToDisplayName($replyToDisplayName)
            ->setEmailNotes($emailNotes)
            ->setEmailNotesHTML($emailNotesHTML)
            ->setEmailSubject($emailSubject)
            ->setEmailTemplateID($emailTemplateID)
            ->setEmailTemplateName($emailTemplateName)
            ->setCustomerId($customerId)
            ->setCustFullName($custFullName)
            ->setTransId($transId)
            ->setTransDetail($transDetail)
            ->setInvoiceNumber($invoiceNumber)
            ->setPoNum($poNum)
            ->setSoNum($soNum)
            ->setOrderId($orderId)
            ->setDescription($description)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress)
            ->setApprovedURL($approvedURL)
            ->setDeclinedURL($declinedURL)
            ->setErrorURL($errorURL)
            ->setPayByType($payByType)
            ->setAllowedPaymentMethods($allowedPaymentMethods)
            ->setCountryCode($countryCode)
            ->setCurrencyCode($currencyCode)
            ->setProcessingCommand($processingCommand)
            ->setSoftwareId($softwareId)
            ->setTransactionLookupKey($transactionLookupKey)
            ->setLineItems($lineItems)
            ->setClerk($clerk)
            ->setTerminal($terminal)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setDeviceSettings($deviceSettings)
            ->setDocumentTypeId($documentTypeId)
            ->setSalesOrderInternalId($salesOrderInternalId);
    }
    /**
     * Get SendEmailToCustomer value
     * @return bool
     */
    public function getSendEmailToCustomer()
    {
        return $this->SendEmailToCustomer;
    }
    /**
     * Set SendEmailToCustomer value
     * @param bool $sendEmailToCustomer
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setSendEmailToCustomer($sendEmailToCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmailToCustomer) && !is_bool($sendEmailToCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmailToCustomer, true), gettype($sendEmailToCustomer)), __LINE__);
        }
        $this->SendEmailToCustomer = $sendEmailToCustomer;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get TipAmount value
     * @return float
     */
    public function getTipAmount()
    {
        return $this->TipAmount;
    }
    /**
     * Set TipAmount value
     * @param float $tipAmount
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTipAmount($tipAmount = null)
    {
        // validation for constraint: float
        if (!is_null($tipAmount) && !(is_float($tipAmount) || is_numeric($tipAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipAmount, true), gettype($tipAmount)), __LINE__);
        }
        $this->TipAmount = $tipAmount;
        return $this;
    }
    /**
     * Get ShippingAmount value
     * @return float
     */
    public function getShippingAmount()
    {
        return $this->ShippingAmount;
    }
    /**
     * Set ShippingAmount value
     * @param float $shippingAmount
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setShippingAmount($shippingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($shippingAmount) && !(is_float($shippingAmount) || is_numeric($shippingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingAmount, true), gettype($shippingAmount)), __LINE__);
        }
        $this->ShippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get DutyAmount value
     * @return float
     */
    public function getDutyAmount()
    {
        return $this->DutyAmount;
    }
    /**
     * Set DutyAmount value
     * @param float $dutyAmount
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDutyAmount($dutyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dutyAmount) && !(is_float($dutyAmount) || is_numeric($dutyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dutyAmount, true), gettype($dutyAmount)), __LINE__);
        }
        $this->DutyAmount = $dutyAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get DisplayDefaultResultPage value
     * @return int
     */
    public function getDisplayDefaultResultPage()
    {
        return $this->DisplayDefaultResultPage;
    }
    /**
     * Set DisplayDefaultResultPage value
     * @param int $displayDefaultResultPage
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDisplayDefaultResultPage($displayDefaultResultPage = null)
    {
        // validation for constraint: int
        if (!is_null($displayDefaultResultPage) && !(is_int($displayDefaultResultPage) || ctype_digit($displayDefaultResultPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayDefaultResultPage, true), gettype($displayDefaultResultPage)), __LINE__);
        }
        $this->DisplayDefaultResultPage = $displayDefaultResultPage;
        return $this;
    }
    /**
     * Get SavePaymentMethod value
     * @return bool
     */
    public function getSavePaymentMethod()
    {
        return $this->SavePaymentMethod;
    }
    /**
     * Set SavePaymentMethod value
     * @param bool $savePaymentMethod
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setSavePaymentMethod($savePaymentMethod = null)
    {
        // validation for constraint: boolean
        if (!is_null($savePaymentMethod) && !is_bool($savePaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($savePaymentMethod, true), gettype($savePaymentMethod)), __LINE__);
        }
        $this->SavePaymentMethod = $savePaymentMethod;
        return $this;
    }
    /**
     * Get ShowSavedPaymentMethods value
     * @return bool
     */
    public function getShowSavedPaymentMethods()
    {
        return $this->ShowSavedPaymentMethods;
    }
    /**
     * Set ShowSavedPaymentMethods value
     * @param bool $showSavedPaymentMethods
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setShowSavedPaymentMethods($showSavedPaymentMethods = null)
    {
        // validation for constraint: boolean
        if (!is_null($showSavedPaymentMethods) && !is_bool($showSavedPaymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showSavedPaymentMethods, true), gettype($showSavedPaymentMethods)), __LINE__);
        }
        $this->ShowSavedPaymentMethods = $showSavedPaymentMethods;
        return $this;
    }
    /**
     * Get ShowViewInvoiceLink value
     * @return bool
     */
    public function getShowViewInvoiceLink()
    {
        return $this->ShowViewInvoiceLink;
    }
    /**
     * Set ShowViewInvoiceLink value
     * @param bool $showViewInvoiceLink
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setShowViewInvoiceLink($showViewInvoiceLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($showViewInvoiceLink) && !is_bool($showViewInvoiceLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showViewInvoiceLink, true), gettype($showViewInvoiceLink)), __LINE__);
        }
        $this->ShowViewInvoiceLink = $showViewInvoiceLink;
        return $this;
    }
    /**
     * Get ShowViewSalesOrderLink value
     * @return bool
     */
    public function getShowViewSalesOrderLink()
    {
        return $this->ShowViewSalesOrderLink;
    }
    /**
     * Set ShowViewSalesOrderLink value
     * @param bool $showViewSalesOrderLink
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setShowViewSalesOrderLink($showViewSalesOrderLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($showViewSalesOrderLink) && !is_bool($showViewSalesOrderLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showViewSalesOrderLink, true), gettype($showViewSalesOrderLink)), __LINE__);
        }
        $this->ShowViewSalesOrderLink = $showViewSalesOrderLink;
        return $this;
    }
    /**
     * Get FormType value
     * @return string|null
     */
    public function getFormType()
    {
        return $this->FormType;
    }
    /**
     * Set FormType value
     * @param string $formType
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setFormType($formType = null)
    {
        // validation for constraint: string
        if (!is_null($formType) && !is_string($formType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formType, true), gettype($formType)), __LINE__);
        }
        $this->FormType = $formType;
        return $this;
    }
    /**
     * Get FromEmail value
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->FromEmail;
    }
    /**
     * Set FromEmail value
     * @param string $fromEmail
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setFromEmail($fromEmail = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmail) && !is_string($fromEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmail, true), gettype($fromEmail)), __LINE__);
        }
        $this->FromEmail = $fromEmail;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CcEmailAddress value
     * @return string|null
     */
    public function getCcEmailAddress()
    {
        return $this->CcEmailAddress;
    }
    /**
     * Set CcEmailAddress value
     * @param string $ccEmailAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setCcEmailAddress($ccEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ccEmailAddress) && !is_string($ccEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccEmailAddress, true), gettype($ccEmailAddress)), __LINE__);
        }
        $this->CcEmailAddress = $ccEmailAddress;
        return $this;
    }
    /**
     * Get BccEmailAddress value
     * @return string|null
     */
    public function getBccEmailAddress()
    {
        return $this->BccEmailAddress;
    }
    /**
     * Set BccEmailAddress value
     * @param string $bccEmailAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setBccEmailAddress($bccEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bccEmailAddress) && !is_string($bccEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bccEmailAddress, true), gettype($bccEmailAddress)), __LINE__);
        }
        $this->BccEmailAddress = $bccEmailAddress;
        return $this;
    }
    /**
     * Get ReplyToEmailAddress value
     * @return string|null
     */
    public function getReplyToEmailAddress()
    {
        return $this->ReplyToEmailAddress;
    }
    /**
     * Set ReplyToEmailAddress value
     * @param string $replyToEmailAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setReplyToEmailAddress($replyToEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($replyToEmailAddress) && !is_string($replyToEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyToEmailAddress, true), gettype($replyToEmailAddress)), __LINE__);
        }
        $this->ReplyToEmailAddress = $replyToEmailAddress;
        return $this;
    }
    /**
     * Get ReplyToDisplayName value
     * @return string|null
     */
    public function getReplyToDisplayName()
    {
        return $this->ReplyToDisplayName;
    }
    /**
     * Set ReplyToDisplayName value
     * @param string $replyToDisplayName
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setReplyToDisplayName($replyToDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($replyToDisplayName) && !is_string($replyToDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyToDisplayName, true), gettype($replyToDisplayName)), __LINE__);
        }
        $this->ReplyToDisplayName = $replyToDisplayName;
        return $this;
    }
    /**
     * Get EmailNotes value
     * @return string|null
     */
    public function getEmailNotes()
    {
        return $this->EmailNotes;
    }
    /**
     * Set EmailNotes value
     * @param string $emailNotes
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailNotes($emailNotes = null)
    {
        // validation for constraint: string
        if (!is_null($emailNotes) && !is_string($emailNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailNotes, true), gettype($emailNotes)), __LINE__);
        }
        $this->EmailNotes = $emailNotes;
        return $this;
    }
    /**
     * Get EmailNotesHTML value
     * @return string|null
     */
    public function getEmailNotesHTML()
    {
        return $this->EmailNotesHTML;
    }
    /**
     * Set EmailNotesHTML value
     * @param string $emailNotesHTML
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailNotesHTML($emailNotesHTML = null)
    {
        // validation for constraint: string
        if (!is_null($emailNotesHTML) && !is_string($emailNotesHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailNotesHTML, true), gettype($emailNotesHTML)), __LINE__);
        }
        $this->EmailNotesHTML = $emailNotesHTML;
        return $this;
    }
    /**
     * Get EmailSubject value
     * @return string|null
     */
    public function getEmailSubject()
    {
        return $this->EmailSubject;
    }
    /**
     * Set EmailSubject value
     * @param string $emailSubject
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSubject, true), gettype($emailSubject)), __LINE__);
        }
        $this->EmailSubject = $emailSubject;
        return $this;
    }
    /**
     * Get EmailTemplateID value
     * @return string|null
     */
    public function getEmailTemplateID()
    {
        return $this->EmailTemplateID;
    }
    /**
     * Set EmailTemplateID value
     * @param string $emailTemplateID
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailTemplateID($emailTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateID) && !is_string($emailTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateID, true), gettype($emailTemplateID)), __LINE__);
        }
        $this->EmailTemplateID = $emailTemplateID;
        return $this;
    }
    /**
     * Get EmailTemplateName value
     * @return string|null
     */
    public function getEmailTemplateName()
    {
        return $this->EmailTemplateName;
    }
    /**
     * Set EmailTemplateName value
     * @param string $emailTemplateName
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setEmailTemplateName($emailTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateName) && !is_string($emailTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateName, true), gettype($emailTemplateName)), __LINE__);
        }
        $this->EmailTemplateName = $emailTemplateName;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustFullName value
     * @return string|null
     */
    public function getCustFullName()
    {
        return $this->CustFullName;
    }
    /**
     * Set CustFullName value
     * @param string $custFullName
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setCustFullName($custFullName = null)
    {
        // validation for constraint: string
        if (!is_null($custFullName) && !is_string($custFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custFullName, true), gettype($custFullName)), __LINE__);
        }
        $this->CustFullName = $custFullName;
        return $this;
    }
    /**
     * Get TransId value
     * @return string|null
     */
    public function getTransId()
    {
        return $this->TransId;
    }
    /**
     * Set TransId value
     * @param string $transId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTransId($transId = null)
    {
        // validation for constraint: string
        if (!is_null($transId) && !is_string($transId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transId, true), gettype($transId)), __LINE__);
        }
        $this->TransId = $transId;
        return $this;
    }
    /**
     * Get TransDetail value
     * @return string|null
     */
    public function getTransDetail()
    {
        return $this->TransDetail;
    }
    /**
     * Set TransDetail value
     * @param string $transDetail
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTransDetail($transDetail = null)
    {
        // validation for constraint: string
        if (!is_null($transDetail) && !is_string($transDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transDetail, true), gettype($transDetail)), __LINE__);
        }
        $this->TransDetail = $transDetail;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get PoNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->PoNum;
    }
    /**
     * Set PoNum value
     * @param string $poNum
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->PoNum = $poNum;
        return $this;
    }
    /**
     * Get SoNum value
     * @return string|null
     */
    public function getSoNum()
    {
        return $this->SoNum;
    }
    /**
     * Set SoNum value
     * @param string $soNum
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setSoNum($soNum = null)
    {
        // validation for constraint: string
        if (!is_null($soNum) && !is_string($soNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soNum, true), gettype($soNum)), __LINE__);
        }
        $this->SoNum = $soNum;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\Address $billingAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setBillingAddress(\eBizCharge\StructType\Address $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setShippingAddress(\eBizCharge\StructType\Address $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get ApprovedURL value
     * @return string|null
     */
    public function getApprovedURL()
    {
        return $this->ApprovedURL;
    }
    /**
     * Set ApprovedURL value
     * @param string $approvedURL
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setApprovedURL($approvedURL = null)
    {
        // validation for constraint: string
        if (!is_null($approvedURL) && !is_string($approvedURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvedURL, true), gettype($approvedURL)), __LINE__);
        }
        $this->ApprovedURL = $approvedURL;
        return $this;
    }
    /**
     * Get DeclinedURL value
     * @return string|null
     */
    public function getDeclinedURL()
    {
        return $this->DeclinedURL;
    }
    /**
     * Set DeclinedURL value
     * @param string $declinedURL
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDeclinedURL($declinedURL = null)
    {
        // validation for constraint: string
        if (!is_null($declinedURL) && !is_string($declinedURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declinedURL, true), gettype($declinedURL)), __LINE__);
        }
        $this->DeclinedURL = $declinedURL;
        return $this;
    }
    /**
     * Get ErrorURL value
     * @return string|null
     */
    public function getErrorURL()
    {
        return $this->ErrorURL;
    }
    /**
     * Set ErrorURL value
     * @param string $errorURL
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setErrorURL($errorURL = null)
    {
        // validation for constraint: string
        if (!is_null($errorURL) && !is_string($errorURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorURL, true), gettype($errorURL)), __LINE__);
        }
        $this->ErrorURL = $errorURL;
        return $this;
    }
    /**
     * Get PayByType value
     * @return string|null
     */
    public function getPayByType()
    {
        return $this->PayByType;
    }
    /**
     * Set PayByType value
     * @param string $payByType
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setPayByType($payByType = null)
    {
        // validation for constraint: string
        if (!is_null($payByType) && !is_string($payByType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payByType, true), gettype($payByType)), __LINE__);
        }
        $this->PayByType = $payByType;
        return $this;
    }
    /**
     * Get AllowedPaymentMethods value
     * @return string|null
     */
    public function getAllowedPaymentMethods()
    {
        return $this->AllowedPaymentMethods;
    }
    /**
     * Set AllowedPaymentMethods value
     * @param string $allowedPaymentMethods
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setAllowedPaymentMethods($allowedPaymentMethods = null)
    {
        // validation for constraint: string
        if (!is_null($allowedPaymentMethods) && !is_string($allowedPaymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowedPaymentMethods, true), gettype($allowedPaymentMethods)), __LINE__);
        }
        $this->AllowedPaymentMethods = $allowedPaymentMethods;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ProcessingCommand value
     * @return string|null
     */
    public function getProcessingCommand()
    {
        return $this->ProcessingCommand;
    }
    /**
     * Set ProcessingCommand value
     * @param string $processingCommand
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setProcessingCommand($processingCommand = null)
    {
        // validation for constraint: string
        if (!is_null($processingCommand) && !is_string($processingCommand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingCommand, true), gettype($processingCommand)), __LINE__);
        }
        $this->ProcessingCommand = $processingCommand;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get TransactionLookupKey value
     * @return string|null
     */
    public function getTransactionLookupKey()
    {
        return $this->TransactionLookupKey;
    }
    /**
     * Set TransactionLookupKey value
     * @param string $transactionLookupKey
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTransactionLookupKey($transactionLookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($transactionLookupKey) && !is_string($transactionLookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionLookupKey, true), gettype($transactionLookupKey)), __LINE__);
        }
        $this->TransactionLookupKey = $transactionLookupKey;
        return $this;
    }
    /**
     * Get LineItems value
     * @return \eBizCharge\ArrayType\ArrayOfTransactionLineItem|null
     */
    public function getLineItems()
    {
        return $this->LineItems;
    }
    /**
     * Set LineItems value
     * @param \eBizCharge\ArrayType\ArrayOfTransactionLineItem $lineItems
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setLineItems(\eBizCharge\ArrayType\ArrayOfTransactionLineItem $lineItems = null)
    {
        $this->LineItems = $lineItems;
        return $this;
    }
    /**
     * Get Clerk value
     * @return string|null
     */
    public function getClerk()
    {
        return $this->Clerk;
    }
    /**
     * Set Clerk value
     * @param string $clerk
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setClerk($clerk = null)
    {
        // validation for constraint: string
        if (!is_null($clerk) && !is_string($clerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clerk, true), gettype($clerk)), __LINE__);
        }
        $this->Clerk = $clerk;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get InvoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->InvoiceInternalId;
    }
    /**
     * Set InvoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->InvoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get DeviceSettings value
     * @return \eBizCharge\StructType\DeviceSettings|null
     */
    public function getDeviceSettings()
    {
        return $this->DeviceSettings;
    }
    /**
     * Set DeviceSettings value
     * @param \eBizCharge\StructType\DeviceSettings $deviceSettings
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDeviceSettings(\eBizCharge\StructType\DeviceSettings $deviceSettings = null)
    {
        $this->DeviceSettings = $deviceSettings;
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return $this->DocumentTypeId;
    }
    /**
     * Set DocumentTypeId value
     * @param string $documentTypeId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        $this->DocumentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get SalesOrderInternalId value
     * @return string|null
     */
    public function getSalesOrderInternalId()
    {
        return $this->SalesOrderInternalId;
    }
    /**
     * Set SalesOrderInternalId value
     * @param string $salesOrderInternalId
     * @return \eBizCharge\StructType\EbizWebForm
     */
    public function setSalesOrderInternalId($salesOrderInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderInternalId) && !is_string($salesOrderInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderInternalId, true), gettype($salesOrderInternalId)), __LINE__);
        }
        $this->SalesOrderInternalId = $salesOrderInternalId;
        return $this;
    }
}
