<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchSearchResult StructType
 * @subpackage Structs
 */
class BatchSearchResult extends AbstractStructBase
{
    /**
     * The Batches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfBatchStatus
     */
    public $Batches;
    /**
     * The BatchesMatched
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchesMatched;
    /**
     * The BatchesReturned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchesReturned;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Limit;
    /**
     * The StartIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartIndex;
    /**
     * Constructor method for BatchSearchResult
     * @uses BatchSearchResult::setBatches()
     * @uses BatchSearchResult::setBatchesMatched()
     * @uses BatchSearchResult::setBatchesReturned()
     * @uses BatchSearchResult::setLimit()
     * @uses BatchSearchResult::setStartIndex()
     * @param \eBizCharge\ArrayType\ArrayOfBatchStatus $batches
     * @param string $batchesMatched
     * @param string $batchesReturned
     * @param string $limit
     * @param string $startIndex
     */
    public function __construct(\eBizCharge\ArrayType\ArrayOfBatchStatus $batches = null, $batchesMatched = null, $batchesReturned = null, $limit = null, $startIndex = null)
    {
        $this
            ->setBatches($batches)
            ->setBatchesMatched($batchesMatched)
            ->setBatchesReturned($batchesReturned)
            ->setLimit($limit)
            ->setStartIndex($startIndex);
    }
    /**
     * Get Batches value
     * @return \eBizCharge\ArrayType\ArrayOfBatchStatus|null
     */
    public function getBatches()
    {
        return $this->Batches;
    }
    /**
     * Set Batches value
     * @param \eBizCharge\ArrayType\ArrayOfBatchStatus $batches
     * @return \eBizCharge\StructType\BatchSearchResult
     */
    public function setBatches(\eBizCharge\ArrayType\ArrayOfBatchStatus $batches = null)
    {
        $this->Batches = $batches;
        return $this;
    }
    /**
     * Get BatchesMatched value
     * @return string|null
     */
    public function getBatchesMatched()
    {
        return $this->BatchesMatched;
    }
    /**
     * Set BatchesMatched value
     * @param string $batchesMatched
     * @return \eBizCharge\StructType\BatchSearchResult
     */
    public function setBatchesMatched($batchesMatched = null)
    {
        // validation for constraint: string
        if (!is_null($batchesMatched) && !is_string($batchesMatched)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchesMatched, true), gettype($batchesMatched)), __LINE__);
        }
        $this->BatchesMatched = $batchesMatched;
        return $this;
    }
    /**
     * Get BatchesReturned value
     * @return string|null
     */
    public function getBatchesReturned()
    {
        return $this->BatchesReturned;
    }
    /**
     * Set BatchesReturned value
     * @param string $batchesReturned
     * @return \eBizCharge\StructType\BatchSearchResult
     */
    public function setBatchesReturned($batchesReturned = null)
    {
        // validation for constraint: string
        if (!is_null($batchesReturned) && !is_string($batchesReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchesReturned, true), gettype($batchesReturned)), __LINE__);
        }
        $this->BatchesReturned = $batchesReturned;
        return $this;
    }
    /**
     * Get Limit value
     * @return string|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param string $limit
     * @return \eBizCharge\StructType\BatchSearchResult
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: string
        if (!is_null($limit) && !is_string($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get StartIndex value
     * @return string|null
     */
    public function getStartIndex()
    {
        return $this->StartIndex;
    }
    /**
     * Set StartIndex value
     * @param string $startIndex
     * @return \eBizCharge\StructType\BatchSearchResult
     */
    public function setStartIndex($startIndex = null)
    {
        // validation for constraint: string
        if (!is_null($startIndex) && !is_string($startIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startIndex, true), gettype($startIndex)), __LINE__);
        }
        $this->StartIndex = $startIndex;
        return $this;
    }
}
