<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReceipt ArrayType
 * @subpackage Arrays
 */
class ArrayOfReceipt extends AbstractStructArrayBase
{
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\Receipt[]
     */
    public $Receipt;
    /**
     * Constructor method for ArrayOfReceipt
     * @uses ArrayOfReceipt::setReceipt()
     * @param \eBizCharge\StructType\Receipt[] $receipt
     */
    public function __construct(array $receipt = array())
    {
        $this
            ->setReceipt($receipt);
    }
    /**
     * Get Receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\Receipt[]|null
     */
    public function getReceipt()
    {
        return isset($this->Receipt) ? $this->Receipt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptForArrayConstraintsFromSetReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReceiptReceiptItem) {
            // validation for constraint: itemType
            if (!$arrayOfReceiptReceiptItem instanceof \eBizCharge\StructType\Receipt) {
                $invalidValues[] = is_object($arrayOfReceiptReceiptItem) ? get_class($arrayOfReceiptReceiptItem) : sprintf('%s(%s)', gettype($arrayOfReceiptReceiptItem), var_export($arrayOfReceiptReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt property can only contain items of type \eBizCharge\StructType\Receipt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\Receipt[] $receipt
     * @return \eBizCharge\ArrayType\ArrayOfReceipt
     */
    public function setReceipt(array $receipt = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptArrayErrorMessage = self::validateReceiptForArrayConstraintsFromSetReceipt($receipt))) {
            throw new \InvalidArgumentException($receiptArrayErrorMessage, __LINE__);
        }
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->Receipt);
        } else {
            $this->Receipt = $receipt;
        }
        return $this;
    }
    /**
     * Add item to Receipt value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\Receipt $item
     * @return \eBizCharge\ArrayType\ArrayOfReceipt
     */
    public function addToReceipt(\eBizCharge\StructType\Receipt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\Receipt) {
            throw new \InvalidArgumentException(sprintf('The Receipt property can only contain items of type \eBizCharge\StructType\Receipt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\Receipt|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\Receipt|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\Receipt|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\Receipt|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\Receipt|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Receipt
     */
    public function getAttributeName()
    {
        return 'Receipt';
    }
}
