<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt StructType
 * @subpackage Structs
 */
class Receipt extends AbstractStructBase
{
    /**
     * The ReceiptRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptRefNum;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The FromEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromEmail;
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The TemplateHTML
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateHTML;
    /**
     * The TemplateText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateText;
    /**
     * Constructor method for Receipt
     * @uses Receipt::setReceiptRefNum()
     * @uses Receipt::setName()
     * @uses Receipt::setSubject()
     * @uses Receipt::setFromEmail()
     * @uses Receipt::setTarget()
     * @uses Receipt::setContentType()
     * @uses Receipt::setTemplateHTML()
     * @uses Receipt::setTemplateText()
     * @param string $receiptRefNum
     * @param string $name
     * @param string $subject
     * @param string $fromEmail
     * @param string $target
     * @param string $contentType
     * @param string $templateHTML
     * @param string $templateText
     */
    public function __construct($receiptRefNum = null, $name = null, $subject = null, $fromEmail = null, $target = null, $contentType = null, $templateHTML = null, $templateText = null)
    {
        $this
            ->setReceiptRefNum($receiptRefNum)
            ->setName($name)
            ->setSubject($subject)
            ->setFromEmail($fromEmail)
            ->setTarget($target)
            ->setContentType($contentType)
            ->setTemplateHTML($templateHTML)
            ->setTemplateText($templateText);
    }
    /**
     * Get ReceiptRefNum value
     * @return string|null
     */
    public function getReceiptRefNum()
    {
        return $this->ReceiptRefNum;
    }
    /**
     * Set ReceiptRefNum value
     * @param string $receiptRefNum
     * @return \eBizCharge\StructType\Receipt
     */
    public function setReceiptRefNum($receiptRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($receiptRefNum) && !is_string($receiptRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptRefNum, true), gettype($receiptRefNum)), __LINE__);
        }
        $this->ReceiptRefNum = $receiptRefNum;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \eBizCharge\StructType\Receipt
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \eBizCharge\StructType\Receipt
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get FromEmail value
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->FromEmail;
    }
    /**
     * Set FromEmail value
     * @param string $fromEmail
     * @return \eBizCharge\StructType\Receipt
     */
    public function setFromEmail($fromEmail = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmail) && !is_string($fromEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmail, true), gettype($fromEmail)), __LINE__);
        }
        $this->FromEmail = $fromEmail;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \eBizCharge\StructType\Receipt
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \eBizCharge\StructType\Receipt
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get TemplateHTML value
     * @return string|null
     */
    public function getTemplateHTML()
    {
        return $this->TemplateHTML;
    }
    /**
     * Set TemplateHTML value
     * @param string $templateHTML
     * @return \eBizCharge\StructType\Receipt
     */
    public function setTemplateHTML($templateHTML = null)
    {
        // validation for constraint: string
        if (!is_null($templateHTML) && !is_string($templateHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateHTML, true), gettype($templateHTML)), __LINE__);
        }
        $this->TemplateHTML = $templateHTML;
        return $this;
    }
    /**
     * Get TemplateText value
     * @return string|null
     */
    public function getTemplateText()
    {
        return $this->TemplateText;
    }
    /**
     * Set TemplateText value
     * @param string $templateText
     * @return \eBizCharge\StructType\Receipt
     */
    public function setTemplateText($templateText = null)
    {
        // validation for constraint: string
        if (!is_null($templateText) && !is_string($templateText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateText, true), gettype($templateText)), __LINE__);
        }
        $this->TemplateText = $templateText;
        return $this;
    }
}
