<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardExpirationCounts StructType
 * @subpackage Structs
 */
class CardExpirationCounts extends AbstractStructBase
{
    /**
     * The ExpiredCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpiredCreditCardsCount;
    /**
     * The ExpireThisMonthCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireThisMonthCreditCardsCount;
    /**
     * The ExpireNextMonthCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireNextMonthCreditCardsCount;
    /**
     * The ExpireWithin3MonthCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireWithin3MonthCreditCardsCount;
    /**
     * The ExpireWithin6MonthCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireWithin6MonthCreditCardsCount;
    /**
     * The ExpireWithinaYearCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireWithinaYearCreditCardsCount;
    /**
     * The ExpireWithinXDaysCreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireWithinXDaysCreditCardsCount;
    /**
     * The CustomerInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Customer
     */
    public $CustomerInformation;
    /**
     * Constructor method for CardExpirationCounts
     * @uses CardExpirationCounts::setExpiredCreditCardsCount()
     * @uses CardExpirationCounts::setExpireThisMonthCreditCardsCount()
     * @uses CardExpirationCounts::setExpireNextMonthCreditCardsCount()
     * @uses CardExpirationCounts::setExpireWithin3MonthCreditCardsCount()
     * @uses CardExpirationCounts::setExpireWithin6MonthCreditCardsCount()
     * @uses CardExpirationCounts::setExpireWithinaYearCreditCardsCount()
     * @uses CardExpirationCounts::setExpireWithinXDaysCreditCardsCount()
     * @uses CardExpirationCounts::setCustomerInformation()
     * @param int $expiredCreditCardsCount
     * @param int $expireThisMonthCreditCardsCount
     * @param int $expireNextMonthCreditCardsCount
     * @param int $expireWithin3MonthCreditCardsCount
     * @param int $expireWithin6MonthCreditCardsCount
     * @param int $expireWithinaYearCreditCardsCount
     * @param int $expireWithinXDaysCreditCardsCount
     * @param \eBizCharge\StructType\Customer $customerInformation
     */
    public function __construct($expiredCreditCardsCount = null, $expireThisMonthCreditCardsCount = null, $expireNextMonthCreditCardsCount = null, $expireWithin3MonthCreditCardsCount = null, $expireWithin6MonthCreditCardsCount = null, $expireWithinaYearCreditCardsCount = null, $expireWithinXDaysCreditCardsCount = null, \eBizCharge\StructType\Customer $customerInformation = null)
    {
        $this
            ->setExpiredCreditCardsCount($expiredCreditCardsCount)
            ->setExpireThisMonthCreditCardsCount($expireThisMonthCreditCardsCount)
            ->setExpireNextMonthCreditCardsCount($expireNextMonthCreditCardsCount)
            ->setExpireWithin3MonthCreditCardsCount($expireWithin3MonthCreditCardsCount)
            ->setExpireWithin6MonthCreditCardsCount($expireWithin6MonthCreditCardsCount)
            ->setExpireWithinaYearCreditCardsCount($expireWithinaYearCreditCardsCount)
            ->setExpireWithinXDaysCreditCardsCount($expireWithinXDaysCreditCardsCount)
            ->setCustomerInformation($customerInformation);
    }
    /**
     * Get ExpiredCreditCardsCount value
     * @return int
     */
    public function getExpiredCreditCardsCount()
    {
        return $this->ExpiredCreditCardsCount;
    }
    /**
     * Set ExpiredCreditCardsCount value
     * @param int $expiredCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpiredCreditCardsCount($expiredCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expiredCreditCardsCount) && !(is_int($expiredCreditCardsCount) || ctype_digit($expiredCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiredCreditCardsCount, true), gettype($expiredCreditCardsCount)), __LINE__);
        }
        $this->ExpiredCreditCardsCount = $expiredCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireThisMonthCreditCardsCount value
     * @return int
     */
    public function getExpireThisMonthCreditCardsCount()
    {
        return $this->ExpireThisMonthCreditCardsCount;
    }
    /**
     * Set ExpireThisMonthCreditCardsCount value
     * @param int $expireThisMonthCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireThisMonthCreditCardsCount($expireThisMonthCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireThisMonthCreditCardsCount) && !(is_int($expireThisMonthCreditCardsCount) || ctype_digit($expireThisMonthCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireThisMonthCreditCardsCount, true), gettype($expireThisMonthCreditCardsCount)), __LINE__);
        }
        $this->ExpireThisMonthCreditCardsCount = $expireThisMonthCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireNextMonthCreditCardsCount value
     * @return int
     */
    public function getExpireNextMonthCreditCardsCount()
    {
        return $this->ExpireNextMonthCreditCardsCount;
    }
    /**
     * Set ExpireNextMonthCreditCardsCount value
     * @param int $expireNextMonthCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireNextMonthCreditCardsCount($expireNextMonthCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireNextMonthCreditCardsCount) && !(is_int($expireNextMonthCreditCardsCount) || ctype_digit($expireNextMonthCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireNextMonthCreditCardsCount, true), gettype($expireNextMonthCreditCardsCount)), __LINE__);
        }
        $this->ExpireNextMonthCreditCardsCount = $expireNextMonthCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireWithin3MonthCreditCardsCount value
     * @return int
     */
    public function getExpireWithin3MonthCreditCardsCount()
    {
        return $this->ExpireWithin3MonthCreditCardsCount;
    }
    /**
     * Set ExpireWithin3MonthCreditCardsCount value
     * @param int $expireWithin3MonthCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireWithin3MonthCreditCardsCount($expireWithin3MonthCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireWithin3MonthCreditCardsCount) && !(is_int($expireWithin3MonthCreditCardsCount) || ctype_digit($expireWithin3MonthCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireWithin3MonthCreditCardsCount, true), gettype($expireWithin3MonthCreditCardsCount)), __LINE__);
        }
        $this->ExpireWithin3MonthCreditCardsCount = $expireWithin3MonthCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireWithin6MonthCreditCardsCount value
     * @return int
     */
    public function getExpireWithin6MonthCreditCardsCount()
    {
        return $this->ExpireWithin6MonthCreditCardsCount;
    }
    /**
     * Set ExpireWithin6MonthCreditCardsCount value
     * @param int $expireWithin6MonthCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireWithin6MonthCreditCardsCount($expireWithin6MonthCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireWithin6MonthCreditCardsCount) && !(is_int($expireWithin6MonthCreditCardsCount) || ctype_digit($expireWithin6MonthCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireWithin6MonthCreditCardsCount, true), gettype($expireWithin6MonthCreditCardsCount)), __LINE__);
        }
        $this->ExpireWithin6MonthCreditCardsCount = $expireWithin6MonthCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireWithinaYearCreditCardsCount value
     * @return int
     */
    public function getExpireWithinaYearCreditCardsCount()
    {
        return $this->ExpireWithinaYearCreditCardsCount;
    }
    /**
     * Set ExpireWithinaYearCreditCardsCount value
     * @param int $expireWithinaYearCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireWithinaYearCreditCardsCount($expireWithinaYearCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireWithinaYearCreditCardsCount) && !(is_int($expireWithinaYearCreditCardsCount) || ctype_digit($expireWithinaYearCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireWithinaYearCreditCardsCount, true), gettype($expireWithinaYearCreditCardsCount)), __LINE__);
        }
        $this->ExpireWithinaYearCreditCardsCount = $expireWithinaYearCreditCardsCount;
        return $this;
    }
    /**
     * Get ExpireWithinXDaysCreditCardsCount value
     * @return int
     */
    public function getExpireWithinXDaysCreditCardsCount()
    {
        return $this->ExpireWithinXDaysCreditCardsCount;
    }
    /**
     * Set ExpireWithinXDaysCreditCardsCount value
     * @param int $expireWithinXDaysCreditCardsCount
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setExpireWithinXDaysCreditCardsCount($expireWithinXDaysCreditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($expireWithinXDaysCreditCardsCount) && !(is_int($expireWithinXDaysCreditCardsCount) || ctype_digit($expireWithinXDaysCreditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireWithinXDaysCreditCardsCount, true), gettype($expireWithinXDaysCreditCardsCount)), __LINE__);
        }
        $this->ExpireWithinXDaysCreditCardsCount = $expireWithinXDaysCreditCardsCount;
        return $this;
    }
    /**
     * Get CustomerInformation value
     * @return \eBizCharge\StructType\Customer|null
     */
    public function getCustomerInformation()
    {
        return $this->CustomerInformation;
    }
    /**
     * Set CustomerInformation value
     * @param \eBizCharge\StructType\Customer $customerInformation
     * @return \eBizCharge\StructType\CardExpirationCounts
     */
    public function setCustomerInformation(\eBizCharge\StructType\Customer $customerInformation = null)
    {
        $this->CustomerInformation = $customerInformation;
        return $this;
    }
}
