<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarkCustomerAsInactive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkCustomerAsInactive $parameters
     * @return \eBizCharge\StructType\MarkCustomerAsInactiveResponse|bool
     */
    public function MarkCustomerAsInactive(\eBizCharge\StructType\MarkCustomerAsInactive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkCustomerAsInactive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkCustomerAsSynchronized
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkCustomerAsSynchronized $parameters
     * @return \eBizCharge\StructType\MarkCustomerAsSynchronizedResponse|bool
     */
    public function MarkCustomerAsSynchronized(\eBizCharge\StructType\MarkCustomerAsSynchronized $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkCustomerAsSynchronized($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkPaymentAsApplied
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkPaymentAsApplied $parameters
     * @return \eBizCharge\StructType\MarkPaymentAsAppliedResponse|bool
     */
    public function MarkPaymentAsApplied(\eBizCharge\StructType\MarkPaymentAsApplied $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkPaymentAsApplied($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkInvoiceAsSynchronized
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkInvoiceAsSynchronized $parameters
     * @return \eBizCharge\StructType\MarkInvoiceAsSynchronizedResponse|bool
     */
    public function MarkInvoiceAsSynchronized(\eBizCharge\StructType\MarkInvoiceAsSynchronized $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkInvoiceAsSynchronized($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkRecurringPaymentAsApplied
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkRecurringPaymentAsApplied $parameters
     * @return \eBizCharge\StructType\MarkRecurringPaymentAsAppliedResponse|bool
     */
    public function MarkRecurringPaymentAsApplied(\eBizCharge\StructType\MarkRecurringPaymentAsApplied $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkRecurringPaymentAsApplied($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkEbizWebFormPaymentAsApplied
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkEbizWebFormPaymentAsApplied $parameters
     * @return \eBizCharge\StructType\MarkEbizWebFormPaymentAsAppliedResponse|bool
     */
    public function MarkEbizWebFormPaymentAsApplied(\eBizCharge\StructType\MarkEbizWebFormPaymentAsApplied $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkEbizWebFormPaymentAsApplied($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkSalesOrderAsSynchronized
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkSalesOrderAsSynchronized $parameters
     * @return \eBizCharge\StructType\MarkSalesOrderAsSynchronizedResponse|bool
     */
    public function MarkSalesOrderAsSynchronized(\eBizCharge\StructType\MarkSalesOrderAsSynchronized $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkSalesOrderAsSynchronized($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MarkApplicationTransactionAsApplied
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\MarkApplicationTransactionAsApplied $parameters
     * @return \eBizCharge\StructType\MarkApplicationTransactionAsAppliedResponse|bool
     */
    public function MarkApplicationTransactionAsApplied(\eBizCharge\StructType\MarkApplicationTransactionAsApplied $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkApplicationTransactionAsApplied($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\MarkApplicationTransactionAsAppliedResponse|\eBizCharge\StructType\MarkCustomerAsInactiveResponse|\eBizCharge\StructType\MarkCustomerAsSynchronizedResponse|\eBizCharge\StructType\MarkEbizWebFormPaymentAsAppliedResponse|\eBizCharge\StructType\MarkInvoiceAsSynchronizedResponse|\eBizCharge\StructType\MarkPaymentAsAppliedResponse|\eBizCharge\StructType\MarkRecurringPaymentAsAppliedResponse|\eBizCharge\StructType\MarkSalesOrderAsSynchronizedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
