<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchCustomers $parameters
     * @return \eBizCharge\StructType\SearchCustomersResponse|bool
     */
    public function SearchCustomers(\eBizCharge\StructType\SearchCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchCustomerList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchCustomerList $parameters
     * @return \eBizCharge\StructType\SearchCustomerListResponse|bool
     */
    public function SearchCustomerList(\eBizCharge\StructType\SearchCustomerList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchCustomerList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchInvoices $parameters
     * @return \eBizCharge\StructType\SearchInvoicesResponse|bool
     */
    public function SearchInvoices(\eBizCharge\StructType\SearchInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchItems $parameters
     * @return \eBizCharge\StructType\SearchItemsResponse|bool
     */
    public function SearchItems(\eBizCharge\StructType\SearchItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchScheduledRecurringPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchScheduledRecurringPayments $parameters
     * @return \eBizCharge\StructType\SearchScheduledRecurringPaymentsResponse|bool
     */
    public function SearchScheduledRecurringPayments(\eBizCharge\StructType\SearchScheduledRecurringPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchScheduledRecurringPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchRecurringPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchRecurringPayments $parameters
     * @return \eBizCharge\StructType\SearchRecurringPaymentsResponse|bool
     */
    public function SearchRecurringPayments(\eBizCharge\StructType\SearchRecurringPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchRecurringPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchPaymentFormPendingPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchPaymentFormPendingPayments $parameters
     * @return \eBizCharge\StructType\SearchPaymentFormPendingPaymentsResponse|bool
     */
    public function SearchPaymentFormPendingPayments(\eBizCharge\StructType\SearchPaymentFormPendingPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchPaymentFormPendingPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchPaymentFormReceivedPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchPaymentFormReceivedPayments $parameters
     * @return \eBizCharge\StructType\SearchPaymentFormReceivedPaymentsResponse|bool
     */
    public function SearchPaymentFormReceivedPayments(\eBizCharge\StructType\SearchPaymentFormReceivedPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchPaymentFormReceivedPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchEbizWebFormPendingPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchEbizWebFormPendingPayments $parameters
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPaymentsResponse|bool
     */
    public function SearchEbizWebFormPendingPayments(\eBizCharge\StructType\SearchEbizWebFormPendingPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchEbizWebFormPendingPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchEbizWebFormReceivedPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchEbizWebFormReceivedPayments $parameters
     * @return \eBizCharge\StructType\SearchEbizWebFormReceivedPaymentsResponse|bool
     */
    public function SearchEbizWebFormReceivedPayments(\eBizCharge\StructType\SearchEbizWebFormReceivedPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchEbizWebFormReceivedPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchUserList $parameters
     * @return \eBizCharge\StructType\SearchUserListResponse|bool
     */
    public function SearchUserList(\eBizCharge\StructType\SearchUserList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchUserList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchTransactions $parameters
     * @return \eBizCharge\StructType\SearchTransactionsResponse|bool
     */
    public function SearchTransactions(\eBizCharge\StructType\SearchTransactions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchBatches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchBatches $parameters
     * @return \eBizCharge\StructType\SearchBatchesResponse|bool
     */
    public function SearchBatches(\eBizCharge\StructType\SearchBatches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchBatches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchSalesOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchSalesOrders $parameters
     * @return \eBizCharge\StructType\SearchSalesOrdersResponse|bool
     */
    public function SearchSalesOrders(\eBizCharge\StructType\SearchSalesOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchSalesOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchSalesReps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchSalesReps $parameters
     * @return \eBizCharge\StructType\SearchSalesRepsResponse|bool
     */
    public function SearchSalesReps(\eBizCharge\StructType\SearchSalesReps $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchSalesReps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchTerms $parameters
     * @return \eBizCharge\StructType\SearchTermsResponse|bool
     */
    public function SearchTerms(\eBizCharge\StructType\SearchTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchApplicationTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\SearchApplicationTransactions $parameters
     * @return \eBizCharge\StructType\SearchApplicationTransactionsResponse|bool
     */
    public function SearchApplicationTransactions(\eBizCharge\StructType\SearchApplicationTransactions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchApplicationTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\SearchApplicationTransactionsResponse|\eBizCharge\StructType\SearchBatchesResponse|\eBizCharge\StructType\SearchCustomerListResponse|\eBizCharge\StructType\SearchCustomersResponse|\eBizCharge\StructType\SearchEbizWebFormPendingPaymentsResponse|\eBizCharge\StructType\SearchEbizWebFormReceivedPaymentsResponse|\eBizCharge\StructType\SearchInvoicesResponse|\eBizCharge\StructType\SearchItemsResponse|\eBizCharge\StructType\SearchPaymentFormPendingPaymentsResponse|\eBizCharge\StructType\SearchPaymentFormReceivedPaymentsResponse|\eBizCharge\StructType\SearchRecurringPaymentsResponse|\eBizCharge\StructType\SearchSalesOrdersResponse|\eBizCharge\StructType\SearchSalesRepsResponse|\eBizCharge\StructType\SearchScheduledRecurringPaymentsResponse|\eBizCharge\StructType\SearchTermsResponse|\eBizCharge\StructType\SearchTransactionsResponse|\eBizCharge\StructType\SearchUserListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
