<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDetail StructType
 * @subpackage Structs
 */
class TransactionDetail extends AbstractStructBase
{
    /**
     * The NonTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NonTax;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The Subtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Subtotal;
    /**
     * The Shipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Shipping;
    /**
     * The Duty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Duty;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The AllowPartialAuth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowPartialAuth;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tip;
    /**
     * The Table
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Table;
    /**
     * The ShipFromZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipFromZip;
    /**
     * The SessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The PONum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PONum;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Clerk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Clerk;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Terminal;
    /**
     * Constructor method for TransactionDetail
     * @uses TransactionDetail::setNonTax()
     * @uses TransactionDetail::setTax()
     * @uses TransactionDetail::setSubtotal()
     * @uses TransactionDetail::setShipping()
     * @uses TransactionDetail::setDuty()
     * @uses TransactionDetail::setDiscount()
     * @uses TransactionDetail::setAmount()
     * @uses TransactionDetail::setAllowPartialAuth()
     * @uses TransactionDetail::setTip()
     * @uses TransactionDetail::setTable()
     * @uses TransactionDetail::setShipFromZip()
     * @uses TransactionDetail::setSessionID()
     * @uses TransactionDetail::setPONum()
     * @uses TransactionDetail::setOrderID()
     * @uses TransactionDetail::setInvoice()
     * @uses TransactionDetail::setComments()
     * @uses TransactionDetail::setDescription()
     * @uses TransactionDetail::setCurrency()
     * @uses TransactionDetail::setClerk()
     * @uses TransactionDetail::setTerminal()
     * @param bool $nonTax
     * @param float $tax
     * @param float $subtotal
     * @param float $shipping
     * @param float $duty
     * @param float $discount
     * @param float $amount
     * @param bool $allowPartialAuth
     * @param float $tip
     * @param string $table
     * @param string $shipFromZip
     * @param string $sessionID
     * @param string $pONum
     * @param string $orderID
     * @param string $invoice
     * @param string $comments
     * @param string $description
     * @param string $currency
     * @param string $clerk
     * @param string $terminal
     */
    public function __construct($nonTax = null, $tax = null, $subtotal = null, $shipping = null, $duty = null, $discount = null, $amount = null, $allowPartialAuth = null, $tip = null, $table = null, $shipFromZip = null, $sessionID = null, $pONum = null, $orderID = null, $invoice = null, $comments = null, $description = null, $currency = null, $clerk = null, $terminal = null)
    {
        $this
            ->setNonTax($nonTax)
            ->setTax($tax)
            ->setSubtotal($subtotal)
            ->setShipping($shipping)
            ->setDuty($duty)
            ->setDiscount($discount)
            ->setAmount($amount)
            ->setAllowPartialAuth($allowPartialAuth)
            ->setTip($tip)
            ->setTable($table)
            ->setShipFromZip($shipFromZip)
            ->setSessionID($sessionID)
            ->setPONum($pONum)
            ->setOrderID($orderID)
            ->setInvoice($invoice)
            ->setComments($comments)
            ->setDescription($description)
            ->setCurrency($currency)
            ->setClerk($clerk)
            ->setTerminal($terminal);
    }
    /**
     * Get NonTax value
     * @return bool
     */
    public function getNonTax()
    {
        return $this->NonTax;
    }
    /**
     * Set NonTax value
     * @param bool $nonTax
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setNonTax($nonTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonTax) && !is_bool($nonTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonTax, true), gettype($nonTax)), __LINE__);
        }
        $this->NonTax = $nonTax;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setTax($tax = null)
    {
        // validation for constraint: float
        if (!is_null($tax) && !(is_float($tax) || is_numeric($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Subtotal value
     * @return float
     */
    public function getSubtotal()
    {
        return $this->Subtotal;
    }
    /**
     * Set Subtotal value
     * @param float $subtotal
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setSubtotal($subtotal = null)
    {
        // validation for constraint: float
        if (!is_null($subtotal) && !(is_float($subtotal) || is_numeric($subtotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subtotal, true), gettype($subtotal)), __LINE__);
        }
        $this->Subtotal = $subtotal;
        return $this;
    }
    /**
     * Get Shipping value
     * @return float
     */
    public function getShipping()
    {
        return $this->Shipping;
    }
    /**
     * Set Shipping value
     * @param float $shipping
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setShipping($shipping = null)
    {
        // validation for constraint: float
        if (!is_null($shipping) && !(is_float($shipping) || is_numeric($shipping))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipping, true), gettype($shipping)), __LINE__);
        }
        $this->Shipping = $shipping;
        return $this;
    }
    /**
     * Get Duty value
     * @return float
     */
    public function getDuty()
    {
        return $this->Duty;
    }
    /**
     * Set Duty value
     * @param float $duty
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setDuty($duty = null)
    {
        // validation for constraint: float
        if (!is_null($duty) && !(is_float($duty) || is_numeric($duty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duty, true), gettype($duty)), __LINE__);
        }
        $this->Duty = $duty;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AllowPartialAuth value
     * @return bool
     */
    public function getAllowPartialAuth()
    {
        return $this->AllowPartialAuth;
    }
    /**
     * Set AllowPartialAuth value
     * @param bool $allowPartialAuth
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setAllowPartialAuth($allowPartialAuth = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialAuth) && !is_bool($allowPartialAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialAuth, true), gettype($allowPartialAuth)), __LINE__);
        }
        $this->AllowPartialAuth = $allowPartialAuth;
        return $this;
    }
    /**
     * Get Tip value
     * @return float
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param float $tip
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setTip($tip = null)
    {
        // validation for constraint: float
        if (!is_null($tip) && !(is_float($tip) || is_numeric($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get Table value
     * @return string|null
     */
    public function getTable()
    {
        return $this->Table;
    }
    /**
     * Set Table value
     * @param string $table
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setTable($table = null)
    {
        // validation for constraint: string
        if (!is_null($table) && !is_string($table)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($table, true), gettype($table)), __LINE__);
        }
        $this->Table = $table;
        return $this;
    }
    /**
     * Get ShipFromZip value
     * @return string|null
     */
    public function getShipFromZip()
    {
        return $this->ShipFromZip;
    }
    /**
     * Set ShipFromZip value
     * @param string $shipFromZip
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setShipFromZip($shipFromZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipFromZip) && !is_string($shipFromZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipFromZip, true), gettype($shipFromZip)), __LINE__);
        }
        $this->ShipFromZip = $shipFromZip;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get PONum value
     * @return string|null
     */
    public function getPONum()
    {
        return $this->PONum;
    }
    /**
     * Set PONum value
     * @param string $pONum
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setPONum($pONum = null)
    {
        // validation for constraint: string
        if (!is_null($pONum) && !is_string($pONum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pONum, true), gettype($pONum)), __LINE__);
        }
        $this->PONum = $pONum;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get Invoice value
     * @return string|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param string $invoice
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setInvoice($invoice = null)
    {
        // validation for constraint: string
        if (!is_null($invoice) && !is_string($invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice, true), gettype($invoice)), __LINE__);
        }
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Clerk value
     * @return string|null
     */
    public function getClerk()
    {
        return $this->Clerk;
    }
    /**
     * Set Clerk value
     * @param string $clerk
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setClerk($clerk = null)
    {
        // validation for constraint: string
        if (!is_null($clerk) && !is_string($clerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clerk, true), gettype($clerk)), __LINE__);
        }
        $this->Clerk = $clerk;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \eBizCharge\StructType\TransactionDetail
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
}
