<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchInvoices StructType
 * @subpackage Structs
 */
class SearchInvoices extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The includeItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeItems;
    /**
     * The securityTokenCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityTokenCustomer;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The subCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCustomerId;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The invoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceInternalId;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public $filters;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchInvoices
     * @uses SearchInvoices::setStart()
     * @uses SearchInvoices::setLimit()
     * @uses SearchInvoices::setIncludeItems()
     * @uses SearchInvoices::setSecurityTokenCustomer()
     * @uses SearchInvoices::setCustomerId()
     * @uses SearchInvoices::setSubCustomerId()
     * @uses SearchInvoices::setInvoiceNumber()
     * @uses SearchInvoices::setInvoiceInternalId()
     * @uses SearchInvoices::setFilters()
     * @uses SearchInvoices::setSort()
     * @param int $start
     * @param int $limit
     * @param bool $includeItems
     * @param \eBizCharge\StructType\SecurityToken $securityTokenCustomer
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $invoiceNumber
     * @param string $invoiceInternalId
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @param string $sort
     */
    public function __construct($start = null, $limit = null, $includeItems = null, \eBizCharge\StructType\SecurityToken $securityTokenCustomer = null, $customerId = null, $subCustomerId = null, $invoiceNumber = null, $invoiceInternalId = null, \eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null, $sort = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setIncludeItems($includeItems)
            ->setSecurityTokenCustomer($securityTokenCustomer)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setFilters($filters)
            ->setSort($sort);
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get includeItems value
     * @return bool
     */
    public function getIncludeItems()
    {
        return $this->includeItems;
    }
    /**
     * Set includeItems value
     * @param bool $includeItems
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setIncludeItems($includeItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeItems) && !is_bool($includeItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeItems, true), gettype($includeItems)), __LINE__);
        }
        $this->includeItems = $includeItems;
        return $this;
    }
    /**
     * Get securityTokenCustomer value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityTokenCustomer()
    {
        return $this->securityTokenCustomer;
    }
    /**
     * Set securityTokenCustomer value
     * @param \eBizCharge\StructType\SecurityToken $securityTokenCustomer
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setSecurityTokenCustomer(\eBizCharge\StructType\SecurityToken $securityTokenCustomer = null)
    {
        $this->securityTokenCustomer = $securityTokenCustomer;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get subCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->subCustomerId;
    }
    /**
     * Set subCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->subCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get invoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->invoiceInternalId;
    }
    /**
     * Set invoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->invoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get filters value
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setFilters(\eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchInvoices
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
}
