<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringBilling StructType
 * @subpackage Structs
 */
class RecurringBilling extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Tax;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Enabled;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Start;
    /**
     * The Expire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Expire;
    /**
     * The Next
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Next;
    /**
     * The RepeatCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RepeatCount;
    /**
     * The SendCustomerReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendCustomerReceipt;
    /**
     * The NumLeft
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumLeft;
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule;
    /**
     * The CustomScheduleObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CustomSchedule
     */
    public $CustomScheduleObject;
    /**
     * The ScheduleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduleName;
    /**
     * The ReceiptNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNote;
    /**
     * The ReceiptTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptTemplateName;
    /**
     * Constructor method for RecurringBilling
     * @uses RecurringBilling::setAmount()
     * @uses RecurringBilling::setTax()
     * @uses RecurringBilling::setEnabled()
     * @uses RecurringBilling::setStart()
     * @uses RecurringBilling::setExpire()
     * @uses RecurringBilling::setNext()
     * @uses RecurringBilling::setRepeatCount()
     * @uses RecurringBilling::setSendCustomerReceipt()
     * @uses RecurringBilling::setNumLeft()
     * @uses RecurringBilling::setSchedule()
     * @uses RecurringBilling::setCustomScheduleObject()
     * @uses RecurringBilling::setScheduleName()
     * @uses RecurringBilling::setReceiptNote()
     * @uses RecurringBilling::setReceiptTemplateName()
     * @param float $amount
     * @param float $tax
     * @param bool $enabled
     * @param string $start
     * @param string $expire
     * @param string $next
     * @param int $repeatCount
     * @param bool $sendCustomerReceipt
     * @param string $numLeft
     * @param string $schedule
     * @param \eBizCharge\StructType\CustomSchedule $customScheduleObject
     * @param string $scheduleName
     * @param string $receiptNote
     * @param string $receiptTemplateName
     */
    public function __construct($amount = null, $tax = null, $enabled = null, $start = null, $expire = null, $next = null, $repeatCount = null, $sendCustomerReceipt = null, $numLeft = null, $schedule = null, \eBizCharge\StructType\CustomSchedule $customScheduleObject = null, $scheduleName = null, $receiptNote = null, $receiptTemplateName = null)
    {
        $this
            ->setAmount($amount)
            ->setTax($tax)
            ->setEnabled($enabled)
            ->setStart($start)
            ->setExpire($expire)
            ->setNext($next)
            ->setRepeatCount($repeatCount)
            ->setSendCustomerReceipt($sendCustomerReceipt)
            ->setNumLeft($numLeft)
            ->setSchedule($schedule)
            ->setCustomScheduleObject($customScheduleObject)
            ->setScheduleName($scheduleName)
            ->setReceiptNote($receiptNote)
            ->setReceiptTemplateName($receiptTemplateName);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setTax($tax = null)
    {
        // validation for constraint: float
        if (!is_null($tax) && !(is_float($tax) || is_numeric($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Expire value
     * @return string
     */
    public function getExpire()
    {
        return $this->Expire;
    }
    /**
     * Set Expire value
     * @param string $expire
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setExpire($expire = null)
    {
        // validation for constraint: string
        if (!is_null($expire) && !is_string($expire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expire, true), gettype($expire)), __LINE__);
        }
        $this->Expire = $expire;
        return $this;
    }
    /**
     * Get Next value
     * @return string
     */
    public function getNext()
    {
        return $this->Next;
    }
    /**
     * Set Next value
     * @param string $next
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setNext($next = null)
    {
        // validation for constraint: string
        if (!is_null($next) && !is_string($next)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($next, true), gettype($next)), __LINE__);
        }
        $this->Next = $next;
        return $this;
    }
    /**
     * Get RepeatCount value
     * @return int
     */
    public function getRepeatCount()
    {
        return $this->RepeatCount;
    }
    /**
     * Set RepeatCount value
     * @param int $repeatCount
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setRepeatCount($repeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($repeatCount) && !(is_int($repeatCount) || ctype_digit($repeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repeatCount, true), gettype($repeatCount)), __LINE__);
        }
        $this->RepeatCount = $repeatCount;
        return $this;
    }
    /**
     * Get SendCustomerReceipt value
     * @return bool
     */
    public function getSendCustomerReceipt()
    {
        return $this->SendCustomerReceipt;
    }
    /**
     * Set SendCustomerReceipt value
     * @param bool $sendCustomerReceipt
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setSendCustomerReceipt($sendCustomerReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendCustomerReceipt) && !is_bool($sendCustomerReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendCustomerReceipt, true), gettype($sendCustomerReceipt)), __LINE__);
        }
        $this->SendCustomerReceipt = $sendCustomerReceipt;
        return $this;
    }
    /**
     * Get NumLeft value
     * @return string|null
     */
    public function getNumLeft()
    {
        return $this->NumLeft;
    }
    /**
     * Set NumLeft value
     * @param string $numLeft
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setNumLeft($numLeft = null)
    {
        // validation for constraint: string
        if (!is_null($numLeft) && !is_string($numLeft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numLeft, true), gettype($numLeft)), __LINE__);
        }
        $this->NumLeft = $numLeft;
        return $this;
    }
    /**
     * Get Schedule value
     * @return string|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param string $schedule
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: string
        if (!is_null($schedule) && !is_string($schedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule, true), gettype($schedule)), __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get CustomScheduleObject value
     * @return \eBizCharge\StructType\CustomSchedule|null
     */
    public function getCustomScheduleObject()
    {
        return $this->CustomScheduleObject;
    }
    /**
     * Set CustomScheduleObject value
     * @param \eBizCharge\StructType\CustomSchedule $customScheduleObject
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setCustomScheduleObject(\eBizCharge\StructType\CustomSchedule $customScheduleObject = null)
    {
        $this->CustomScheduleObject = $customScheduleObject;
        return $this;
    }
    /**
     * Get ScheduleName value
     * @return string|null
     */
    public function getScheduleName()
    {
        return $this->ScheduleName;
    }
    /**
     * Set ScheduleName value
     * @param string $scheduleName
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setScheduleName($scheduleName = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleName) && !is_string($scheduleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleName, true), gettype($scheduleName)), __LINE__);
        }
        $this->ScheduleName = $scheduleName;
        return $this;
    }
    /**
     * Get ReceiptNote value
     * @return string|null
     */
    public function getReceiptNote()
    {
        return $this->ReceiptNote;
    }
    /**
     * Set ReceiptNote value
     * @param string $receiptNote
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setReceiptNote($receiptNote = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNote) && !is_string($receiptNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNote, true), gettype($receiptNote)), __LINE__);
        }
        $this->ReceiptNote = $receiptNote;
        return $this;
    }
    /**
     * Get ReceiptTemplateName value
     * @return string|null
     */
    public function getReceiptTemplateName()
    {
        return $this->ReceiptTemplateName;
    }
    /**
     * Set ReceiptTemplateName value
     * @param string $receiptTemplateName
     * @return \eBizCharge\StructType\RecurringBilling
     */
    public function setReceiptTemplateName($receiptTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($receiptTemplateName) && !is_string($receiptTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptTemplateName, true), gettype($receiptTemplateName)), __LINE__);
        }
        $this->ReceiptTemplateName = $receiptTemplateName;
        return $this;
    }
}
