<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationTransactionRequest StructType
 * @subpackage Structs
 */
class ApplicationTransactionRequest extends AbstractStructBase
{
    /**
     * The CustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerInternalId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionTypeId;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * The LinkedToTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToTypeId;
    /**
     * The LinkedToInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToInternalId;
    /**
     * The LinkedToExternalUniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToExternalUniqueId;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionExternalReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionExternalReferenceNumber;
    /**
     * The TransactionCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $TransactionCustomFields;
    /**
     * Constructor method for ApplicationTransactionRequest
     * @uses ApplicationTransactionRequest::setCustomerInternalId()
     * @uses ApplicationTransactionRequest::setTransactionId()
     * @uses ApplicationTransactionRequest::setTransactionTypeId()
     * @uses ApplicationTransactionRequest::setSoftwareId()
     * @uses ApplicationTransactionRequest::setLinkedToTypeId()
     * @uses ApplicationTransactionRequest::setLinkedToInternalId()
     * @uses ApplicationTransactionRequest::setLinkedToExternalUniqueId()
     * @uses ApplicationTransactionRequest::setTransactionDate()
     * @uses ApplicationTransactionRequest::setTransactionNotes()
     * @uses ApplicationTransactionRequest::setTransactionExternalReferenceNumber()
     * @uses ApplicationTransactionRequest::setTransactionCustomFields()
     * @param string $customerInternalId
     * @param string $transactionId
     * @param string $transactionTypeId
     * @param string $softwareId
     * @param string $linkedToTypeId
     * @param string $linkedToInternalId
     * @param string $linkedToExternalUniqueId
     * @param string $transactionDate
     * @param string $transactionNotes
     * @param string $transactionExternalReferenceNumber
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields
     */
    public function __construct($customerInternalId = null, $transactionId = null, $transactionTypeId = null, $softwareId = null, $linkedToTypeId = null, $linkedToInternalId = null, $linkedToExternalUniqueId = null, $transactionDate = null, $transactionNotes = null, $transactionExternalReferenceNumber = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields = null)
    {
        $this
            ->setCustomerInternalId($customerInternalId)
            ->setTransactionId($transactionId)
            ->setTransactionTypeId($transactionTypeId)
            ->setSoftwareId($softwareId)
            ->setLinkedToTypeId($linkedToTypeId)
            ->setLinkedToInternalId($linkedToInternalId)
            ->setLinkedToExternalUniqueId($linkedToExternalUniqueId)
            ->setTransactionDate($transactionDate)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionExternalReferenceNumber($transactionExternalReferenceNumber)
            ->setTransactionCustomFields($transactionCustomFields);
    }
    /**
     * Get CustomerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->CustomerInternalId;
    }
    /**
     * Set CustomerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->CustomerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionTypeId value
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->TransactionTypeId;
    }
    /**
     * Set TransactionTypeId value
     * @param string $transactionTypeId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionTypeId($transactionTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeId) && !is_string($transactionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTypeId, true), gettype($transactionTypeId)), __LINE__);
        }
        $this->TransactionTypeId = $transactionTypeId;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get LinkedToTypeId value
     * @return string|null
     */
    public function getLinkedToTypeId()
    {
        return $this->LinkedToTypeId;
    }
    /**
     * Set LinkedToTypeId value
     * @param string $linkedToTypeId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setLinkedToTypeId($linkedToTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToTypeId) && !is_string($linkedToTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToTypeId, true), gettype($linkedToTypeId)), __LINE__);
        }
        $this->LinkedToTypeId = $linkedToTypeId;
        return $this;
    }
    /**
     * Get LinkedToInternalId value
     * @return string|null
     */
    public function getLinkedToInternalId()
    {
        return $this->LinkedToInternalId;
    }
    /**
     * Set LinkedToInternalId value
     * @param string $linkedToInternalId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setLinkedToInternalId($linkedToInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToInternalId) && !is_string($linkedToInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToInternalId, true), gettype($linkedToInternalId)), __LINE__);
        }
        $this->LinkedToInternalId = $linkedToInternalId;
        return $this;
    }
    /**
     * Get LinkedToExternalUniqueId value
     * @return string|null
     */
    public function getLinkedToExternalUniqueId()
    {
        return $this->LinkedToExternalUniqueId;
    }
    /**
     * Set LinkedToExternalUniqueId value
     * @param string $linkedToExternalUniqueId
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setLinkedToExternalUniqueId($linkedToExternalUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToExternalUniqueId) && !is_string($linkedToExternalUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToExternalUniqueId, true), gettype($linkedToExternalUniqueId)), __LINE__);
        }
        $this->LinkedToExternalUniqueId = $linkedToExternalUniqueId;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionNotes value
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return $this->TransactionNotes;
    }
    /**
     * Set TransactionNotes value
     * @param string $transactionNotes
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        $this->TransactionNotes = $transactionNotes;
        return $this;
    }
    /**
     * Get TransactionExternalReferenceNumber value
     * @return string|null
     */
    public function getTransactionExternalReferenceNumber()
    {
        return $this->TransactionExternalReferenceNumber;
    }
    /**
     * Set TransactionExternalReferenceNumber value
     * @param string $transactionExternalReferenceNumber
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionExternalReferenceNumber($transactionExternalReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionExternalReferenceNumber) && !is_string($transactionExternalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionExternalReferenceNumber, true), gettype($transactionExternalReferenceNumber)), __LINE__);
        }
        $this->TransactionExternalReferenceNumber = $transactionExternalReferenceNumber;
        return $this;
    }
    /**
     * Get TransactionCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getTransactionCustomFields()
    {
        return $this->TransactionCustomFields;
    }
    /**
     * Set TransactionCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields
     * @return \eBizCharge\StructType\ApplicationTransactionRequest
     */
    public function setTransactionCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields = null)
    {
        $this->TransactionCustomFields = $transactionCustomFields;
        return $this;
    }
}
