<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Render ServiceType
 * @subpackage Services
 */
class Render extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RenderReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\RenderReceipt $parameters
     * @return \eBizCharge\StructType\RenderReceiptResponse|bool
     */
    public function RenderReceipt(\eBizCharge\StructType\RenderReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RenderReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\RenderReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
