<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantTransactionData StructType
 * @subpackage Structs
 */
class MerchantTransactionData extends AbstractStructBase
{
    /**
     * The ItemDiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemDiscountAmount;
    /**
     * The ItemDiscountRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemDiscountRate;
    /**
     * The ItemUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemUnitPrice;
    /**
     * The ItemQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemQty;
    /**
     * The ItemTaxable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ItemTaxable;
    /**
     * The ItemTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemTaxAmount;
    /**
     * The ItemTaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemTaxRate;
    /**
     * The DutyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DutyAmount;
    /**
     * The ShippingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShippingAmount;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountAmount;
    /**
     * The AutoTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoTax;
    /**
     * The TaxPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxPercentage;
    /**
     * The AutoTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoTip;
    /**
     * The TipPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TipPercentage;
    /**
     * The PreAuthPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PreAuthPercentage;
    /**
     * The ExpireAuthAfter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExpireAuthAfter;
    /**
     * The AutoDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoDiscount;
    /**
     * The AutoItemDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoItemDiscount;
    /**
     * The DiscountPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountPercentage;
    /**
     * The UseCaptureEnhancement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseCaptureEnhancement;
    /**
     * The IsEMVEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsEMVEnabled;
    /**
     * The EnableAVSWarnings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EnableAVSWarnings;
    /**
     * The EnableCVVWarnings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EnableCVVWarnings;
    /**
     * The UseFullAmountForAVS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseFullAmountForAVS;
    /**
     * The DeclineTransactionIfAVSWarningsAreDisabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $DeclineTransactionIfAVSWarningsAreDisabled;
    /**
     * The VerifyCreditCardBeforeSaving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $VerifyCreditCardBeforeSaving;
    /**
     * The AllowACHPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowACHPayments;
    /**
     * The AllowCreditCardPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowCreditCardPayments;
    /**
     * The IsSurchargeEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsSurchargeEnabled;
    /**
     * The SurchargePercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SurchargePercentage;
    /**
     * The ItemSKU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemSKU;
    /**
     * The ItemCommodityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCommodityCode;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemUnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemUnitOfMeasure;
    /**
     * The ShipFromZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipFromZip;
    /**
     * The AvsStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsStreet;
    /**
     * The AvsZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsZip;
    /**
     * The SurchargeCaption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurchargeCaption;
    /**
     * Constructor method for MerchantTransactionData
     * @uses MerchantTransactionData::setItemDiscountAmount()
     * @uses MerchantTransactionData::setItemDiscountRate()
     * @uses MerchantTransactionData::setItemUnitPrice()
     * @uses MerchantTransactionData::setItemQty()
     * @uses MerchantTransactionData::setItemTaxable()
     * @uses MerchantTransactionData::setItemTaxAmount()
     * @uses MerchantTransactionData::setItemTaxRate()
     * @uses MerchantTransactionData::setDutyAmount()
     * @uses MerchantTransactionData::setShippingAmount()
     * @uses MerchantTransactionData::setDiscountAmount()
     * @uses MerchantTransactionData::setAutoTax()
     * @uses MerchantTransactionData::setTaxPercentage()
     * @uses MerchantTransactionData::setAutoTip()
     * @uses MerchantTransactionData::setTipPercentage()
     * @uses MerchantTransactionData::setPreAuthPercentage()
     * @uses MerchantTransactionData::setExpireAuthAfter()
     * @uses MerchantTransactionData::setAutoDiscount()
     * @uses MerchantTransactionData::setAutoItemDiscount()
     * @uses MerchantTransactionData::setDiscountPercentage()
     * @uses MerchantTransactionData::setUseCaptureEnhancement()
     * @uses MerchantTransactionData::setIsEMVEnabled()
     * @uses MerchantTransactionData::setEnableAVSWarnings()
     * @uses MerchantTransactionData::setEnableCVVWarnings()
     * @uses MerchantTransactionData::setUseFullAmountForAVS()
     * @uses MerchantTransactionData::setDeclineTransactionIfAVSWarningsAreDisabled()
     * @uses MerchantTransactionData::setVerifyCreditCardBeforeSaving()
     * @uses MerchantTransactionData::setAllowACHPayments()
     * @uses MerchantTransactionData::setAllowCreditCardPayments()
     * @uses MerchantTransactionData::setIsSurchargeEnabled()
     * @uses MerchantTransactionData::setSurchargePercentage()
     * @uses MerchantTransactionData::setItemSKU()
     * @uses MerchantTransactionData::setItemCommodityCode()
     * @uses MerchantTransactionData::setItemName()
     * @uses MerchantTransactionData::setItemDescription()
     * @uses MerchantTransactionData::setItemUnitOfMeasure()
     * @uses MerchantTransactionData::setShipFromZip()
     * @uses MerchantTransactionData::setAvsStreet()
     * @uses MerchantTransactionData::setAvsZip()
     * @uses MerchantTransactionData::setSurchargeCaption()
     * @param float $itemDiscountAmount
     * @param float $itemDiscountRate
     * @param float $itemUnitPrice
     * @param float $itemQty
     * @param bool $itemTaxable
     * @param float $itemTaxAmount
     * @param float $itemTaxRate
     * @param float $dutyAmount
     * @param float $shippingAmount
     * @param float $discountAmount
     * @param bool $autoTax
     * @param float $taxPercentage
     * @param bool $autoTip
     * @param float $tipPercentage
     * @param float $preAuthPercentage
     * @param int $expireAuthAfter
     * @param bool $autoDiscount
     * @param bool $autoItemDiscount
     * @param float $discountPercentage
     * @param bool $useCaptureEnhancement
     * @param bool $isEMVEnabled
     * @param bool $enableAVSWarnings
     * @param bool $enableCVVWarnings
     * @param bool $useFullAmountForAVS
     * @param bool $declineTransactionIfAVSWarningsAreDisabled
     * @param bool $verifyCreditCardBeforeSaving
     * @param bool $allowACHPayments
     * @param bool $allowCreditCardPayments
     * @param bool $isSurchargeEnabled
     * @param float $surchargePercentage
     * @param string $itemSKU
     * @param string $itemCommodityCode
     * @param string $itemName
     * @param string $itemDescription
     * @param string $itemUnitOfMeasure
     * @param string $shipFromZip
     * @param string $avsStreet
     * @param string $avsZip
     * @param string $surchargeCaption
     */
    public function __construct($itemDiscountAmount = null, $itemDiscountRate = null, $itemUnitPrice = null, $itemQty = null, $itemTaxable = null, $itemTaxAmount = null, $itemTaxRate = null, $dutyAmount = null, $shippingAmount = null, $discountAmount = null, $autoTax = null, $taxPercentage = null, $autoTip = null, $tipPercentage = null, $preAuthPercentage = null, $expireAuthAfter = null, $autoDiscount = null, $autoItemDiscount = null, $discountPercentage = null, $useCaptureEnhancement = null, $isEMVEnabled = null, $enableAVSWarnings = null, $enableCVVWarnings = null, $useFullAmountForAVS = null, $declineTransactionIfAVSWarningsAreDisabled = null, $verifyCreditCardBeforeSaving = null, $allowACHPayments = null, $allowCreditCardPayments = null, $isSurchargeEnabled = null, $surchargePercentage = null, $itemSKU = null, $itemCommodityCode = null, $itemName = null, $itemDescription = null, $itemUnitOfMeasure = null, $shipFromZip = null, $avsStreet = null, $avsZip = null, $surchargeCaption = null)
    {
        $this
            ->setItemDiscountAmount($itemDiscountAmount)
            ->setItemDiscountRate($itemDiscountRate)
            ->setItemUnitPrice($itemUnitPrice)
            ->setItemQty($itemQty)
            ->setItemTaxable($itemTaxable)
            ->setItemTaxAmount($itemTaxAmount)
            ->setItemTaxRate($itemTaxRate)
            ->setDutyAmount($dutyAmount)
            ->setShippingAmount($shippingAmount)
            ->setDiscountAmount($discountAmount)
            ->setAutoTax($autoTax)
            ->setTaxPercentage($taxPercentage)
            ->setAutoTip($autoTip)
            ->setTipPercentage($tipPercentage)
            ->setPreAuthPercentage($preAuthPercentage)
            ->setExpireAuthAfter($expireAuthAfter)
            ->setAutoDiscount($autoDiscount)
            ->setAutoItemDiscount($autoItemDiscount)
            ->setDiscountPercentage($discountPercentage)
            ->setUseCaptureEnhancement($useCaptureEnhancement)
            ->setIsEMVEnabled($isEMVEnabled)
            ->setEnableAVSWarnings($enableAVSWarnings)
            ->setEnableCVVWarnings($enableCVVWarnings)
            ->setUseFullAmountForAVS($useFullAmountForAVS)
            ->setDeclineTransactionIfAVSWarningsAreDisabled($declineTransactionIfAVSWarningsAreDisabled)
            ->setVerifyCreditCardBeforeSaving($verifyCreditCardBeforeSaving)
            ->setAllowACHPayments($allowACHPayments)
            ->setAllowCreditCardPayments($allowCreditCardPayments)
            ->setIsSurchargeEnabled($isSurchargeEnabled)
            ->setSurchargePercentage($surchargePercentage)
            ->setItemSKU($itemSKU)
            ->setItemCommodityCode($itemCommodityCode)
            ->setItemName($itemName)
            ->setItemDescription($itemDescription)
            ->setItemUnitOfMeasure($itemUnitOfMeasure)
            ->setShipFromZip($shipFromZip)
            ->setAvsStreet($avsStreet)
            ->setAvsZip($avsZip)
            ->setSurchargeCaption($surchargeCaption);
    }
    /**
     * Get ItemDiscountAmount value
     * @return float
     */
    public function getItemDiscountAmount()
    {
        return $this->ItemDiscountAmount;
    }
    /**
     * Set ItemDiscountAmount value
     * @param float $itemDiscountAmount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemDiscountAmount($itemDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($itemDiscountAmount) && !(is_float($itemDiscountAmount) || is_numeric($itemDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemDiscountAmount, true), gettype($itemDiscountAmount)), __LINE__);
        }
        $this->ItemDiscountAmount = $itemDiscountAmount;
        return $this;
    }
    /**
     * Get ItemDiscountRate value
     * @return float
     */
    public function getItemDiscountRate()
    {
        return $this->ItemDiscountRate;
    }
    /**
     * Set ItemDiscountRate value
     * @param float $itemDiscountRate
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemDiscountRate($itemDiscountRate = null)
    {
        // validation for constraint: float
        if (!is_null($itemDiscountRate) && !(is_float($itemDiscountRate) || is_numeric($itemDiscountRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemDiscountRate, true), gettype($itemDiscountRate)), __LINE__);
        }
        $this->ItemDiscountRate = $itemDiscountRate;
        return $this;
    }
    /**
     * Get ItemUnitPrice value
     * @return float
     */
    public function getItemUnitPrice()
    {
        return $this->ItemUnitPrice;
    }
    /**
     * Set ItemUnitPrice value
     * @param float $itemUnitPrice
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemUnitPrice($itemUnitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($itemUnitPrice) && !(is_float($itemUnitPrice) || is_numeric($itemUnitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemUnitPrice, true), gettype($itemUnitPrice)), __LINE__);
        }
        $this->ItemUnitPrice = $itemUnitPrice;
        return $this;
    }
    /**
     * Get ItemQty value
     * @return float
     */
    public function getItemQty()
    {
        return $this->ItemQty;
    }
    /**
     * Set ItemQty value
     * @param float $itemQty
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemQty($itemQty = null)
    {
        // validation for constraint: float
        if (!is_null($itemQty) && !(is_float($itemQty) || is_numeric($itemQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemQty, true), gettype($itemQty)), __LINE__);
        }
        $this->ItemQty = $itemQty;
        return $this;
    }
    /**
     * Get ItemTaxable value
     * @return bool
     */
    public function getItemTaxable()
    {
        return $this->ItemTaxable;
    }
    /**
     * Set ItemTaxable value
     * @param bool $itemTaxable
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemTaxable($itemTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemTaxable) && !is_bool($itemTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemTaxable, true), gettype($itemTaxable)), __LINE__);
        }
        $this->ItemTaxable = $itemTaxable;
        return $this;
    }
    /**
     * Get ItemTaxAmount value
     * @return float
     */
    public function getItemTaxAmount()
    {
        return $this->ItemTaxAmount;
    }
    /**
     * Set ItemTaxAmount value
     * @param float $itemTaxAmount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemTaxAmount($itemTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($itemTaxAmount) && !(is_float($itemTaxAmount) || is_numeric($itemTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemTaxAmount, true), gettype($itemTaxAmount)), __LINE__);
        }
        $this->ItemTaxAmount = $itemTaxAmount;
        return $this;
    }
    /**
     * Get ItemTaxRate value
     * @return float
     */
    public function getItemTaxRate()
    {
        return $this->ItemTaxRate;
    }
    /**
     * Set ItemTaxRate value
     * @param float $itemTaxRate
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemTaxRate($itemTaxRate = null)
    {
        // validation for constraint: float
        if (!is_null($itemTaxRate) && !(is_float($itemTaxRate) || is_numeric($itemTaxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemTaxRate, true), gettype($itemTaxRate)), __LINE__);
        }
        $this->ItemTaxRate = $itemTaxRate;
        return $this;
    }
    /**
     * Get DutyAmount value
     * @return float
     */
    public function getDutyAmount()
    {
        return $this->DutyAmount;
    }
    /**
     * Set DutyAmount value
     * @param float $dutyAmount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setDutyAmount($dutyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dutyAmount) && !(is_float($dutyAmount) || is_numeric($dutyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dutyAmount, true), gettype($dutyAmount)), __LINE__);
        }
        $this->DutyAmount = $dutyAmount;
        return $this;
    }
    /**
     * Get ShippingAmount value
     * @return float
     */
    public function getShippingAmount()
    {
        return $this->ShippingAmount;
    }
    /**
     * Set ShippingAmount value
     * @param float $shippingAmount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setShippingAmount($shippingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($shippingAmount) && !(is_float($shippingAmount) || is_numeric($shippingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingAmount, true), gettype($shippingAmount)), __LINE__);
        }
        $this->ShippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get AutoTax value
     * @return bool
     */
    public function getAutoTax()
    {
        return $this->AutoTax;
    }
    /**
     * Set AutoTax value
     * @param bool $autoTax
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAutoTax($autoTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoTax) && !is_bool($autoTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoTax, true), gettype($autoTax)), __LINE__);
        }
        $this->AutoTax = $autoTax;
        return $this;
    }
    /**
     * Get TaxPercentage value
     * @return float
     */
    public function getTaxPercentage()
    {
        return $this->TaxPercentage;
    }
    /**
     * Set TaxPercentage value
     * @param float $taxPercentage
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        $this->TaxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get AutoTip value
     * @return bool
     */
    public function getAutoTip()
    {
        return $this->AutoTip;
    }
    /**
     * Set AutoTip value
     * @param bool $autoTip
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAutoTip($autoTip = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoTip) && !is_bool($autoTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoTip, true), gettype($autoTip)), __LINE__);
        }
        $this->AutoTip = $autoTip;
        return $this;
    }
    /**
     * Get TipPercentage value
     * @return float
     */
    public function getTipPercentage()
    {
        return $this->TipPercentage;
    }
    /**
     * Set TipPercentage value
     * @param float $tipPercentage
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setTipPercentage($tipPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($tipPercentage) && !(is_float($tipPercentage) || is_numeric($tipPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipPercentage, true), gettype($tipPercentage)), __LINE__);
        }
        $this->TipPercentage = $tipPercentage;
        return $this;
    }
    /**
     * Get PreAuthPercentage value
     * @return float
     */
    public function getPreAuthPercentage()
    {
        return $this->PreAuthPercentage;
    }
    /**
     * Set PreAuthPercentage value
     * @param float $preAuthPercentage
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setPreAuthPercentage($preAuthPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($preAuthPercentage) && !(is_float($preAuthPercentage) || is_numeric($preAuthPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preAuthPercentage, true), gettype($preAuthPercentage)), __LINE__);
        }
        $this->PreAuthPercentage = $preAuthPercentage;
        return $this;
    }
    /**
     * Get ExpireAuthAfter value
     * @return int
     */
    public function getExpireAuthAfter()
    {
        return $this->ExpireAuthAfter;
    }
    /**
     * Set ExpireAuthAfter value
     * @param int $expireAuthAfter
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setExpireAuthAfter($expireAuthAfter = null)
    {
        // validation for constraint: int
        if (!is_null($expireAuthAfter) && !(is_int($expireAuthAfter) || ctype_digit($expireAuthAfter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expireAuthAfter, true), gettype($expireAuthAfter)), __LINE__);
        }
        $this->ExpireAuthAfter = $expireAuthAfter;
        return $this;
    }
    /**
     * Get AutoDiscount value
     * @return bool
     */
    public function getAutoDiscount()
    {
        return $this->AutoDiscount;
    }
    /**
     * Set AutoDiscount value
     * @param bool $autoDiscount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAutoDiscount($autoDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoDiscount) && !is_bool($autoDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoDiscount, true), gettype($autoDiscount)), __LINE__);
        }
        $this->AutoDiscount = $autoDiscount;
        return $this;
    }
    /**
     * Get AutoItemDiscount value
     * @return bool
     */
    public function getAutoItemDiscount()
    {
        return $this->AutoItemDiscount;
    }
    /**
     * Set AutoItemDiscount value
     * @param bool $autoItemDiscount
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAutoItemDiscount($autoItemDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoItemDiscount) && !is_bool($autoItemDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoItemDiscount, true), gettype($autoItemDiscount)), __LINE__);
        }
        $this->AutoItemDiscount = $autoItemDiscount;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return float
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param float $discountPercentage
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercentage) && !(is_float($discountPercentage) || is_numeric($discountPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Get UseCaptureEnhancement value
     * @return bool
     */
    public function getUseCaptureEnhancement()
    {
        return $this->UseCaptureEnhancement;
    }
    /**
     * Set UseCaptureEnhancement value
     * @param bool $useCaptureEnhancement
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setUseCaptureEnhancement($useCaptureEnhancement = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCaptureEnhancement) && !is_bool($useCaptureEnhancement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useCaptureEnhancement, true), gettype($useCaptureEnhancement)), __LINE__);
        }
        $this->UseCaptureEnhancement = $useCaptureEnhancement;
        return $this;
    }
    /**
     * Get IsEMVEnabled value
     * @return bool
     */
    public function getIsEMVEnabled()
    {
        return $this->IsEMVEnabled;
    }
    /**
     * Set IsEMVEnabled value
     * @param bool $isEMVEnabled
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setIsEMVEnabled($isEMVEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEMVEnabled) && !is_bool($isEMVEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEMVEnabled, true), gettype($isEMVEnabled)), __LINE__);
        }
        $this->IsEMVEnabled = $isEMVEnabled;
        return $this;
    }
    /**
     * Get EnableAVSWarnings value
     * @return bool
     */
    public function getEnableAVSWarnings()
    {
        return $this->EnableAVSWarnings;
    }
    /**
     * Set EnableAVSWarnings value
     * @param bool $enableAVSWarnings
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setEnableAVSWarnings($enableAVSWarnings = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableAVSWarnings) && !is_bool($enableAVSWarnings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableAVSWarnings, true), gettype($enableAVSWarnings)), __LINE__);
        }
        $this->EnableAVSWarnings = $enableAVSWarnings;
        return $this;
    }
    /**
     * Get EnableCVVWarnings value
     * @return bool
     */
    public function getEnableCVVWarnings()
    {
        return $this->EnableCVVWarnings;
    }
    /**
     * Set EnableCVVWarnings value
     * @param bool $enableCVVWarnings
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setEnableCVVWarnings($enableCVVWarnings = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableCVVWarnings) && !is_bool($enableCVVWarnings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableCVVWarnings, true), gettype($enableCVVWarnings)), __LINE__);
        }
        $this->EnableCVVWarnings = $enableCVVWarnings;
        return $this;
    }
    /**
     * Get UseFullAmountForAVS value
     * @return bool
     */
    public function getUseFullAmountForAVS()
    {
        return $this->UseFullAmountForAVS;
    }
    /**
     * Set UseFullAmountForAVS value
     * @param bool $useFullAmountForAVS
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setUseFullAmountForAVS($useFullAmountForAVS = null)
    {
        // validation for constraint: boolean
        if (!is_null($useFullAmountForAVS) && !is_bool($useFullAmountForAVS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useFullAmountForAVS, true), gettype($useFullAmountForAVS)), __LINE__);
        }
        $this->UseFullAmountForAVS = $useFullAmountForAVS;
        return $this;
    }
    /**
     * Get DeclineTransactionIfAVSWarningsAreDisabled value
     * @return bool
     */
    public function getDeclineTransactionIfAVSWarningsAreDisabled()
    {
        return $this->DeclineTransactionIfAVSWarningsAreDisabled;
    }
    /**
     * Set DeclineTransactionIfAVSWarningsAreDisabled value
     * @param bool $declineTransactionIfAVSWarningsAreDisabled
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setDeclineTransactionIfAVSWarningsAreDisabled($declineTransactionIfAVSWarningsAreDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($declineTransactionIfAVSWarningsAreDisabled) && !is_bool($declineTransactionIfAVSWarningsAreDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($declineTransactionIfAVSWarningsAreDisabled, true), gettype($declineTransactionIfAVSWarningsAreDisabled)), __LINE__);
        }
        $this->DeclineTransactionIfAVSWarningsAreDisabled = $declineTransactionIfAVSWarningsAreDisabled;
        return $this;
    }
    /**
     * Get VerifyCreditCardBeforeSaving value
     * @return bool
     */
    public function getVerifyCreditCardBeforeSaving()
    {
        return $this->VerifyCreditCardBeforeSaving;
    }
    /**
     * Set VerifyCreditCardBeforeSaving value
     * @param bool $verifyCreditCardBeforeSaving
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setVerifyCreditCardBeforeSaving($verifyCreditCardBeforeSaving = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyCreditCardBeforeSaving) && !is_bool($verifyCreditCardBeforeSaving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyCreditCardBeforeSaving, true), gettype($verifyCreditCardBeforeSaving)), __LINE__);
        }
        $this->VerifyCreditCardBeforeSaving = $verifyCreditCardBeforeSaving;
        return $this;
    }
    /**
     * Get AllowACHPayments value
     * @return bool
     */
    public function getAllowACHPayments()
    {
        return $this->AllowACHPayments;
    }
    /**
     * Set AllowACHPayments value
     * @param bool $allowACHPayments
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAllowACHPayments($allowACHPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowACHPayments) && !is_bool($allowACHPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowACHPayments, true), gettype($allowACHPayments)), __LINE__);
        }
        $this->AllowACHPayments = $allowACHPayments;
        return $this;
    }
    /**
     * Get AllowCreditCardPayments value
     * @return bool
     */
    public function getAllowCreditCardPayments()
    {
        return $this->AllowCreditCardPayments;
    }
    /**
     * Set AllowCreditCardPayments value
     * @param bool $allowCreditCardPayments
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAllowCreditCardPayments($allowCreditCardPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowCreditCardPayments) && !is_bool($allowCreditCardPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowCreditCardPayments, true), gettype($allowCreditCardPayments)), __LINE__);
        }
        $this->AllowCreditCardPayments = $allowCreditCardPayments;
        return $this;
    }
    /**
     * Get IsSurchargeEnabled value
     * @return bool
     */
    public function getIsSurchargeEnabled()
    {
        return $this->IsSurchargeEnabled;
    }
    /**
     * Set IsSurchargeEnabled value
     * @param bool $isSurchargeEnabled
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setIsSurchargeEnabled($isSurchargeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSurchargeEnabled) && !is_bool($isSurchargeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSurchargeEnabled, true), gettype($isSurchargeEnabled)), __LINE__);
        }
        $this->IsSurchargeEnabled = $isSurchargeEnabled;
        return $this;
    }
    /**
     * Get SurchargePercentage value
     * @return float
     */
    public function getSurchargePercentage()
    {
        return $this->SurchargePercentage;
    }
    /**
     * Set SurchargePercentage value
     * @param float $surchargePercentage
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setSurchargePercentage($surchargePercentage = null)
    {
        // validation for constraint: float
        if (!is_null($surchargePercentage) && !(is_float($surchargePercentage) || is_numeric($surchargePercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surchargePercentage, true), gettype($surchargePercentage)), __LINE__);
        }
        $this->SurchargePercentage = $surchargePercentage;
        return $this;
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get ItemCommodityCode value
     * @return string|null
     */
    public function getItemCommodityCode()
    {
        return $this->ItemCommodityCode;
    }
    /**
     * Set ItemCommodityCode value
     * @param string $itemCommodityCode
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemCommodityCode($itemCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCommodityCode) && !is_string($itemCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCommodityCode, true), gettype($itemCommodityCode)), __LINE__);
        }
        $this->ItemCommodityCode = $itemCommodityCode;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get ItemUnitOfMeasure value
     * @return string|null
     */
    public function getItemUnitOfMeasure()
    {
        return $this->ItemUnitOfMeasure;
    }
    /**
     * Set ItemUnitOfMeasure value
     * @param string $itemUnitOfMeasure
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setItemUnitOfMeasure($itemUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($itemUnitOfMeasure) && !is_string($itemUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemUnitOfMeasure, true), gettype($itemUnitOfMeasure)), __LINE__);
        }
        $this->ItemUnitOfMeasure = $itemUnitOfMeasure;
        return $this;
    }
    /**
     * Get ShipFromZip value
     * @return string|null
     */
    public function getShipFromZip()
    {
        return $this->ShipFromZip;
    }
    /**
     * Set ShipFromZip value
     * @param string $shipFromZip
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setShipFromZip($shipFromZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipFromZip) && !is_string($shipFromZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipFromZip, true), gettype($shipFromZip)), __LINE__);
        }
        $this->ShipFromZip = $shipFromZip;
        return $this;
    }
    /**
     * Get AvsStreet value
     * @return string|null
     */
    public function getAvsStreet()
    {
        return $this->AvsStreet;
    }
    /**
     * Set AvsStreet value
     * @param string $avsStreet
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAvsStreet($avsStreet = null)
    {
        // validation for constraint: string
        if (!is_null($avsStreet) && !is_string($avsStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsStreet, true), gettype($avsStreet)), __LINE__);
        }
        $this->AvsStreet = $avsStreet;
        return $this;
    }
    /**
     * Get AvsZip value
     * @return string|null
     */
    public function getAvsZip()
    {
        return $this->AvsZip;
    }
    /**
     * Set AvsZip value
     * @param string $avsZip
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setAvsZip($avsZip = null)
    {
        // validation for constraint: string
        if (!is_null($avsZip) && !is_string($avsZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsZip, true), gettype($avsZip)), __LINE__);
        }
        $this->AvsZip = $avsZip;
        return $this;
    }
    /**
     * Get SurchargeCaption value
     * @return string|null
     */
    public function getSurchargeCaption()
    {
        return $this->SurchargeCaption;
    }
    /**
     * Set SurchargeCaption value
     * @param string $surchargeCaption
     * @return \eBizCharge\StructType\MerchantTransactionData
     */
    public function setSurchargeCaption($surchargeCaption = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeCaption) && !is_string($surchargeCaption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargeCaption, true), gettype($surchargeCaption)), __LINE__);
        }
        $this->SurchargeCaption = $surchargeCaption;
        return $this;
    }
}
