<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitPrice;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The Taxable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Taxable;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxRate;
    /**
     * The TotalLineAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalLineAmount;
    /**
     * The TotalLineTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalLineTax;
    /**
     * The ItemLineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemLineNumber;
    /**
     * The GrossPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossPrice;
    /**
     * The WarrantyDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WarrantyDiscount;
    /**
     * The SalesDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesDiscount;
    /**
     * The ItemInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemInternalId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemClass;
    /**
     * The ItemCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $ItemCustomFields;
    /**
     * Constructor method for Item
     * @uses Item::setUnitPrice()
     * @uses Item::setQty()
     * @uses Item::setTaxable()
     * @uses Item::setTaxRate()
     * @uses Item::setTotalLineAmount()
     * @uses Item::setTotalLineTax()
     * @uses Item::setItemLineNumber()
     * @uses Item::setGrossPrice()
     * @uses Item::setWarrantyDiscount()
     * @uses Item::setSalesDiscount()
     * @uses Item::setItemInternalId()
     * @uses Item::setItemId()
     * @uses Item::setName()
     * @uses Item::setDescription()
     * @uses Item::setUnitOfMeasure()
     * @uses Item::setItemClass()
     * @uses Item::setItemCustomFields()
     * @param float $unitPrice
     * @param float $qty
     * @param bool $taxable
     * @param float $taxRate
     * @param float $totalLineAmount
     * @param float $totalLineTax
     * @param int $itemLineNumber
     * @param float $grossPrice
     * @param float $warrantyDiscount
     * @param float $salesDiscount
     * @param string $itemInternalId
     * @param string $itemId
     * @param string $name
     * @param string $description
     * @param string $unitOfMeasure
     * @param string $itemClass
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields
     */
    public function __construct($unitPrice = null, $qty = null, $taxable = null, $taxRate = null, $totalLineAmount = null, $totalLineTax = null, $itemLineNumber = null, $grossPrice = null, $warrantyDiscount = null, $salesDiscount = null, $itemInternalId = null, $itemId = null, $name = null, $description = null, $unitOfMeasure = null, $itemClass = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields = null)
    {
        $this
            ->setUnitPrice($unitPrice)
            ->setQty($qty)
            ->setTaxable($taxable)
            ->setTaxRate($taxRate)
            ->setTotalLineAmount($totalLineAmount)
            ->setTotalLineTax($totalLineTax)
            ->setItemLineNumber($itemLineNumber)
            ->setGrossPrice($grossPrice)
            ->setWarrantyDiscount($warrantyDiscount)
            ->setSalesDiscount($salesDiscount)
            ->setItemInternalId($itemInternalId)
            ->setItemId($itemId)
            ->setName($name)
            ->setDescription($description)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setItemClass($itemClass)
            ->setItemCustomFields($itemCustomFields);
    }
    /**
     * Get UnitPrice value
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \eBizCharge\StructType\Item
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \eBizCharge\StructType\Item
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get Taxable value
     * @return bool
     */
    public function getTaxable()
    {
        return $this->Taxable;
    }
    /**
     * Set Taxable value
     * @param bool $taxable
     * @return \eBizCharge\StructType\Item
     */
    public function setTaxable($taxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxable) && !is_bool($taxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxable, true), gettype($taxable)), __LINE__);
        }
        $this->Taxable = $taxable;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \eBizCharge\StructType\Item
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get TotalLineAmount value
     * @return float
     */
    public function getTotalLineAmount()
    {
        return $this->TotalLineAmount;
    }
    /**
     * Set TotalLineAmount value
     * @param float $totalLineAmount
     * @return \eBizCharge\StructType\Item
     */
    public function setTotalLineAmount($totalLineAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalLineAmount) && !(is_float($totalLineAmount) || is_numeric($totalLineAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalLineAmount, true), gettype($totalLineAmount)), __LINE__);
        }
        $this->TotalLineAmount = $totalLineAmount;
        return $this;
    }
    /**
     * Get TotalLineTax value
     * @return float
     */
    public function getTotalLineTax()
    {
        return $this->TotalLineTax;
    }
    /**
     * Set TotalLineTax value
     * @param float $totalLineTax
     * @return \eBizCharge\StructType\Item
     */
    public function setTotalLineTax($totalLineTax = null)
    {
        // validation for constraint: float
        if (!is_null($totalLineTax) && !(is_float($totalLineTax) || is_numeric($totalLineTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalLineTax, true), gettype($totalLineTax)), __LINE__);
        }
        $this->TotalLineTax = $totalLineTax;
        return $this;
    }
    /**
     * Get ItemLineNumber value
     * @return int
     */
    public function getItemLineNumber()
    {
        return $this->ItemLineNumber;
    }
    /**
     * Set ItemLineNumber value
     * @param int $itemLineNumber
     * @return \eBizCharge\StructType\Item
     */
    public function setItemLineNumber($itemLineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemLineNumber) && !(is_int($itemLineNumber) || ctype_digit($itemLineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemLineNumber, true), gettype($itemLineNumber)), __LINE__);
        }
        $this->ItemLineNumber = $itemLineNumber;
        return $this;
    }
    /**
     * Get GrossPrice value
     * @return float
     */
    public function getGrossPrice()
    {
        return $this->GrossPrice;
    }
    /**
     * Set GrossPrice value
     * @param float $grossPrice
     * @return \eBizCharge\StructType\Item
     */
    public function setGrossPrice($grossPrice = null)
    {
        // validation for constraint: float
        if (!is_null($grossPrice) && !(is_float($grossPrice) || is_numeric($grossPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossPrice, true), gettype($grossPrice)), __LINE__);
        }
        $this->GrossPrice = $grossPrice;
        return $this;
    }
    /**
     * Get WarrantyDiscount value
     * @return float
     */
    public function getWarrantyDiscount()
    {
        return $this->WarrantyDiscount;
    }
    /**
     * Set WarrantyDiscount value
     * @param float $warrantyDiscount
     * @return \eBizCharge\StructType\Item
     */
    public function setWarrantyDiscount($warrantyDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($warrantyDiscount) && !(is_float($warrantyDiscount) || is_numeric($warrantyDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($warrantyDiscount, true), gettype($warrantyDiscount)), __LINE__);
        }
        $this->WarrantyDiscount = $warrantyDiscount;
        return $this;
    }
    /**
     * Get SalesDiscount value
     * @return float
     */
    public function getSalesDiscount()
    {
        return $this->SalesDiscount;
    }
    /**
     * Set SalesDiscount value
     * @param float $salesDiscount
     * @return \eBizCharge\StructType\Item
     */
    public function setSalesDiscount($salesDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($salesDiscount) && !(is_float($salesDiscount) || is_numeric($salesDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesDiscount, true), gettype($salesDiscount)), __LINE__);
        }
        $this->SalesDiscount = $salesDiscount;
        return $this;
    }
    /**
     * Get ItemInternalId value
     * @return string|null
     */
    public function getItemInternalId()
    {
        return $this->ItemInternalId;
    }
    /**
     * Set ItemInternalId value
     * @param string $itemInternalId
     * @return \eBizCharge\StructType\Item
     */
    public function setItemInternalId($itemInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemInternalId) && !is_string($itemInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemInternalId, true), gettype($itemInternalId)), __LINE__);
        }
        $this->ItemInternalId = $itemInternalId;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \eBizCharge\StructType\Item
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \eBizCharge\StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\Item
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \eBizCharge\StructType\Item
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get ItemClass value
     * @return string|null
     */
    public function getItemClass()
    {
        return $this->ItemClass;
    }
    /**
     * Set ItemClass value
     * @param string $itemClass
     * @return \eBizCharge\StructType\Item
     */
    public function setItemClass($itemClass = null)
    {
        // validation for constraint: string
        if (!is_null($itemClass) && !is_string($itemClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemClass, true), gettype($itemClass)), __LINE__);
        }
        $this->ItemClass = $itemClass;
        return $this;
    }
    /**
     * Get ItemCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getItemCustomFields()
    {
        return $this->ItemCustomFields;
    }
    /**
     * Set ItemCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields
     * @return \eBizCharge\StructType\Item
     */
    public function setItemCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields = null)
    {
        $this->ItemCustomFields = $itemCustomFields;
        return $this;
    }
}
