<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchStatus StructType
 * @subpackage Structs
 */
class BatchStatus extends AbstractStructBase
{
    /**
     * The SalesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesAmount;
    /**
     * The CreditsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CreditsAmount;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetAmount;
    /**
     * The VoidsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VoidsAmount;
    /**
     * The BatchRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchRefNum;
    /**
     * The Closed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Closed;
    /**
     * The CreditsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditsCount;
    /**
     * The Opened
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Opened;
    /**
     * The VoidsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoidsCount;
    /**
     * The SalesCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesCount;
    /**
     * The Scheduled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Scheduled;
    /**
     * The Sequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sequence;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TransactionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionCount;
    /**
     * Constructor method for BatchStatus
     * @uses BatchStatus::setSalesAmount()
     * @uses BatchStatus::setCreditsAmount()
     * @uses BatchStatus::setNetAmount()
     * @uses BatchStatus::setVoidsAmount()
     * @uses BatchStatus::setBatchRefNum()
     * @uses BatchStatus::setClosed()
     * @uses BatchStatus::setCreditsCount()
     * @uses BatchStatus::setOpened()
     * @uses BatchStatus::setVoidsCount()
     * @uses BatchStatus::setSalesCount()
     * @uses BatchStatus::setScheduled()
     * @uses BatchStatus::setSequence()
     * @uses BatchStatus::setStatus()
     * @uses BatchStatus::setTransactionCount()
     * @param float $salesAmount
     * @param float $creditsAmount
     * @param float $netAmount
     * @param float $voidsAmount
     * @param string $batchRefNum
     * @param string $closed
     * @param string $creditsCount
     * @param string $opened
     * @param string $voidsCount
     * @param string $salesCount
     * @param string $scheduled
     * @param string $sequence
     * @param string $status
     * @param string $transactionCount
     */
    public function __construct($salesAmount = null, $creditsAmount = null, $netAmount = null, $voidsAmount = null, $batchRefNum = null, $closed = null, $creditsCount = null, $opened = null, $voidsCount = null, $salesCount = null, $scheduled = null, $sequence = null, $status = null, $transactionCount = null)
    {
        $this
            ->setSalesAmount($salesAmount)
            ->setCreditsAmount($creditsAmount)
            ->setNetAmount($netAmount)
            ->setVoidsAmount($voidsAmount)
            ->setBatchRefNum($batchRefNum)
            ->setClosed($closed)
            ->setCreditsCount($creditsCount)
            ->setOpened($opened)
            ->setVoidsCount($voidsCount)
            ->setSalesCount($salesCount)
            ->setScheduled($scheduled)
            ->setSequence($sequence)
            ->setStatus($status)
            ->setTransactionCount($transactionCount);
    }
    /**
     * Get SalesAmount value
     * @return float
     */
    public function getSalesAmount()
    {
        return $this->SalesAmount;
    }
    /**
     * Set SalesAmount value
     * @param float $salesAmount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setSalesAmount($salesAmount = null)
    {
        // validation for constraint: float
        if (!is_null($salesAmount) && !(is_float($salesAmount) || is_numeric($salesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesAmount, true), gettype($salesAmount)), __LINE__);
        }
        $this->SalesAmount = $salesAmount;
        return $this;
    }
    /**
     * Get CreditsAmount value
     * @return float
     */
    public function getCreditsAmount()
    {
        return $this->CreditsAmount;
    }
    /**
     * Set CreditsAmount value
     * @param float $creditsAmount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setCreditsAmount($creditsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($creditsAmount) && !(is_float($creditsAmount) || is_numeric($creditsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditsAmount, true), gettype($creditsAmount)), __LINE__);
        }
        $this->CreditsAmount = $creditsAmount;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return float
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param float $netAmount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get VoidsAmount value
     * @return float
     */
    public function getVoidsAmount()
    {
        return $this->VoidsAmount;
    }
    /**
     * Set VoidsAmount value
     * @param float $voidsAmount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setVoidsAmount($voidsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($voidsAmount) && !(is_float($voidsAmount) || is_numeric($voidsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voidsAmount, true), gettype($voidsAmount)), __LINE__);
        }
        $this->VoidsAmount = $voidsAmount;
        return $this;
    }
    /**
     * Get BatchRefNum value
     * @return string|null
     */
    public function getBatchRefNum()
    {
        return $this->BatchRefNum;
    }
    /**
     * Set BatchRefNum value
     * @param string $batchRefNum
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setBatchRefNum($batchRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($batchRefNum) && !is_string($batchRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchRefNum, true), gettype($batchRefNum)), __LINE__);
        }
        $this->BatchRefNum = $batchRefNum;
        return $this;
    }
    /**
     * Get Closed value
     * @return string|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param string $closed
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: string
        if (!is_null($closed) && !is_string($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get CreditsCount value
     * @return string|null
     */
    public function getCreditsCount()
    {
        return $this->CreditsCount;
    }
    /**
     * Set CreditsCount value
     * @param string $creditsCount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setCreditsCount($creditsCount = null)
    {
        // validation for constraint: string
        if (!is_null($creditsCount) && !is_string($creditsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditsCount, true), gettype($creditsCount)), __LINE__);
        }
        $this->CreditsCount = $creditsCount;
        return $this;
    }
    /**
     * Get Opened value
     * @return string|null
     */
    public function getOpened()
    {
        return $this->Opened;
    }
    /**
     * Set Opened value
     * @param string $opened
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setOpened($opened = null)
    {
        // validation for constraint: string
        if (!is_null($opened) && !is_string($opened)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opened, true), gettype($opened)), __LINE__);
        }
        $this->Opened = $opened;
        return $this;
    }
    /**
     * Get VoidsCount value
     * @return string|null
     */
    public function getVoidsCount()
    {
        return $this->VoidsCount;
    }
    /**
     * Set VoidsCount value
     * @param string $voidsCount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setVoidsCount($voidsCount = null)
    {
        // validation for constraint: string
        if (!is_null($voidsCount) && !is_string($voidsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voidsCount, true), gettype($voidsCount)), __LINE__);
        }
        $this->VoidsCount = $voidsCount;
        return $this;
    }
    /**
     * Get SalesCount value
     * @return string|null
     */
    public function getSalesCount()
    {
        return $this->SalesCount;
    }
    /**
     * Set SalesCount value
     * @param string $salesCount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setSalesCount($salesCount = null)
    {
        // validation for constraint: string
        if (!is_null($salesCount) && !is_string($salesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesCount, true), gettype($salesCount)), __LINE__);
        }
        $this->SalesCount = $salesCount;
        return $this;
    }
    /**
     * Get Scheduled value
     * @return string|null
     */
    public function getScheduled()
    {
        return $this->Scheduled;
    }
    /**
     * Set Scheduled value
     * @param string $scheduled
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setScheduled($scheduled = null)
    {
        // validation for constraint: string
        if (!is_null($scheduled) && !is_string($scheduled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduled, true), gettype($scheduled)), __LINE__);
        }
        $this->Scheduled = $scheduled;
        return $this;
    }
    /**
     * Get Sequence value
     * @return string|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param string $sequence
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: string
        if (!is_null($sequence) && !is_string($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransactionCount value
     * @return string|null
     */
    public function getTransactionCount()
    {
        return $this->TransactionCount;
    }
    /**
     * Set TransactionCount value
     * @param string $transactionCount
     * @return \eBizCharge\StructType\BatchStatus
     */
    public function setTransactionCount($transactionCount = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCount) && !is_string($transactionCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCount, true), gettype($transactionCount)), __LINE__);
        }
        $this->TransactionCount = $transactionCount;
        return $this;
    }
}
