<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResult StructType
 * @subpackage Structs
 */
class LoginResult extends AbstractStructBase
{
    /**
     * The IsSandbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsSandbox;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserType;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The MerchantName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantName;
    /**
     * The SK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SK;
    /**
     * The SKPin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKPin;
    /**
     * The EbizToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $EbizToken;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The CustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerInternalId;
    /**
     * The UserInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserInternalId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * Constructor method for LoginResult
     * @uses LoginResult::setIsSandbox()
     * @uses LoginResult::setUserType()
     * @uses LoginResult::setStatusCode()
     * @uses LoginResult::setErrorCode()
     * @uses LoginResult::setMerchantId()
     * @uses LoginResult::setMerchantName()
     * @uses LoginResult::setSK()
     * @uses LoginResult::setSKPin()
     * @uses LoginResult::setEbizToken()
     * @uses LoginResult::setCustomerId()
     * @uses LoginResult::setCustomerInternalId()
     * @uses LoginResult::setUserInternalId()
     * @uses LoginResult::setStatus()
     * @uses LoginResult::setError()
     * @param int $isSandbox
     * @param int $userType
     * @param int $statusCode
     * @param int $errorCode
     * @param string $merchantId
     * @param string $merchantName
     * @param string $sK
     * @param string $sKPin
     * @param \eBizCharge\StructType\SecurityToken $ebizToken
     * @param string $customerId
     * @param string $customerInternalId
     * @param string $userInternalId
     * @param string $status
     * @param string $error
     */
    public function __construct($isSandbox = null, $userType = null, $statusCode = null, $errorCode = null, $merchantId = null, $merchantName = null, $sK = null, $sKPin = null, \eBizCharge\StructType\SecurityToken $ebizToken = null, $customerId = null, $customerInternalId = null, $userInternalId = null, $status = null, $error = null)
    {
        $this
            ->setIsSandbox($isSandbox)
            ->setUserType($userType)
            ->setStatusCode($statusCode)
            ->setErrorCode($errorCode)
            ->setMerchantId($merchantId)
            ->setMerchantName($merchantName)
            ->setSK($sK)
            ->setSKPin($sKPin)
            ->setEbizToken($ebizToken)
            ->setCustomerId($customerId)
            ->setCustomerInternalId($customerInternalId)
            ->setUserInternalId($userInternalId)
            ->setStatus($status)
            ->setError($error);
    }
    /**
     * Get IsSandbox value
     * @return int
     */
    public function getIsSandbox()
    {
        return $this->IsSandbox;
    }
    /**
     * Set IsSandbox value
     * @param int $isSandbox
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setIsSandbox($isSandbox = null)
    {
        // validation for constraint: int
        if (!is_null($isSandbox) && !(is_int($isSandbox) || ctype_digit($isSandbox))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isSandbox, true), gettype($isSandbox)), __LINE__);
        }
        $this->IsSandbox = $isSandbox;
        return $this;
    }
    /**
     * Get UserType value
     * @return int
     */
    public function getUserType()
    {
        return $this->UserType;
    }
    /**
     * Set UserType value
     * @param int $userType
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: int
        if (!is_null($userType) && !(is_int($userType) || ctype_digit($userType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userType, true), gettype($userType)), __LINE__);
        }
        $this->UserType = $userType;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get MerchantName value
     * @return string|null
     */
    public function getMerchantName()
    {
        return $this->MerchantName;
    }
    /**
     * Set MerchantName value
     * @param string $merchantName
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setMerchantName($merchantName = null)
    {
        // validation for constraint: string
        if (!is_null($merchantName) && !is_string($merchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantName, true), gettype($merchantName)), __LINE__);
        }
        $this->MerchantName = $merchantName;
        return $this;
    }
    /**
     * Get SK value
     * @return string|null
     */
    public function getSK()
    {
        return $this->SK;
    }
    /**
     * Set SK value
     * @param string $sK
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setSK($sK = null)
    {
        // validation for constraint: string
        if (!is_null($sK) && !is_string($sK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sK, true), gettype($sK)), __LINE__);
        }
        $this->SK = $sK;
        return $this;
    }
    /**
     * Get SKPin value
     * @return string|null
     */
    public function getSKPin()
    {
        return $this->SKPin;
    }
    /**
     * Set SKPin value
     * @param string $sKPin
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setSKPin($sKPin = null)
    {
        // validation for constraint: string
        if (!is_null($sKPin) && !is_string($sKPin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKPin, true), gettype($sKPin)), __LINE__);
        }
        $this->SKPin = $sKPin;
        return $this;
    }
    /**
     * Get EbizToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getEbizToken()
    {
        return $this->EbizToken;
    }
    /**
     * Set EbizToken value
     * @param \eBizCharge\StructType\SecurityToken $ebizToken
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setEbizToken(\eBizCharge\StructType\SecurityToken $ebizToken = null)
    {
        $this->EbizToken = $ebizToken;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustomerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->CustomerInternalId;
    }
    /**
     * Set CustomerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->CustomerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get UserInternalId value
     * @return string|null
     */
    public function getUserInternalId()
    {
        return $this->UserInternalId;
    }
    /**
     * Set UserInternalId value
     * @param string $userInternalId
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setUserInternalId($userInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($userInternalId) && !is_string($userInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInternalId, true), gettype($userInternalId)), __LINE__);
        }
        $this->UserInternalId = $userInternalId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \eBizCharge\StructType\LoginResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
