<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringBillingDetails StructType
 * @subpackage Structs
 */
class RecurringBillingDetails extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Enabled;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Start;
    /**
     * The Expire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Expire;
    /**
     * The Next
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Next;
    /**
     * The RepeatCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepeatCount;
    /**
     * The SendCustomerReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendCustomerReceipt;
    /**
     * The ScheduledPaymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledPaymentInternalId;
    /**
     * The CustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerInternalId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The NumLeft
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumLeft;
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule;
    /**
     * The CustomScheduleObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CustomSchedule
     */
    public $CustomScheduleObject;
    /**
     * The ScheduleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduleName;
    /**
     * The ReceiptNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNote;
    /**
     * The ReceiptTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptTemplateName;
    /**
     * The CustNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustNum;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The MaskedPM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaskedPM;
    /**
     * The PMHolderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PMHolderName;
    /**
     * The PMExpirationYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PMExpirationYear;
    /**
     * The PMExpirationMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PMExpirationMonth;
    /**
     * The PmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PmType;
    /**
     * The ScheduleStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduleStatus;
    /**
     * The DateTimeCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeCreated;
    /**
     * The DateTimeModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeModified;
    /**
     * Constructor method for RecurringBillingDetails
     * @uses RecurringBillingDetails::setAmount()
     * @uses RecurringBillingDetails::setTax()
     * @uses RecurringBillingDetails::setEnabled()
     * @uses RecurringBillingDetails::setStart()
     * @uses RecurringBillingDetails::setExpire()
     * @uses RecurringBillingDetails::setNext()
     * @uses RecurringBillingDetails::setRepeatCount()
     * @uses RecurringBillingDetails::setSendCustomerReceipt()
     * @uses RecurringBillingDetails::setScheduledPaymentInternalId()
     * @uses RecurringBillingDetails::setCustomerInternalId()
     * @uses RecurringBillingDetails::setCustomerId()
     * @uses RecurringBillingDetails::setNumLeft()
     * @uses RecurringBillingDetails::setSchedule()
     * @uses RecurringBillingDetails::setCustomScheduleObject()
     * @uses RecurringBillingDetails::setScheduleName()
     * @uses RecurringBillingDetails::setReceiptNote()
     * @uses RecurringBillingDetails::setReceiptTemplateName()
     * @uses RecurringBillingDetails::setCustNum()
     * @uses RecurringBillingDetails::setPaymentMethodId()
     * @uses RecurringBillingDetails::setMaskedPM()
     * @uses RecurringBillingDetails::setPMHolderName()
     * @uses RecurringBillingDetails::setPMExpirationYear()
     * @uses RecurringBillingDetails::setPMExpirationMonth()
     * @uses RecurringBillingDetails::setPmType()
     * @uses RecurringBillingDetails::setScheduleStatus()
     * @uses RecurringBillingDetails::setDateTimeCreated()
     * @uses RecurringBillingDetails::setDateTimeModified()
     * @param float $amount
     * @param float $tax
     * @param bool $enabled
     * @param string $start
     * @param string $expire
     * @param string $next
     * @param int $repeatCount
     * @param bool $sendCustomerReceipt
     * @param string $scheduledPaymentInternalId
     * @param string $customerInternalId
     * @param string $customerId
     * @param string $numLeft
     * @param string $schedule
     * @param \eBizCharge\StructType\CustomSchedule $customScheduleObject
     * @param string $scheduleName
     * @param string $receiptNote
     * @param string $receiptTemplateName
     * @param string $custNum
     * @param string $paymentMethodId
     * @param string $maskedPM
     * @param string $pMHolderName
     * @param string $pMExpirationYear
     * @param string $pMExpirationMonth
     * @param string $pmType
     * @param string $scheduleStatus
     * @param string $dateTimeCreated
     * @param string $dateTimeModified
     */
    public function __construct($amount = null, $tax = null, $enabled = null, $start = null, $expire = null, $next = null, $repeatCount = null, $sendCustomerReceipt = null, $scheduledPaymentInternalId = null, $customerInternalId = null, $customerId = null, $numLeft = null, $schedule = null, \eBizCharge\StructType\CustomSchedule $customScheduleObject = null, $scheduleName = null, $receiptNote = null, $receiptTemplateName = null, $custNum = null, $paymentMethodId = null, $maskedPM = null, $pMHolderName = null, $pMExpirationYear = null, $pMExpirationMonth = null, $pmType = null, $scheduleStatus = null, $dateTimeCreated = null, $dateTimeModified = null)
    {
        $this
            ->setAmount($amount)
            ->setTax($tax)
            ->setEnabled($enabled)
            ->setStart($start)
            ->setExpire($expire)
            ->setNext($next)
            ->setRepeatCount($repeatCount)
            ->setSendCustomerReceipt($sendCustomerReceipt)
            ->setScheduledPaymentInternalId($scheduledPaymentInternalId)
            ->setCustomerInternalId($customerInternalId)
            ->setCustomerId($customerId)
            ->setNumLeft($numLeft)
            ->setSchedule($schedule)
            ->setCustomScheduleObject($customScheduleObject)
            ->setScheduleName($scheduleName)
            ->setReceiptNote($receiptNote)
            ->setReceiptTemplateName($receiptTemplateName)
            ->setCustNum($custNum)
            ->setPaymentMethodId($paymentMethodId)
            ->setMaskedPM($maskedPM)
            ->setPMHolderName($pMHolderName)
            ->setPMExpirationYear($pMExpirationYear)
            ->setPMExpirationMonth($pMExpirationMonth)
            ->setPmType($pmType)
            ->setScheduleStatus($scheduleStatus)
            ->setDateTimeCreated($dateTimeCreated)
            ->setDateTimeModified($dateTimeModified);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setTax($tax = null)
    {
        // validation for constraint: float
        if (!is_null($tax) && !(is_float($tax) || is_numeric($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Expire value
     * @return string
     */
    public function getExpire()
    {
        return $this->Expire;
    }
    /**
     * Set Expire value
     * @param string $expire
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setExpire($expire = null)
    {
        // validation for constraint: string
        if (!is_null($expire) && !is_string($expire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expire, true), gettype($expire)), __LINE__);
        }
        $this->Expire = $expire;
        return $this;
    }
    /**
     * Get Next value
     * @return string
     */
    public function getNext()
    {
        return $this->Next;
    }
    /**
     * Set Next value
     * @param string $next
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setNext($next = null)
    {
        // validation for constraint: string
        if (!is_null($next) && !is_string($next)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($next, true), gettype($next)), __LINE__);
        }
        $this->Next = $next;
        return $this;
    }
    /**
     * Get RepeatCount value
     * @return int
     */
    public function getRepeatCount()
    {
        return $this->RepeatCount;
    }
    /**
     * Set RepeatCount value
     * @param int $repeatCount
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setRepeatCount($repeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($repeatCount) && !(is_int($repeatCount) || ctype_digit($repeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repeatCount, true), gettype($repeatCount)), __LINE__);
        }
        $this->RepeatCount = $repeatCount;
        return $this;
    }
    /**
     * Get SendCustomerReceipt value
     * @return bool
     */
    public function getSendCustomerReceipt()
    {
        return $this->SendCustomerReceipt;
    }
    /**
     * Set SendCustomerReceipt value
     * @param bool $sendCustomerReceipt
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setSendCustomerReceipt($sendCustomerReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendCustomerReceipt) && !is_bool($sendCustomerReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendCustomerReceipt, true), gettype($sendCustomerReceipt)), __LINE__);
        }
        $this->SendCustomerReceipt = $sendCustomerReceipt;
        return $this;
    }
    /**
     * Get ScheduledPaymentInternalId value
     * @return string|null
     */
    public function getScheduledPaymentInternalId()
    {
        return $this->ScheduledPaymentInternalId;
    }
    /**
     * Set ScheduledPaymentInternalId value
     * @param string $scheduledPaymentInternalId
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setScheduledPaymentInternalId($scheduledPaymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledPaymentInternalId) && !is_string($scheduledPaymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledPaymentInternalId, true), gettype($scheduledPaymentInternalId)), __LINE__);
        }
        $this->ScheduledPaymentInternalId = $scheduledPaymentInternalId;
        return $this;
    }
    /**
     * Get CustomerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->CustomerInternalId;
    }
    /**
     * Set CustomerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->CustomerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NumLeft value
     * @return string|null
     */
    public function getNumLeft()
    {
        return $this->NumLeft;
    }
    /**
     * Set NumLeft value
     * @param string $numLeft
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setNumLeft($numLeft = null)
    {
        // validation for constraint: string
        if (!is_null($numLeft) && !is_string($numLeft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numLeft, true), gettype($numLeft)), __LINE__);
        }
        $this->NumLeft = $numLeft;
        return $this;
    }
    /**
     * Get Schedule value
     * @return string|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param string $schedule
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: string
        if (!is_null($schedule) && !is_string($schedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule, true), gettype($schedule)), __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get CustomScheduleObject value
     * @return \eBizCharge\StructType\CustomSchedule|null
     */
    public function getCustomScheduleObject()
    {
        return $this->CustomScheduleObject;
    }
    /**
     * Set CustomScheduleObject value
     * @param \eBizCharge\StructType\CustomSchedule $customScheduleObject
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setCustomScheduleObject(\eBizCharge\StructType\CustomSchedule $customScheduleObject = null)
    {
        $this->CustomScheduleObject = $customScheduleObject;
        return $this;
    }
    /**
     * Get ScheduleName value
     * @return string|null
     */
    public function getScheduleName()
    {
        return $this->ScheduleName;
    }
    /**
     * Set ScheduleName value
     * @param string $scheduleName
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setScheduleName($scheduleName = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleName) && !is_string($scheduleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleName, true), gettype($scheduleName)), __LINE__);
        }
        $this->ScheduleName = $scheduleName;
        return $this;
    }
    /**
     * Get ReceiptNote value
     * @return string|null
     */
    public function getReceiptNote()
    {
        return $this->ReceiptNote;
    }
    /**
     * Set ReceiptNote value
     * @param string $receiptNote
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setReceiptNote($receiptNote = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNote) && !is_string($receiptNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNote, true), gettype($receiptNote)), __LINE__);
        }
        $this->ReceiptNote = $receiptNote;
        return $this;
    }
    /**
     * Get ReceiptTemplateName value
     * @return string|null
     */
    public function getReceiptTemplateName()
    {
        return $this->ReceiptTemplateName;
    }
    /**
     * Set ReceiptTemplateName value
     * @param string $receiptTemplateName
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setReceiptTemplateName($receiptTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($receiptTemplateName) && !is_string($receiptTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptTemplateName, true), gettype($receiptTemplateName)), __LINE__);
        }
        $this->ReceiptTemplateName = $receiptTemplateName;
        return $this;
    }
    /**
     * Get CustNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->CustNum;
    }
    /**
     * Set CustNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->CustNum = $custNum;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get MaskedPM value
     * @return string|null
     */
    public function getMaskedPM()
    {
        return $this->MaskedPM;
    }
    /**
     * Set MaskedPM value
     * @param string $maskedPM
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setMaskedPM($maskedPM = null)
    {
        // validation for constraint: string
        if (!is_null($maskedPM) && !is_string($maskedPM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedPM, true), gettype($maskedPM)), __LINE__);
        }
        $this->MaskedPM = $maskedPM;
        return $this;
    }
    /**
     * Get PMHolderName value
     * @return string|null
     */
    public function getPMHolderName()
    {
        return $this->PMHolderName;
    }
    /**
     * Set PMHolderName value
     * @param string $pMHolderName
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setPMHolderName($pMHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($pMHolderName) && !is_string($pMHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMHolderName, true), gettype($pMHolderName)), __LINE__);
        }
        $this->PMHolderName = $pMHolderName;
        return $this;
    }
    /**
     * Get PMExpirationYear value
     * @return string|null
     */
    public function getPMExpirationYear()
    {
        return $this->PMExpirationYear;
    }
    /**
     * Set PMExpirationYear value
     * @param string $pMExpirationYear
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setPMExpirationYear($pMExpirationYear = null)
    {
        // validation for constraint: string
        if (!is_null($pMExpirationYear) && !is_string($pMExpirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMExpirationYear, true), gettype($pMExpirationYear)), __LINE__);
        }
        $this->PMExpirationYear = $pMExpirationYear;
        return $this;
    }
    /**
     * Get PMExpirationMonth value
     * @return string|null
     */
    public function getPMExpirationMonth()
    {
        return $this->PMExpirationMonth;
    }
    /**
     * Set PMExpirationMonth value
     * @param string $pMExpirationMonth
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setPMExpirationMonth($pMExpirationMonth = null)
    {
        // validation for constraint: string
        if (!is_null($pMExpirationMonth) && !is_string($pMExpirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMExpirationMonth, true), gettype($pMExpirationMonth)), __LINE__);
        }
        $this->PMExpirationMonth = $pMExpirationMonth;
        return $this;
    }
    /**
     * Get PmType value
     * @return string|null
     */
    public function getPmType()
    {
        return $this->PmType;
    }
    /**
     * Set PmType value
     * @param string $pmType
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setPmType($pmType = null)
    {
        // validation for constraint: string
        if (!is_null($pmType) && !is_string($pmType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pmType, true), gettype($pmType)), __LINE__);
        }
        $this->PmType = $pmType;
        return $this;
    }
    /**
     * Get ScheduleStatus value
     * @return string|null
     */
    public function getScheduleStatus()
    {
        return $this->ScheduleStatus;
    }
    /**
     * Set ScheduleStatus value
     * @param string $scheduleStatus
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setScheduleStatus($scheduleStatus = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleStatus) && !is_string($scheduleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleStatus, true), gettype($scheduleStatus)), __LINE__);
        }
        $this->ScheduleStatus = $scheduleStatus;
        return $this;
    }
    /**
     * Get DateTimeCreated value
     * @return string|null
     */
    public function getDateTimeCreated()
    {
        return $this->DateTimeCreated;
    }
    /**
     * Set DateTimeCreated value
     * @param string $dateTimeCreated
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setDateTimeCreated($dateTimeCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeCreated) && !is_string($dateTimeCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeCreated, true), gettype($dateTimeCreated)), __LINE__);
        }
        $this->DateTimeCreated = $dateTimeCreated;
        return $this;
    }
    /**
     * Get DateTimeModified value
     * @return string|null
     */
    public function getDateTimeModified()
    {
        return $this->DateTimeModified;
    }
    /**
     * Set DateTimeModified value
     * @param string $dateTimeModified
     * @return \eBizCharge\StructType\RecurringBillingDetails
     */
    public function setDateTimeModified($dateTimeModified = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeModified) && !is_string($dateTimeModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeModified, true), gettype($dateTimeModified)), __LINE__);
        }
        $this->DateTimeModified = $dateTimeModified;
        return $this;
    }
}
