<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkInvoiceAsSynchronized StructType
 * @subpackage Structs
 */
class MarkInvoiceAsSynchronized extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The invoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceInternalId;
    /**
     * Constructor method for MarkInvoiceAsSynchronized
     * @uses MarkInvoiceAsSynchronized::setSecurityToken()
     * @uses MarkInvoiceAsSynchronized::setInvoiceInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $invoiceInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $invoiceInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setInvoiceInternalId($invoiceInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\MarkInvoiceAsSynchronized
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get invoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->invoiceInternalId;
    }
    /**
     * Set invoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\MarkInvoiceAsSynchronized
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->invoiceInternalId = $invoiceInternalId;
        return $this;
    }
}
