<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailReceiptResponse StructType
 * @subpackage Structs
 */
class EmailReceiptResponse extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The EmailReceiptResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\EmailReceiptResponse
     */
    public $EmailReceiptResult;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * Constructor method for EmailReceiptResponse
     * @uses EmailReceiptResponse::setStatusCode()
     * @uses EmailReceiptResponse::setErrorCode()
     * @uses EmailReceiptResponse::setEmailReceiptResult()
     * @uses EmailReceiptResponse::setStatus()
     * @uses EmailReceiptResponse::setError()
     * @param int $statusCode
     * @param int $errorCode
     * @param \eBizCharge\StructType\EmailReceiptResponse $emailReceiptResult
     * @param string $status
     * @param string $error
     */
    public function __construct($statusCode = null, $errorCode = null, \eBizCharge\StructType\EmailReceiptResponse $emailReceiptResult = null, $status = null, $error = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setErrorCode($errorCode)
            ->setEmailReceiptResult($emailReceiptResult)
            ->setStatus($status)
            ->setError($error);
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \eBizCharge\StructType\EmailReceiptResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \eBizCharge\StructType\EmailReceiptResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get EmailReceiptResult value
     * @return \eBizCharge\StructType\EmailReceiptResponse|null
     */
    public function getEmailReceiptResult()
    {
        return $this->EmailReceiptResult;
    }
    /**
     * Set EmailReceiptResult value
     * @param \eBizCharge\StructType\EmailReceiptResponse $emailReceiptResult
     * @return \eBizCharge\StructType\EmailReceiptResponse
     */
    public function setEmailReceiptResult(\eBizCharge\StructType\EmailReceiptResponse $emailReceiptResult = null)
    {
        $this->EmailReceiptResult = $emailReceiptResult;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\EmailReceiptResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \eBizCharge\StructType\EmailReceiptResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
