<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetCustomer $parameters
     * @return \eBizCharge\StructType\GetCustomerResponse|bool
     */
    public function GetCustomer(\eBizCharge\StructType\GetCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGWCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetGWCustomer $parameters
     * @return \eBizCharge\StructType\GetGWCustomerResponse|bool
     */
    public function GetGWCustomer(\eBizCharge\StructType\GetGWCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGWCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetSubCustomer $parameters
     * @return \eBizCharge\StructType\GetSubCustomerResponse|bool
     */
    public function GetSubCustomer(\eBizCharge\StructType\GetSubCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSubCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetInvoice $parameters
     * @return \eBizCharge\StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\eBizCharge\StructType\GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetPayments $parameters
     * @return \eBizCharge\StructType\GetPaymentsResponse|bool
     */
    public function GetPayments(\eBizCharge\StructType\GetPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetPaymentsCount $parameters
     * @return \eBizCharge\StructType\GetPaymentsCountResponse|bool
     */
    public function GetPaymentsCount(\eBizCharge\StructType\GetPaymentsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetInvoicePayments $parameters
     * @return \eBizCharge\StructType\GetInvoicePaymentsResponse|bool
     */
    public function GetInvoicePayments(\eBizCharge\StructType\GetInvoicePayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoicePayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentFormURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetPaymentFormURL $parameters
     * @return \eBizCharge\StructType\GetPaymentFormURLResponse|bool
     */
    public function GetPaymentFormURL(\eBizCharge\StructType\GetPaymentFormURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentFormURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEbizWebFormURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetEbizWebFormURL $parameters
     * @return \eBizCharge\StructType\GetEbizWebFormURLResponse|bool
     */
    public function GetEbizWebFormURL(\eBizCharge\StructType\GetEbizWebFormURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEbizWebFormURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentsByGatewayRefNum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetPaymentsByGatewayRefNum $parameters
     * @return \eBizCharge\StructType\GetPaymentsByGatewayRefNumResponse|bool
     */
    public function GetPaymentsByGatewayRefNum(\eBizCharge\StructType\GetPaymentsByGatewayRefNum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentsByGatewayRefNum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmailTemplates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetEmailTemplates $parameters
     * @return \eBizCharge\StructType\GetEmailTemplatesResponse|bool
     */
    public function GetEmailTemplates(\eBizCharge\StructType\GetEmailTemplates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEmailTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMerchantTransactionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetMerchantTransactionData $parameters
     * @return \eBizCharge\StructType\GetMerchantTransactionDataResponse|bool
     */
    public function GetMerchantTransactionData(\eBizCharge\StructType\GetMerchantTransactionData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMerchantTransactionData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMerchantTransactionDataBySK
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetMerchantTransactionDataBySK $parameters
     * @return \eBizCharge\StructType\GetMerchantTransactionDataBySKResponse|bool
     */
    public function GetMerchantTransactionDataBySK(\eBizCharge\StructType\GetMerchantTransactionDataBySK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMerchantTransactionDataBySK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetUserData $parameters
     * @return \eBizCharge\StructType\GetUserDataResponse|bool
     */
    public function GetUserData(\eBizCharge\StructType\GetUserData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMerchantData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetMerchantData $parameters
     * @return \eBizCharge\StructType\GetMerchantDataResponse|bool
     */
    public function GetMerchantData(\eBizCharge\StructType\GetMerchantData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMerchantData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetCustomerToken $parameters
     * @return \eBizCharge\StructType\GetCustomerTokenResponse|bool
     */
    public function GetCustomerToken(\eBizCharge\StructType\GetCustomerToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerPaymentMethodProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetCustomerPaymentMethodProfiles $parameters
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfilesResponse|bool
     */
    public function GetCustomerPaymentMethodProfiles(\eBizCharge\StructType\GetCustomerPaymentMethodProfiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerPaymentMethodProfiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerPaymentMethodProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetCustomerPaymentMethodProfile $parameters
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfileResponse|bool
     */
    public function GetCustomerPaymentMethodProfile(\eBizCharge\StructType\GetCustomerPaymentMethodProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerPaymentMethodProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetTransactionDetails $parameters
     * @return \eBizCharge\StructType\GetTransactionDetailsResponse|bool
     */
    public function GetTransactionDetails(\eBizCharge\StructType\GetTransactionDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransactionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReceiptsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetReceiptsList $parameters
     * @return \eBizCharge\StructType\GetReceiptsListResponse|bool
     */
    public function GetReceiptsList(\eBizCharge\StructType\GetReceiptsList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReceiptsList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBatchStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetBatchStatus $parameters
     * @return \eBizCharge\StructType\GetBatchStatusResponse|bool
     */
    public function GetBatchStatus(\eBizCharge\StructType\GetBatchStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBatchStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBatchTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetBatchTransactions $parameters
     * @return \eBizCharge\StructType\GetBatchTransactionsResponse|bool
     */
    public function GetBatchTransactions(\eBizCharge\StructType\GetBatchTransactions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBatchTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplicationData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetApplicationData $parameters
     * @return \eBizCharge\StructType\GetApplicationDataResponse|bool
     */
    public function GetApplicationData(\eBizCharge\StructType\GetApplicationData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalesOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetSalesOrder $parameters
     * @return \eBizCharge\StructType\GetSalesOrderResponse|bool
     */
    public function GetSalesOrder(\eBizCharge\StructType\GetSalesOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalesOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalesRep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetSalesRep $parameters
     * @return \eBizCharge\StructType\GetSalesRepResponse|bool
     */
    public function GetSalesRep(\eBizCharge\StructType\GetSalesRep $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalesRep($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetTerms $parameters
     * @return \eBizCharge\StructType\GetTermsResponse|bool
     */
    public function GetTerms(\eBizCharge\StructType\GetTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetCardInfo $parameters
     * @return \eBizCharge\StructType\GetCardInfoResponse|bool
     */
    public function GetCardInfo(\eBizCharge\StructType\GetCardInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetZipCodeInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\GetZipCodeInfo $parameters
     * @return \eBizCharge\StructType\GetZipCodeInfoResponse|bool
     */
    public function GetZipCodeInfo(\eBizCharge\StructType\GetZipCodeInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZipCodeInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\GetApplicationDataResponse|\eBizCharge\StructType\GetBatchStatusResponse|\eBizCharge\StructType\GetBatchTransactionsResponse|\eBizCharge\StructType\GetCardInfoResponse|\eBizCharge\StructType\GetCustomerPaymentMethodProfileResponse|\eBizCharge\StructType\GetCustomerPaymentMethodProfilesResponse|\eBizCharge\StructType\GetCustomerResponse|\eBizCharge\StructType\GetCustomerTokenResponse|\eBizCharge\StructType\GetEbizWebFormURLResponse|\eBizCharge\StructType\GetEmailTemplatesResponse|\eBizCharge\StructType\GetGWCustomerResponse|\eBizCharge\StructType\GetInvoicePaymentsResponse|\eBizCharge\StructType\GetInvoiceResponse|\eBizCharge\StructType\GetMerchantDataResponse|\eBizCharge\StructType\GetMerchantTransactionDataBySKResponse|\eBizCharge\StructType\GetMerchantTransactionDataResponse|\eBizCharge\StructType\GetPaymentFormURLResponse|\eBizCharge\StructType\GetPaymentsByGatewayRefNumResponse|\eBizCharge\StructType\GetPaymentsCountResponse|\eBizCharge\StructType\GetPaymentsResponse|\eBizCharge\StructType\GetReceiptsListResponse|\eBizCharge\StructType\GetSalesOrderResponse|\eBizCharge\StructType\GetSalesRepResponse|\eBizCharge\StructType\GetSubCustomerResponse|\eBizCharge\StructType\GetTermsResponse|\eBizCharge\StructType\GetTransactionDetailsResponse|\eBizCharge\StructType\GetUserDataResponse|\eBizCharge\StructType\GetZipCodeInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
