<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The InvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InvoiceAmount;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountDue;
    /**
     * The NotifyCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NotifyCustomer;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalTaxAmount;
    /**
     * The InvoiceIsToBeEmailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InvoiceIsToBeEmailed;
    /**
     * The InvoiceIsToBePrinted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InvoiceIsToBePrinted;
    /**
     * The TotalDiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalDiscountAmount;
    /**
     * The TotalShippingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalShippingAmount;
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SubCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCustomerId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalId;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The InvoiceDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDueDate;
    /**
     * The PoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNum;
    /**
     * The SoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoNum;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeId;
    /**
     * The UploadedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UploadedBy;
    /**
     * The UpdatedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedBy;
    /**
     * The DateUploaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateUploaded;
    /**
     * The DateUpdated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateUpdated;
    /**
     * The isDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isDeleted;
    /**
     * The DeletedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeletedBy;
    /**
     * The DateDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateDeleted;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfItem
     */
    public $Items;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * The EmailTemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTemplateID;
    /**
     * The InvoiceURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceURL;
    /**
     * The InvoiceUniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceUniqueId;
    /**
     * The InvoiceDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDescription;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The InvoiceCustomerMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCustomerMessage;
    /**
     * The InvoiceMemo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceMemo;
    /**
     * The InvoiceShipDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceShipDate;
    /**
     * The InvoiceShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceShipVia;
    /**
     * The InvoiceTermsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceTermsId;
    /**
     * The InvoiceSalesRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceSalesRepId;
    /**
     * The InvoiceLastSyncDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceLastSyncDateTime;
    /**
     * The DeliveryNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNumber;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationId;
    /**
     * The RemitToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $RemitToAddress;
    /**
     * The PoDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoDate;
    /**
     * The OrderedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderedBy;
    /**
     * The InvoiceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceClass;
    /**
     * The InvoiceFOB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceFOB;
    /**
     * The InvoiceTermsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceTermsDescription;
    /**
     * The InvoiceCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $InvoiceCustomFields;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setInvoiceAmount()
     * @uses Invoice::setAmountDue()
     * @uses Invoice::setNotifyCustomer()
     * @uses Invoice::setTotalTaxAmount()
     * @uses Invoice::setInvoiceIsToBeEmailed()
     * @uses Invoice::setInvoiceIsToBePrinted()
     * @uses Invoice::setTotalDiscountAmount()
     * @uses Invoice::setTotalShippingAmount()
     * @uses Invoice::setMerchantId()
     * @uses Invoice::setCustomerId()
     * @uses Invoice::setSubCustomerId()
     * @uses Invoice::setInvoiceNumber()
     * @uses Invoice::setInvoiceInternalId()
     * @uses Invoice::setInvoiceDate()
     * @uses Invoice::setCurrency()
     * @uses Invoice::setInvoiceDueDate()
     * @uses Invoice::setPoNum()
     * @uses Invoice::setSoNum()
     * @uses Invoice::setDivisionId()
     * @uses Invoice::setTypeId()
     * @uses Invoice::setUploadedBy()
     * @uses Invoice::setUpdatedBy()
     * @uses Invoice::setDateUploaded()
     * @uses Invoice::setDateUpdated()
     * @uses Invoice::setIsDeleted()
     * @uses Invoice::setDeletedBy()
     * @uses Invoice::setDateDeleted()
     * @uses Invoice::setItems()
     * @uses Invoice::setSoftware()
     * @uses Invoice::setEmailTemplateID()
     * @uses Invoice::setInvoiceURL()
     * @uses Invoice::setInvoiceUniqueId()
     * @uses Invoice::setInvoiceDescription()
     * @uses Invoice::setBillingAddress()
     * @uses Invoice::setShippingAddress()
     * @uses Invoice::setInvoiceCustomerMessage()
     * @uses Invoice::setInvoiceMemo()
     * @uses Invoice::setInvoiceShipDate()
     * @uses Invoice::setInvoiceShipVia()
     * @uses Invoice::setInvoiceTermsId()
     * @uses Invoice::setInvoiceSalesRepId()
     * @uses Invoice::setInvoiceLastSyncDateTime()
     * @uses Invoice::setDeliveryNumber()
     * @uses Invoice::setLocationId()
     * @uses Invoice::setRemitToAddress()
     * @uses Invoice::setPoDate()
     * @uses Invoice::setOrderedBy()
     * @uses Invoice::setInvoiceClass()
     * @uses Invoice::setInvoiceFOB()
     * @uses Invoice::setInvoiceTermsDescription()
     * @uses Invoice::setInvoiceCustomFields()
     * @param float $invoiceAmount
     * @param float $amountDue
     * @param bool $notifyCustomer
     * @param float $totalTaxAmount
     * @param bool $invoiceIsToBeEmailed
     * @param bool $invoiceIsToBePrinted
     * @param float $totalDiscountAmount
     * @param float $totalShippingAmount
     * @param string $merchantId
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $invoiceNumber
     * @param string $invoiceInternalId
     * @param string $invoiceDate
     * @param string $currency
     * @param string $invoiceDueDate
     * @param string $poNum
     * @param string $soNum
     * @param string $divisionId
     * @param string $typeId
     * @param string $uploadedBy
     * @param string $updatedBy
     * @param string $dateUploaded
     * @param string $dateUpdated
     * @param string $isDeleted
     * @param string $deletedBy
     * @param string $dateDeleted
     * @param \eBizCharge\ArrayType\ArrayOfItem $items
     * @param string $software
     * @param string $emailTemplateID
     * @param string $invoiceURL
     * @param string $invoiceUniqueId
     * @param string $invoiceDescription
     * @param \eBizCharge\StructType\Address $billingAddress
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @param string $invoiceCustomerMessage
     * @param string $invoiceMemo
     * @param string $invoiceShipDate
     * @param string $invoiceShipVia
     * @param string $invoiceTermsId
     * @param string $invoiceSalesRepId
     * @param string $invoiceLastSyncDateTime
     * @param string $deliveryNumber
     * @param string $locationId
     * @param \eBizCharge\StructType\Address $remitToAddress
     * @param string $poDate
     * @param string $orderedBy
     * @param string $invoiceClass
     * @param string $invoiceFOB
     * @param string $invoiceTermsDescription
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $invoiceCustomFields
     */
    public function __construct($invoiceAmount = null, $amountDue = null, $notifyCustomer = null, $totalTaxAmount = null, $invoiceIsToBeEmailed = null, $invoiceIsToBePrinted = null, $totalDiscountAmount = null, $totalShippingAmount = null, $merchantId = null, $customerId = null, $subCustomerId = null, $invoiceNumber = null, $invoiceInternalId = null, $invoiceDate = null, $currency = null, $invoiceDueDate = null, $poNum = null, $soNum = null, $divisionId = null, $typeId = null, $uploadedBy = null, $updatedBy = null, $dateUploaded = null, $dateUpdated = null, $isDeleted = null, $deletedBy = null, $dateDeleted = null, \eBizCharge\ArrayType\ArrayOfItem $items = null, $software = null, $emailTemplateID = null, $invoiceURL = null, $invoiceUniqueId = null, $invoiceDescription = null, \eBizCharge\StructType\Address $billingAddress = null, \eBizCharge\StructType\Address $shippingAddress = null, $invoiceCustomerMessage = null, $invoiceMemo = null, $invoiceShipDate = null, $invoiceShipVia = null, $invoiceTermsId = null, $invoiceSalesRepId = null, $invoiceLastSyncDateTime = null, $deliveryNumber = null, $locationId = null, \eBizCharge\StructType\Address $remitToAddress = null, $poDate = null, $orderedBy = null, $invoiceClass = null, $invoiceFOB = null, $invoiceTermsDescription = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $invoiceCustomFields = null)
    {
        $this
            ->setInvoiceAmount($invoiceAmount)
            ->setAmountDue($amountDue)
            ->setNotifyCustomer($notifyCustomer)
            ->setTotalTaxAmount($totalTaxAmount)
            ->setInvoiceIsToBeEmailed($invoiceIsToBeEmailed)
            ->setInvoiceIsToBePrinted($invoiceIsToBePrinted)
            ->setTotalDiscountAmount($totalDiscountAmount)
            ->setTotalShippingAmount($totalShippingAmount)
            ->setMerchantId($merchantId)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setInvoiceDate($invoiceDate)
            ->setCurrency($currency)
            ->setInvoiceDueDate($invoiceDueDate)
            ->setPoNum($poNum)
            ->setSoNum($soNum)
            ->setDivisionId($divisionId)
            ->setTypeId($typeId)
            ->setUploadedBy($uploadedBy)
            ->setUpdatedBy($updatedBy)
            ->setDateUploaded($dateUploaded)
            ->setDateUpdated($dateUpdated)
            ->setIsDeleted($isDeleted)
            ->setDeletedBy($deletedBy)
            ->setDateDeleted($dateDeleted)
            ->setItems($items)
            ->setSoftware($software)
            ->setEmailTemplateID($emailTemplateID)
            ->setInvoiceURL($invoiceURL)
            ->setInvoiceUniqueId($invoiceUniqueId)
            ->setInvoiceDescription($invoiceDescription)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress)
            ->setInvoiceCustomerMessage($invoiceCustomerMessage)
            ->setInvoiceMemo($invoiceMemo)
            ->setInvoiceShipDate($invoiceShipDate)
            ->setInvoiceShipVia($invoiceShipVia)
            ->setInvoiceTermsId($invoiceTermsId)
            ->setInvoiceSalesRepId($invoiceSalesRepId)
            ->setInvoiceLastSyncDateTime($invoiceLastSyncDateTime)
            ->setDeliveryNumber($deliveryNumber)
            ->setLocationId($locationId)
            ->setRemitToAddress($remitToAddress)
            ->setPoDate($poDate)
            ->setOrderedBy($orderedBy)
            ->setInvoiceClass($invoiceClass)
            ->setInvoiceFOB($invoiceFOB)
            ->setInvoiceTermsDescription($invoiceTermsDescription)
            ->setInvoiceCustomFields($invoiceCustomFields);
    }
    /**
     * Get InvoiceAmount value
     * @return float
     */
    public function getInvoiceAmount()
    {
        return $this->InvoiceAmount;
    }
    /**
     * Set InvoiceAmount value
     * @param float $invoiceAmount
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceAmount($invoiceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceAmount) && !(is_float($invoiceAmount) || is_numeric($invoiceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceAmount, true), gettype($invoiceAmount)), __LINE__);
        }
        $this->InvoiceAmount = $invoiceAmount;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \eBizCharge\StructType\Invoice
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get NotifyCustomer value
     * @return bool
     */
    public function getNotifyCustomer()
    {
        return $this->NotifyCustomer;
    }
    /**
     * Set NotifyCustomer value
     * @param bool $notifyCustomer
     * @return \eBizCharge\StructType\Invoice
     */
    public function setNotifyCustomer($notifyCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyCustomer) && !is_bool($notifyCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notifyCustomer, true), gettype($notifyCustomer)), __LINE__);
        }
        $this->NotifyCustomer = $notifyCustomer;
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * @return float
     */
    public function getTotalTaxAmount()
    {
        return $this->TotalTaxAmount;
    }
    /**
     * Set TotalTaxAmount value
     * @param float $totalTaxAmount
     * @return \eBizCharge\StructType\Invoice
     */
    public function setTotalTaxAmount($totalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxAmount) && !(is_float($totalTaxAmount) || is_numeric($totalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxAmount, true), gettype($totalTaxAmount)), __LINE__);
        }
        $this->TotalTaxAmount = $totalTaxAmount;
        return $this;
    }
    /**
     * Get InvoiceIsToBeEmailed value
     * @return bool
     */
    public function getInvoiceIsToBeEmailed()
    {
        return $this->InvoiceIsToBeEmailed;
    }
    /**
     * Set InvoiceIsToBeEmailed value
     * @param bool $invoiceIsToBeEmailed
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceIsToBeEmailed($invoiceIsToBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoiceIsToBeEmailed) && !is_bool($invoiceIsToBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoiceIsToBeEmailed, true), gettype($invoiceIsToBeEmailed)), __LINE__);
        }
        $this->InvoiceIsToBeEmailed = $invoiceIsToBeEmailed;
        return $this;
    }
    /**
     * Get InvoiceIsToBePrinted value
     * @return bool
     */
    public function getInvoiceIsToBePrinted()
    {
        return $this->InvoiceIsToBePrinted;
    }
    /**
     * Set InvoiceIsToBePrinted value
     * @param bool $invoiceIsToBePrinted
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceIsToBePrinted($invoiceIsToBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoiceIsToBePrinted) && !is_bool($invoiceIsToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoiceIsToBePrinted, true), gettype($invoiceIsToBePrinted)), __LINE__);
        }
        $this->InvoiceIsToBePrinted = $invoiceIsToBePrinted;
        return $this;
    }
    /**
     * Get TotalDiscountAmount value
     * @return float
     */
    public function getTotalDiscountAmount()
    {
        return $this->TotalDiscountAmount;
    }
    /**
     * Set TotalDiscountAmount value
     * @param float $totalDiscountAmount
     * @return \eBizCharge\StructType\Invoice
     */
    public function setTotalDiscountAmount($totalDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalDiscountAmount) && !(is_float($totalDiscountAmount) || is_numeric($totalDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDiscountAmount, true), gettype($totalDiscountAmount)), __LINE__);
        }
        $this->TotalDiscountAmount = $totalDiscountAmount;
        return $this;
    }
    /**
     * Get TotalShippingAmount value
     * @return float
     */
    public function getTotalShippingAmount()
    {
        return $this->TotalShippingAmount;
    }
    /**
     * Set TotalShippingAmount value
     * @param float $totalShippingAmount
     * @return \eBizCharge\StructType\Invoice
     */
    public function setTotalShippingAmount($totalShippingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalShippingAmount) && !(is_float($totalShippingAmount) || is_numeric($totalShippingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalShippingAmount, true), gettype($totalShippingAmount)), __LINE__);
        }
        $this->TotalShippingAmount = $totalShippingAmount;
        return $this;
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SubCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->SubCustomerId;
    }
    /**
     * Set SubCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->SubCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->InvoiceInternalId;
    }
    /**
     * Set InvoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->InvoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\Invoice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get InvoiceDueDate value
     * @return string|null
     */
    public function getInvoiceDueDate()
    {
        return $this->InvoiceDueDate;
    }
    /**
     * Set InvoiceDueDate value
     * @param string $invoiceDueDate
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceDueDate($invoiceDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDueDate) && !is_string($invoiceDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDueDate, true), gettype($invoiceDueDate)), __LINE__);
        }
        $this->InvoiceDueDate = $invoiceDueDate;
        return $this;
    }
    /**
     * Get PoNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->PoNum;
    }
    /**
     * Set PoNum value
     * @param string $poNum
     * @return \eBizCharge\StructType\Invoice
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->PoNum = $poNum;
        return $this;
    }
    /**
     * Get SoNum value
     * @return string|null
     */
    public function getSoNum()
    {
        return $this->SoNum;
    }
    /**
     * Set SoNum value
     * @param string $soNum
     * @return \eBizCharge\StructType\Invoice
     */
    public function setSoNum($soNum = null)
    {
        // validation for constraint: string
        if (!is_null($soNum) && !is_string($soNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soNum, true), gettype($soNum)), __LINE__);
        }
        $this->SoNum = $soNum;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
    /**
     * Get UploadedBy value
     * @return string|null
     */
    public function getUploadedBy()
    {
        return $this->UploadedBy;
    }
    /**
     * Set UploadedBy value
     * @param string $uploadedBy
     * @return \eBizCharge\StructType\Invoice
     */
    public function setUploadedBy($uploadedBy = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedBy) && !is_string($uploadedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedBy, true), gettype($uploadedBy)), __LINE__);
        }
        $this->UploadedBy = $uploadedBy;
        return $this;
    }
    /**
     * Get UpdatedBy value
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return $this->UpdatedBy;
    }
    /**
     * Set UpdatedBy value
     * @param string $updatedBy
     * @return \eBizCharge\StructType\Invoice
     */
    public function setUpdatedBy($updatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($updatedBy) && !is_string($updatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedBy, true), gettype($updatedBy)), __LINE__);
        }
        $this->UpdatedBy = $updatedBy;
        return $this;
    }
    /**
     * Get DateUploaded value
     * @return string|null
     */
    public function getDateUploaded()
    {
        return $this->DateUploaded;
    }
    /**
     * Set DateUploaded value
     * @param string $dateUploaded
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDateUploaded($dateUploaded = null)
    {
        // validation for constraint: string
        if (!is_null($dateUploaded) && !is_string($dateUploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUploaded, true), gettype($dateUploaded)), __LINE__);
        }
        $this->DateUploaded = $dateUploaded;
        return $this;
    }
    /**
     * Get DateUpdated value
     * @return string|null
     */
    public function getDateUpdated()
    {
        return $this->DateUpdated;
    }
    /**
     * Set DateUpdated value
     * @param string $dateUpdated
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDateUpdated($dateUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($dateUpdated) && !is_string($dateUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUpdated, true), gettype($dateUpdated)), __LINE__);
        }
        $this->DateUpdated = $dateUpdated;
        return $this;
    }
    /**
     * Get isDeleted value
     * @return string|null
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }
    /**
     * Set isDeleted value
     * @param string $isDeleted
     * @return \eBizCharge\StructType\Invoice
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($isDeleted) && !is_string($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->isDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get DeletedBy value
     * @return string|null
     */
    public function getDeletedBy()
    {
        return $this->DeletedBy;
    }
    /**
     * Set DeletedBy value
     * @param string $deletedBy
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDeletedBy($deletedBy = null)
    {
        // validation for constraint: string
        if (!is_null($deletedBy) && !is_string($deletedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletedBy, true), gettype($deletedBy)), __LINE__);
        }
        $this->DeletedBy = $deletedBy;
        return $this;
    }
    /**
     * Get DateDeleted value
     * @return string|null
     */
    public function getDateDeleted()
    {
        return $this->DateDeleted;
    }
    /**
     * Set DateDeleted value
     * @param string $dateDeleted
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDateDeleted($dateDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($dateDeleted) && !is_string($dateDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDeleted, true), gettype($dateDeleted)), __LINE__);
        }
        $this->DateDeleted = $dateDeleted;
        return $this;
    }
    /**
     * Get Items value
     * @return \eBizCharge\ArrayType\ArrayOfItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \eBizCharge\ArrayType\ArrayOfItem $items
     * @return \eBizCharge\StructType\Invoice
     */
    public function setItems(\eBizCharge\ArrayType\ArrayOfItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\Invoice
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
    /**
     * Get EmailTemplateID value
     * @return string|null
     */
    public function getEmailTemplateID()
    {
        return $this->EmailTemplateID;
    }
    /**
     * Set EmailTemplateID value
     * @param string $emailTemplateID
     * @return \eBizCharge\StructType\Invoice
     */
    public function setEmailTemplateID($emailTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateID) && !is_string($emailTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateID, true), gettype($emailTemplateID)), __LINE__);
        }
        $this->EmailTemplateID = $emailTemplateID;
        return $this;
    }
    /**
     * Get InvoiceURL value
     * @return string|null
     */
    public function getInvoiceURL()
    {
        return $this->InvoiceURL;
    }
    /**
     * Set InvoiceURL value
     * @param string $invoiceURL
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceURL($invoiceURL = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceURL) && !is_string($invoiceURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceURL, true), gettype($invoiceURL)), __LINE__);
        }
        $this->InvoiceURL = $invoiceURL;
        return $this;
    }
    /**
     * Get InvoiceUniqueId value
     * @return string|null
     */
    public function getInvoiceUniqueId()
    {
        return $this->InvoiceUniqueId;
    }
    /**
     * Set InvoiceUniqueId value
     * @param string $invoiceUniqueId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceUniqueId($invoiceUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceUniqueId) && !is_string($invoiceUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceUniqueId, true), gettype($invoiceUniqueId)), __LINE__);
        }
        $this->InvoiceUniqueId = $invoiceUniqueId;
        return $this;
    }
    /**
     * Get InvoiceDescription value
     * @return string|null
     */
    public function getInvoiceDescription()
    {
        return $this->InvoiceDescription;
    }
    /**
     * Set InvoiceDescription value
     * @param string $invoiceDescription
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceDescription($invoiceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDescription) && !is_string($invoiceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDescription, true), gettype($invoiceDescription)), __LINE__);
        }
        $this->InvoiceDescription = $invoiceDescription;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\Address $billingAddress
     * @return \eBizCharge\StructType\Invoice
     */
    public function setBillingAddress(\eBizCharge\StructType\Address $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @return \eBizCharge\StructType\Invoice
     */
    public function setShippingAddress(\eBizCharge\StructType\Address $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get InvoiceCustomerMessage value
     * @return string|null
     */
    public function getInvoiceCustomerMessage()
    {
        return $this->InvoiceCustomerMessage;
    }
    /**
     * Set InvoiceCustomerMessage value
     * @param string $invoiceCustomerMessage
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceCustomerMessage($invoiceCustomerMessage = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCustomerMessage) && !is_string($invoiceCustomerMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCustomerMessage, true), gettype($invoiceCustomerMessage)), __LINE__);
        }
        $this->InvoiceCustomerMessage = $invoiceCustomerMessage;
        return $this;
    }
    /**
     * Get InvoiceMemo value
     * @return string|null
     */
    public function getInvoiceMemo()
    {
        return $this->InvoiceMemo;
    }
    /**
     * Set InvoiceMemo value
     * @param string $invoiceMemo
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceMemo($invoiceMemo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceMemo) && !is_string($invoiceMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceMemo, true), gettype($invoiceMemo)), __LINE__);
        }
        $this->InvoiceMemo = $invoiceMemo;
        return $this;
    }
    /**
     * Get InvoiceShipDate value
     * @return string|null
     */
    public function getInvoiceShipDate()
    {
        return $this->InvoiceShipDate;
    }
    /**
     * Set InvoiceShipDate value
     * @param string $invoiceShipDate
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceShipDate($invoiceShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceShipDate) && !is_string($invoiceShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceShipDate, true), gettype($invoiceShipDate)), __LINE__);
        }
        $this->InvoiceShipDate = $invoiceShipDate;
        return $this;
    }
    /**
     * Get InvoiceShipVia value
     * @return string|null
     */
    public function getInvoiceShipVia()
    {
        return $this->InvoiceShipVia;
    }
    /**
     * Set InvoiceShipVia value
     * @param string $invoiceShipVia
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceShipVia($invoiceShipVia = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceShipVia) && !is_string($invoiceShipVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceShipVia, true), gettype($invoiceShipVia)), __LINE__);
        }
        $this->InvoiceShipVia = $invoiceShipVia;
        return $this;
    }
    /**
     * Get InvoiceTermsId value
     * @return string|null
     */
    public function getInvoiceTermsId()
    {
        return $this->InvoiceTermsId;
    }
    /**
     * Set InvoiceTermsId value
     * @param string $invoiceTermsId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceTermsId($invoiceTermsId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTermsId) && !is_string($invoiceTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTermsId, true), gettype($invoiceTermsId)), __LINE__);
        }
        $this->InvoiceTermsId = $invoiceTermsId;
        return $this;
    }
    /**
     * Get InvoiceSalesRepId value
     * @return string|null
     */
    public function getInvoiceSalesRepId()
    {
        return $this->InvoiceSalesRepId;
    }
    /**
     * Set InvoiceSalesRepId value
     * @param string $invoiceSalesRepId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceSalesRepId($invoiceSalesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceSalesRepId) && !is_string($invoiceSalesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceSalesRepId, true), gettype($invoiceSalesRepId)), __LINE__);
        }
        $this->InvoiceSalesRepId = $invoiceSalesRepId;
        return $this;
    }
    /**
     * Get InvoiceLastSyncDateTime value
     * @return string|null
     */
    public function getInvoiceLastSyncDateTime()
    {
        return $this->InvoiceLastSyncDateTime;
    }
    /**
     * Set InvoiceLastSyncDateTime value
     * @param string $invoiceLastSyncDateTime
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceLastSyncDateTime($invoiceLastSyncDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceLastSyncDateTime) && !is_string($invoiceLastSyncDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceLastSyncDateTime, true), gettype($invoiceLastSyncDateTime)), __LINE__);
        }
        $this->InvoiceLastSyncDateTime = $invoiceLastSyncDateTime;
        return $this;
    }
    /**
     * Get DeliveryNumber value
     * @return string|null
     */
    public function getDeliveryNumber()
    {
        return $this->DeliveryNumber;
    }
    /**
     * Set DeliveryNumber value
     * @param string $deliveryNumber
     * @return \eBizCharge\StructType\Invoice
     */
    public function setDeliveryNumber($deliveryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNumber) && !is_string($deliveryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNumber, true), gettype($deliveryNumber)), __LINE__);
        }
        $this->DeliveryNumber = $deliveryNumber;
        return $this;
    }
    /**
     * Get LocationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param string $locationId
     * @return \eBizCharge\StructType\Invoice
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Get RemitToAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getRemitToAddress()
    {
        return $this->RemitToAddress;
    }
    /**
     * Set RemitToAddress value
     * @param \eBizCharge\StructType\Address $remitToAddress
     * @return \eBizCharge\StructType\Invoice
     */
    public function setRemitToAddress(\eBizCharge\StructType\Address $remitToAddress = null)
    {
        $this->RemitToAddress = $remitToAddress;
        return $this;
    }
    /**
     * Get PoDate value
     * @return string|null
     */
    public function getPoDate()
    {
        return $this->PoDate;
    }
    /**
     * Set PoDate value
     * @param string $poDate
     * @return \eBizCharge\StructType\Invoice
     */
    public function setPoDate($poDate = null)
    {
        // validation for constraint: string
        if (!is_null($poDate) && !is_string($poDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poDate, true), gettype($poDate)), __LINE__);
        }
        $this->PoDate = $poDate;
        return $this;
    }
    /**
     * Get OrderedBy value
     * @return string|null
     */
    public function getOrderedBy()
    {
        return $this->OrderedBy;
    }
    /**
     * Set OrderedBy value
     * @param string $orderedBy
     * @return \eBizCharge\StructType\Invoice
     */
    public function setOrderedBy($orderedBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderedBy) && !is_string($orderedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderedBy, true), gettype($orderedBy)), __LINE__);
        }
        $this->OrderedBy = $orderedBy;
        return $this;
    }
    /**
     * Get InvoiceClass value
     * @return string|null
     */
    public function getInvoiceClass()
    {
        return $this->InvoiceClass;
    }
    /**
     * Set InvoiceClass value
     * @param string $invoiceClass
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceClass($invoiceClass = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceClass) && !is_string($invoiceClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceClass, true), gettype($invoiceClass)), __LINE__);
        }
        $this->InvoiceClass = $invoiceClass;
        return $this;
    }
    /**
     * Get InvoiceFOB value
     * @return string|null
     */
    public function getInvoiceFOB()
    {
        return $this->InvoiceFOB;
    }
    /**
     * Set InvoiceFOB value
     * @param string $invoiceFOB
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceFOB($invoiceFOB = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceFOB) && !is_string($invoiceFOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceFOB, true), gettype($invoiceFOB)), __LINE__);
        }
        $this->InvoiceFOB = $invoiceFOB;
        return $this;
    }
    /**
     * Get InvoiceTermsDescription value
     * @return string|null
     */
    public function getInvoiceTermsDescription()
    {
        return $this->InvoiceTermsDescription;
    }
    /**
     * Set InvoiceTermsDescription value
     * @param string $invoiceTermsDescription
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceTermsDescription($invoiceTermsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTermsDescription) && !is_string($invoiceTermsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTermsDescription, true), gettype($invoiceTermsDescription)), __LINE__);
        }
        $this->InvoiceTermsDescription = $invoiceTermsDescription;
        return $this;
    }
    /**
     * Get InvoiceCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getInvoiceCustomFields()
    {
        return $this->InvoiceCustomFields;
    }
    /**
     * Set InvoiceCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $invoiceCustomFields
     * @return \eBizCharge\StructType\Invoice
     */
    public function setInvoiceCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $invoiceCustomFields = null)
    {
        $this->InvoiceCustomFields = $invoiceCustomFields;
        return $this;
    }
}
