<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckData StructType
 * @subpackage Structs
 */
class CheckData extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The DriversLicense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicense;
    /**
     * The DriversLicenseState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicenseState;
    /**
     * The RecordType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecordType;
    /**
     * The Routing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Routing;
    /**
     * The MICR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MICR;
    /**
     * The AuxOnUS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuxOnUS;
    /**
     * The EpcCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EpcCode;
    /**
     * The FrontImage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrontImage;
    /**
     * The BackImage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BackImage;
    /**
     * Constructor method for CheckData
     * @uses CheckData::setAccount()
     * @uses CheckData::setAccountType()
     * @uses CheckData::setCheckNumber()
     * @uses CheckData::setDriversLicense()
     * @uses CheckData::setDriversLicenseState()
     * @uses CheckData::setRecordType()
     * @uses CheckData::setRouting()
     * @uses CheckData::setMICR()
     * @uses CheckData::setAuxOnUS()
     * @uses CheckData::setEpcCode()
     * @uses CheckData::setFrontImage()
     * @uses CheckData::setBackImage()
     * @param string $account
     * @param string $accountType
     * @param string $checkNumber
     * @param string $driversLicense
     * @param string $driversLicenseState
     * @param string $recordType
     * @param string $routing
     * @param string $mICR
     * @param string $auxOnUS
     * @param string $epcCode
     * @param string $frontImage
     * @param string $backImage
     */
    public function __construct($account = null, $accountType = null, $checkNumber = null, $driversLicense = null, $driversLicenseState = null, $recordType = null, $routing = null, $mICR = null, $auxOnUS = null, $epcCode = null, $frontImage = null, $backImage = null)
    {
        $this
            ->setAccount($account)
            ->setAccountType($accountType)
            ->setCheckNumber($checkNumber)
            ->setDriversLicense($driversLicense)
            ->setDriversLicenseState($driversLicenseState)
            ->setRecordType($recordType)
            ->setRouting($routing)
            ->setMICR($mICR)
            ->setAuxOnUS($auxOnUS)
            ->setEpcCode($epcCode)
            ->setFrontImage($frontImage)
            ->setBackImage($backImage);
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \eBizCharge\StructType\CheckData
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \eBizCharge\StructType\CheckData
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \eBizCharge\StructType\CheckData
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get DriversLicense value
     * @return string|null
     */
    public function getDriversLicense()
    {
        return $this->DriversLicense;
    }
    /**
     * Set DriversLicense value
     * @param string $driversLicense
     * @return \eBizCharge\StructType\CheckData
     */
    public function setDriversLicense($driversLicense = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicense) && !is_string($driversLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driversLicense, true), gettype($driversLicense)), __LINE__);
        }
        $this->DriversLicense = $driversLicense;
        return $this;
    }
    /**
     * Get DriversLicenseState value
     * @return string|null
     */
    public function getDriversLicenseState()
    {
        return $this->DriversLicenseState;
    }
    /**
     * Set DriversLicenseState value
     * @param string $driversLicenseState
     * @return \eBizCharge\StructType\CheckData
     */
    public function setDriversLicenseState($driversLicenseState = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicenseState) && !is_string($driversLicenseState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driversLicenseState, true), gettype($driversLicenseState)), __LINE__);
        }
        $this->DriversLicenseState = $driversLicenseState;
        return $this;
    }
    /**
     * Get RecordType value
     * @return string|null
     */
    public function getRecordType()
    {
        return $this->RecordType;
    }
    /**
     * Set RecordType value
     * @param string $recordType
     * @return \eBizCharge\StructType\CheckData
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: string
        if (!is_null($recordType) && !is_string($recordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordType, true), gettype($recordType)), __LINE__);
        }
        $this->RecordType = $recordType;
        return $this;
    }
    /**
     * Get Routing value
     * @return string|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param string $routing
     * @return \eBizCharge\StructType\CheckData
     */
    public function setRouting($routing = null)
    {
        // validation for constraint: string
        if (!is_null($routing) && !is_string($routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routing, true), gettype($routing)), __LINE__);
        }
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Get MICR value
     * @return string|null
     */
    public function getMICR()
    {
        return $this->MICR;
    }
    /**
     * Set MICR value
     * @param string $mICR
     * @return \eBizCharge\StructType\CheckData
     */
    public function setMICR($mICR = null)
    {
        // validation for constraint: string
        if (!is_null($mICR) && !is_string($mICR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mICR, true), gettype($mICR)), __LINE__);
        }
        $this->MICR = $mICR;
        return $this;
    }
    /**
     * Get AuxOnUS value
     * @return string|null
     */
    public function getAuxOnUS()
    {
        return $this->AuxOnUS;
    }
    /**
     * Set AuxOnUS value
     * @param string $auxOnUS
     * @return \eBizCharge\StructType\CheckData
     */
    public function setAuxOnUS($auxOnUS = null)
    {
        // validation for constraint: string
        if (!is_null($auxOnUS) && !is_string($auxOnUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auxOnUS, true), gettype($auxOnUS)), __LINE__);
        }
        $this->AuxOnUS = $auxOnUS;
        return $this;
    }
    /**
     * Get EpcCode value
     * @return string|null
     */
    public function getEpcCode()
    {
        return $this->EpcCode;
    }
    /**
     * Set EpcCode value
     * @param string $epcCode
     * @return \eBizCharge\StructType\CheckData
     */
    public function setEpcCode($epcCode = null)
    {
        // validation for constraint: string
        if (!is_null($epcCode) && !is_string($epcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($epcCode, true), gettype($epcCode)), __LINE__);
        }
        $this->EpcCode = $epcCode;
        return $this;
    }
    /**
     * Get FrontImage value
     * @return string|null
     */
    public function getFrontImage()
    {
        return $this->FrontImage;
    }
    /**
     * Set FrontImage value
     * @param string $frontImage
     * @return \eBizCharge\StructType\CheckData
     */
    public function setFrontImage($frontImage = null)
    {
        // validation for constraint: string
        if (!is_null($frontImage) && !is_string($frontImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontImage, true), gettype($frontImage)), __LINE__);
        }
        $this->FrontImage = $frontImage;
        return $this;
    }
    /**
     * Get BackImage value
     * @return string|null
     */
    public function getBackImage()
    {
        return $this->BackImage;
    }
    /**
     * Set BackImage value
     * @param string $backImage
     * @return \eBizCharge\StructType\CheckData
     */
    public function setBackImage($backImage = null)
    {
        // validation for constraint: string
        if (!is_null($backImage) && !is_string($backImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backImage, true), gettype($backImage)), __LINE__);
        }
        $this->BackImage = $backImage;
        return $this;
    }
}
