<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBatchStatus ArrayType
 * @subpackage Arrays
 */
class ArrayOfBatchStatus extends AbstractStructArrayBase
{
    /**
     * The BatchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\BatchStatus[]
     */
    public $BatchStatus;
    /**
     * Constructor method for ArrayOfBatchStatus
     * @uses ArrayOfBatchStatus::setBatchStatus()
     * @param \eBizCharge\StructType\BatchStatus[] $batchStatus
     */
    public function __construct(array $batchStatus = array())
    {
        $this
            ->setBatchStatus($batchStatus);
    }
    /**
     * Get BatchStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\BatchStatus[]|null
     */
    public function getBatchStatus()
    {
        return isset($this->BatchStatus) ? $this->BatchStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBatchStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBatchStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBatchStatusForArrayConstraintsFromSetBatchStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBatchStatusBatchStatusItem) {
            // validation for constraint: itemType
            if (!$arrayOfBatchStatusBatchStatusItem instanceof \eBizCharge\StructType\BatchStatus) {
                $invalidValues[] = is_object($arrayOfBatchStatusBatchStatusItem) ? get_class($arrayOfBatchStatusBatchStatusItem) : sprintf('%s(%s)', gettype($arrayOfBatchStatusBatchStatusItem), var_export($arrayOfBatchStatusBatchStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BatchStatus property can only contain items of type \eBizCharge\StructType\BatchStatus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BatchStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\BatchStatus[] $batchStatus
     * @return \eBizCharge\ArrayType\ArrayOfBatchStatus
     */
    public function setBatchStatus(array $batchStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($batchStatusArrayErrorMessage = self::validateBatchStatusForArrayConstraintsFromSetBatchStatus($batchStatus))) {
            throw new \InvalidArgumentException($batchStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($batchStatus) || (is_array($batchStatus) && empty($batchStatus))) {
            unset($this->BatchStatus);
        } else {
            $this->BatchStatus = $batchStatus;
        }
        return $this;
    }
    /**
     * Add item to BatchStatus value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\BatchStatus $item
     * @return \eBizCharge\ArrayType\ArrayOfBatchStatus
     */
    public function addToBatchStatus(\eBizCharge\StructType\BatchStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\BatchStatus) {
            throw new \InvalidArgumentException(sprintf('The BatchStatus property can only contain items of type \eBizCharge\StructType\BatchStatus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BatchStatus[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\BatchStatus|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\BatchStatus|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\BatchStatus|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\BatchStatus|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\BatchStatus|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BatchStatus
     */
    public function getAttributeName()
    {
        return 'BatchStatus';
    }
}
