<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicePaymentRequest StructType
 * @subpackage Structs
 */
class InvoicePaymentRequest extends AbstractStructBase
{
    /**
     * The TotalPaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPaidAmount;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The InvoicePaymentDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails
     */
    public $InvoicePaymentDetails;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The CustNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustNum;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * Constructor method for InvoicePaymentRequest
     * @uses InvoicePaymentRequest::setTotalPaidAmount()
     * @uses InvoicePaymentRequest::setCustomerId()
     * @uses InvoicePaymentRequest::setInvoicePaymentDetails()
     * @uses InvoicePaymentRequest::setAuthCode()
     * @uses InvoicePaymentRequest::setRefNum()
     * @uses InvoicePaymentRequest::setCurrency()
     * @uses InvoicePaymentRequest::setCustNum()
     * @uses InvoicePaymentRequest::setPaymentMethodId()
     * @uses InvoicePaymentRequest::setPaymentMethodType()
     * @uses InvoicePaymentRequest::setSoftware()
     * @param float $totalPaidAmount
     * @param string $customerId
     * @param \eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails $invoicePaymentDetails
     * @param string $authCode
     * @param string $refNum
     * @param string $currency
     * @param string $custNum
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $software
     */
    public function __construct($totalPaidAmount = null, $customerId = null, \eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails $invoicePaymentDetails = null, $authCode = null, $refNum = null, $currency = null, $custNum = null, $paymentMethodId = null, $paymentMethodType = null, $software = null)
    {
        $this
            ->setTotalPaidAmount($totalPaidAmount)
            ->setCustomerId($customerId)
            ->setInvoicePaymentDetails($invoicePaymentDetails)
            ->setAuthCode($authCode)
            ->setRefNum($refNum)
            ->setCurrency($currency)
            ->setCustNum($custNum)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setSoftware($software);
    }
    /**
     * Get TotalPaidAmount value
     * @return float
     */
    public function getTotalPaidAmount()
    {
        return $this->TotalPaidAmount;
    }
    /**
     * Set TotalPaidAmount value
     * @param float $totalPaidAmount
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setTotalPaidAmount($totalPaidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalPaidAmount) && !(is_float($totalPaidAmount) || is_numeric($totalPaidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPaidAmount, true), gettype($totalPaidAmount)), __LINE__);
        }
        $this->TotalPaidAmount = $totalPaidAmount;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InvoicePaymentDetails value
     * @return \eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails|null
     */
    public function getInvoicePaymentDetails()
    {
        return $this->InvoicePaymentDetails;
    }
    /**
     * Set InvoicePaymentDetails value
     * @param \eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails $invoicePaymentDetails
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setInvoicePaymentDetails(\eBizCharge\ArrayType\ArrayOfInvoicePaymentDetails $invoicePaymentDetails = null)
    {
        $this->InvoicePaymentDetails = $invoicePaymentDetails;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CustNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->CustNum;
    }
    /**
     * Set CustNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->CustNum = $custNum;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @param string $paymentMethodType
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\InvoicePaymentRequest
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
}
