<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateItem StructType
 * @subpackage Structs
 */
class UpdateItem extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The itemDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\ItemDetails
     */
    public $itemDetails;
    /**
     * The itemInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemInternalId;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * Constructor method for UpdateItem
     * @uses UpdateItem::setSecurityToken()
     * @uses UpdateItem::setItemDetails()
     * @uses UpdateItem::setItemInternalId()
     * @uses UpdateItem::setItemId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param \eBizCharge\StructType\ItemDetails $itemDetails
     * @param string $itemInternalId
     * @param string $itemId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, \eBizCharge\StructType\ItemDetails $itemDetails = null, $itemInternalId = null, $itemId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setItemDetails($itemDetails)
            ->setItemInternalId($itemInternalId)
            ->setItemId($itemId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateItem
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get itemDetails value
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function getItemDetails()
    {
        return $this->itemDetails;
    }
    /**
     * Set itemDetails value
     * @param \eBizCharge\StructType\ItemDetails $itemDetails
     * @return \eBizCharge\StructType\UpdateItem
     */
    public function setItemDetails(\eBizCharge\StructType\ItemDetails $itemDetails = null)
    {
        $this->itemDetails = $itemDetails;
        return $this;
    }
    /**
     * Get itemInternalId value
     * @return string|null
     */
    public function getItemInternalId()
    {
        return $this->itemInternalId;
    }
    /**
     * Set itemInternalId value
     * @param string $itemInternalId
     * @return \eBizCharge\StructType\UpdateItem
     */
    public function setItemInternalId($itemInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemInternalId) && !is_string($itemInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemInternalId, true), gettype($itemInternalId)), __LINE__);
        }
        $this->itemInternalId = $itemInternalId;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \eBizCharge\StructType\UpdateItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
}
