<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadAttachment StructType
 * @subpackage Structs
 */
class UploadAttachment extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The parentDocumentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parentDocumentInternalId;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Atachment
     */
    public $attachment;
    /**
     * The parentDocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parentDocumentType;
    /**
     * Constructor method for UploadAttachment
     * @uses UploadAttachment::setSecurityToken()
     * @uses UploadAttachment::setParentDocumentInternalId()
     * @uses UploadAttachment::setAttachment()
     * @uses UploadAttachment::setParentDocumentType()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $parentDocumentInternalId
     * @param \eBizCharge\StructType\Atachment $attachment
     * @param string $parentDocumentType
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $parentDocumentInternalId = null, \eBizCharge\StructType\Atachment $attachment = null, $parentDocumentType = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setParentDocumentInternalId($parentDocumentInternalId)
            ->setAttachment($attachment)
            ->setParentDocumentType($parentDocumentType);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UploadAttachment
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get parentDocumentInternalId value
     * @return string|null
     */
    public function getParentDocumentInternalId()
    {
        return $this->parentDocumentInternalId;
    }
    /**
     * Set parentDocumentInternalId value
     * @param string $parentDocumentInternalId
     * @return \eBizCharge\StructType\UploadAttachment
     */
    public function setParentDocumentInternalId($parentDocumentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($parentDocumentInternalId) && !is_string($parentDocumentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentDocumentInternalId, true), gettype($parentDocumentInternalId)), __LINE__);
        }
        $this->parentDocumentInternalId = $parentDocumentInternalId;
        return $this;
    }
    /**
     * Get attachment value
     * @return \eBizCharge\StructType\Atachment|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param \eBizCharge\StructType\Atachment $attachment
     * @return \eBizCharge\StructType\UploadAttachment
     */
    public function setAttachment(\eBizCharge\StructType\Atachment $attachment = null)
    {
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Get parentDocumentType value
     * @return string|null
     */
    public function getParentDocumentType()
    {
        return $this->parentDocumentType;
    }
    /**
     * Set parentDocumentType value
     * @param string $parentDocumentType
     * @return \eBizCharge\StructType\UploadAttachment
     */
    public function setParentDocumentType($parentDocumentType = null)
    {
        // validation for constraint: string
        if (!is_null($parentDocumentType) && !is_string($parentDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentDocumentType, true), gettype($parentDocumentType)), __LINE__);
        }
        $this->parentDocumentType = $parentDocumentType;
        return $this;
    }
}
