<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerPaymentMethodProfile StructType
 * @subpackage Structs
 */
class UpdateCustomerPaymentMethodProfile extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerToken;
    /**
     * The paymentMethodProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\PaymentMethodProfile
     */
    public $paymentMethodProfile;
    /**
     * Constructor method for UpdateCustomerPaymentMethodProfile
     * @uses UpdateCustomerPaymentMethodProfile::setSecurityToken()
     * @uses UpdateCustomerPaymentMethodProfile::setCustomerToken()
     * @uses UpdateCustomerPaymentMethodProfile::setPaymentMethodProfile()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerToken
     * @param \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerToken = null, \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerToken($customerToken)
            ->setPaymentMethodProfile($paymentMethodProfile);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateCustomerPaymentMethodProfile
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerToken value
     * @return string|null
     */
    public function getCustomerToken()
    {
        return $this->customerToken;
    }
    /**
     * Set customerToken value
     * @param string $customerToken
     * @return \eBizCharge\StructType\UpdateCustomerPaymentMethodProfile
     */
    public function setCustomerToken($customerToken = null)
    {
        // validation for constraint: string
        if (!is_null($customerToken) && !is_string($customerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerToken, true), gettype($customerToken)), __LINE__);
        }
        $this->customerToken = $customerToken;
        return $this;
    }
    /**
     * Get paymentMethodProfile value
     * @return \eBizCharge\StructType\PaymentMethodProfile|null
     */
    public function getPaymentMethodProfile()
    {
        return $this->paymentMethodProfile;
    }
    /**
     * Set paymentMethodProfile value
     * @param \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile
     * @return \eBizCharge\StructType\UpdateCustomerPaymentMethodProfile
     */
    public function setPaymentMethodProfile(\eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile = null)
    {
        $this->paymentMethodProfile = $paymentMethodProfile;
        return $this;
    }
}
