<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodProfile StructType
 * @subpackage Structs
 */
class PaymentMethodProfile extends AbstractStructBase
{
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The Modified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Modified;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Balance;
    /**
     * The MaxBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxBalance;
    /**
     * The MethodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodType;
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodID;
    /**
     * The MethodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodName;
    /**
     * The SecondarySort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecondarySort;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The AccountHolderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolderName;
    /**
     * The DriversLicense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicense;
    /**
     * The DriversLicenseState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicenseState;
    /**
     * The RecordType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecordType;
    /**
     * The Routing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Routing;
    /**
     * The AvsStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsStreet;
    /**
     * The AvsZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsZip;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardType;
    /**
     * The AutoReload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoReload;
    /**
     * The ReloadSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReloadSchedule;
    /**
     * The ReloadThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReloadThreshold;
    /**
     * The ReloadAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReloadAmount;
    /**
     * The ReloadMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReloadMethodID;
    /**
     * Constructor method for PaymentMethodProfile
     * @uses PaymentMethodProfile::setCreated()
     * @uses PaymentMethodProfile::setModified()
     * @uses PaymentMethodProfile::setBalance()
     * @uses PaymentMethodProfile::setMaxBalance()
     * @uses PaymentMethodProfile::setMethodType()
     * @uses PaymentMethodProfile::setMethodID()
     * @uses PaymentMethodProfile::setMethodName()
     * @uses PaymentMethodProfile::setSecondarySort()
     * @uses PaymentMethodProfile::setAccount()
     * @uses PaymentMethodProfile::setAccountType()
     * @uses PaymentMethodProfile::setAccountHolderName()
     * @uses PaymentMethodProfile::setDriversLicense()
     * @uses PaymentMethodProfile::setDriversLicenseState()
     * @uses PaymentMethodProfile::setRecordType()
     * @uses PaymentMethodProfile::setRouting()
     * @uses PaymentMethodProfile::setAvsStreet()
     * @uses PaymentMethodProfile::setAvsZip()
     * @uses PaymentMethodProfile::setCardCode()
     * @uses PaymentMethodProfile::setCardExpiration()
     * @uses PaymentMethodProfile::setCardNumber()
     * @uses PaymentMethodProfile::setCardType()
     * @uses PaymentMethodProfile::setAutoReload()
     * @uses PaymentMethodProfile::setReloadSchedule()
     * @uses PaymentMethodProfile::setReloadThreshold()
     * @uses PaymentMethodProfile::setReloadAmount()
     * @uses PaymentMethodProfile::setReloadMethodID()
     * @param string $created
     * @param string $modified
     * @param float $balance
     * @param float $maxBalance
     * @param string $methodType
     * @param string $methodID
     * @param string $methodName
     * @param string $secondarySort
     * @param string $account
     * @param string $accountType
     * @param string $accountHolderName
     * @param string $driversLicense
     * @param string $driversLicenseState
     * @param string $recordType
     * @param string $routing
     * @param string $avsStreet
     * @param string $avsZip
     * @param string $cardCode
     * @param string $cardExpiration
     * @param string $cardNumber
     * @param string $cardType
     * @param string $autoReload
     * @param string $reloadSchedule
     * @param string $reloadThreshold
     * @param string $reloadAmount
     * @param string $reloadMethodID
     */
    public function __construct($created = null, $modified = null, $balance = null, $maxBalance = null, $methodType = null, $methodID = null, $methodName = null, $secondarySort = null, $account = null, $accountType = null, $accountHolderName = null, $driversLicense = null, $driversLicenseState = null, $recordType = null, $routing = null, $avsStreet = null, $avsZip = null, $cardCode = null, $cardExpiration = null, $cardNumber = null, $cardType = null, $autoReload = null, $reloadSchedule = null, $reloadThreshold = null, $reloadAmount = null, $reloadMethodID = null)
    {
        $this
            ->setCreated($created)
            ->setModified($modified)
            ->setBalance($balance)
            ->setMaxBalance($maxBalance)
            ->setMethodType($methodType)
            ->setMethodID($methodID)
            ->setMethodName($methodName)
            ->setSecondarySort($secondarySort)
            ->setAccount($account)
            ->setAccountType($accountType)
            ->setAccountHolderName($accountHolderName)
            ->setDriversLicense($driversLicense)
            ->setDriversLicenseState($driversLicenseState)
            ->setRecordType($recordType)
            ->setRouting($routing)
            ->setAvsStreet($avsStreet)
            ->setAvsZip($avsZip)
            ->setCardCode($cardCode)
            ->setCardExpiration($cardExpiration)
            ->setCardNumber($cardNumber)
            ->setCardType($cardType)
            ->setAutoReload($autoReload)
            ->setReloadSchedule($reloadSchedule)
            ->setReloadThreshold($reloadThreshold)
            ->setReloadAmount($reloadAmount)
            ->setReloadMethodID($reloadMethodID);
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get MaxBalance value
     * @return float
     */
    public function getMaxBalance()
    {
        return $this->MaxBalance;
    }
    /**
     * Set MaxBalance value
     * @param float $maxBalance
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setMaxBalance($maxBalance = null)
    {
        // validation for constraint: float
        if (!is_null($maxBalance) && !(is_float($maxBalance) || is_numeric($maxBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxBalance, true), gettype($maxBalance)), __LINE__);
        }
        $this->MaxBalance = $maxBalance;
        return $this;
    }
    /**
     * Get MethodType value
     * @return string|null
     */
    public function getMethodType()
    {
        return $this->MethodType;
    }
    /**
     * Set MethodType value
     * @param string $methodType
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setMethodType($methodType = null)
    {
        // validation for constraint: string
        if (!is_null($methodType) && !is_string($methodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodType, true), gettype($methodType)), __LINE__);
        }
        $this->MethodType = $methodType;
        return $this;
    }
    /**
     * Get MethodID value
     * @return string|null
     */
    public function getMethodID()
    {
        return $this->MethodID;
    }
    /**
     * Set MethodID value
     * @param string $methodID
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        $this->MethodID = $methodID;
        return $this;
    }
    /**
     * Get MethodName value
     * @return string|null
     */
    public function getMethodName()
    {
        return $this->MethodName;
    }
    /**
     * Set MethodName value
     * @param string $methodName
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        $this->MethodName = $methodName;
        return $this;
    }
    /**
     * Get SecondarySort value
     * @return string|null
     */
    public function getSecondarySort()
    {
        return $this->SecondarySort;
    }
    /**
     * Set SecondarySort value
     * @param string $secondarySort
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setSecondarySort($secondarySort = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySort) && !is_string($secondarySort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondarySort, true), gettype($secondarySort)), __LINE__);
        }
        $this->SecondarySort = $secondarySort;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get AccountHolderName value
     * @return string|null
     */
    public function getAccountHolderName()
    {
        return $this->AccountHolderName;
    }
    /**
     * Set AccountHolderName value
     * @param string $accountHolderName
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAccountHolderName($accountHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolderName) && !is_string($accountHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolderName, true), gettype($accountHolderName)), __LINE__);
        }
        $this->AccountHolderName = $accountHolderName;
        return $this;
    }
    /**
     * Get DriversLicense value
     * @return string|null
     */
    public function getDriversLicense()
    {
        return $this->DriversLicense;
    }
    /**
     * Set DriversLicense value
     * @param string $driversLicense
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setDriversLicense($driversLicense = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicense) && !is_string($driversLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driversLicense, true), gettype($driversLicense)), __LINE__);
        }
        $this->DriversLicense = $driversLicense;
        return $this;
    }
    /**
     * Get DriversLicenseState value
     * @return string|null
     */
    public function getDriversLicenseState()
    {
        return $this->DriversLicenseState;
    }
    /**
     * Set DriversLicenseState value
     * @param string $driversLicenseState
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setDriversLicenseState($driversLicenseState = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicenseState) && !is_string($driversLicenseState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driversLicenseState, true), gettype($driversLicenseState)), __LINE__);
        }
        $this->DriversLicenseState = $driversLicenseState;
        return $this;
    }
    /**
     * Get RecordType value
     * @return string|null
     */
    public function getRecordType()
    {
        return $this->RecordType;
    }
    /**
     * Set RecordType value
     * @param string $recordType
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: string
        if (!is_null($recordType) && !is_string($recordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordType, true), gettype($recordType)), __LINE__);
        }
        $this->RecordType = $recordType;
        return $this;
    }
    /**
     * Get Routing value
     * @return string|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param string $routing
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setRouting($routing = null)
    {
        // validation for constraint: string
        if (!is_null($routing) && !is_string($routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routing, true), gettype($routing)), __LINE__);
        }
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Get AvsStreet value
     * @return string|null
     */
    public function getAvsStreet()
    {
        return $this->AvsStreet;
    }
    /**
     * Set AvsStreet value
     * @param string $avsStreet
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAvsStreet($avsStreet = null)
    {
        // validation for constraint: string
        if (!is_null($avsStreet) && !is_string($avsStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsStreet, true), gettype($avsStreet)), __LINE__);
        }
        $this->AvsStreet = $avsStreet;
        return $this;
    }
    /**
     * Get AvsZip value
     * @return string|null
     */
    public function getAvsZip()
    {
        return $this->AvsZip;
    }
    /**
     * Set AvsZip value
     * @param string $avsZip
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAvsZip($avsZip = null)
    {
        // validation for constraint: string
        if (!is_null($avsZip) && !is_string($avsZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsZip, true), gettype($avsZip)), __LINE__);
        }
        $this->AvsZip = $avsZip;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get AutoReload value
     * @return string|null
     */
    public function getAutoReload()
    {
        return $this->AutoReload;
    }
    /**
     * Set AutoReload value
     * @param string $autoReload
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setAutoReload($autoReload = null)
    {
        // validation for constraint: string
        if (!is_null($autoReload) && !is_string($autoReload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoReload, true), gettype($autoReload)), __LINE__);
        }
        $this->AutoReload = $autoReload;
        return $this;
    }
    /**
     * Get ReloadSchedule value
     * @return string|null
     */
    public function getReloadSchedule()
    {
        return $this->ReloadSchedule;
    }
    /**
     * Set ReloadSchedule value
     * @param string $reloadSchedule
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setReloadSchedule($reloadSchedule = null)
    {
        // validation for constraint: string
        if (!is_null($reloadSchedule) && !is_string($reloadSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reloadSchedule, true), gettype($reloadSchedule)), __LINE__);
        }
        $this->ReloadSchedule = $reloadSchedule;
        return $this;
    }
    /**
     * Get ReloadThreshold value
     * @return string|null
     */
    public function getReloadThreshold()
    {
        return $this->ReloadThreshold;
    }
    /**
     * Set ReloadThreshold value
     * @param string $reloadThreshold
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setReloadThreshold($reloadThreshold = null)
    {
        // validation for constraint: string
        if (!is_null($reloadThreshold) && !is_string($reloadThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reloadThreshold, true), gettype($reloadThreshold)), __LINE__);
        }
        $this->ReloadThreshold = $reloadThreshold;
        return $this;
    }
    /**
     * Get ReloadAmount value
     * @return string|null
     */
    public function getReloadAmount()
    {
        return $this->ReloadAmount;
    }
    /**
     * Set ReloadAmount value
     * @param string $reloadAmount
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setReloadAmount($reloadAmount = null)
    {
        // validation for constraint: string
        if (!is_null($reloadAmount) && !is_string($reloadAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reloadAmount, true), gettype($reloadAmount)), __LINE__);
        }
        $this->ReloadAmount = $reloadAmount;
        return $this;
    }
    /**
     * Get ReloadMethodID value
     * @return string|null
     */
    public function getReloadMethodID()
    {
        return $this->ReloadMethodID;
    }
    /**
     * Set ReloadMethodID value
     * @param string $reloadMethodID
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public function setReloadMethodID($reloadMethodID = null)
    {
        // validation for constraint: string
        if (!is_null($reloadMethodID) && !is_string($reloadMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reloadMethodID, true), gettype($reloadMethodID)), __LINE__);
        }
        $this->ReloadMethodID = $reloadMethodID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\PaymentMethodProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
