<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationData StructType
 * @subpackage Structs
 */
class GetApplicationData extends AbstractStructBase
{
    /**
     * The applicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationId;
    /**
     * The lookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lookupKey;
    /**
     * The applicationDataInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationDataInternalId;
    /**
     * Constructor method for GetApplicationData
     * @uses GetApplicationData::setApplicationId()
     * @uses GetApplicationData::setLookupKey()
     * @uses GetApplicationData::setApplicationDataInternalId()
     * @param string $applicationId
     * @param string $lookupKey
     * @param string $applicationDataInternalId
     */
    public function __construct($applicationId = null, $lookupKey = null, $applicationDataInternalId = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setLookupKey($lookupKey)
            ->setApplicationDataInternalId($applicationDataInternalId);
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \eBizCharge\StructType\GetApplicationData
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get lookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->lookupKey;
    }
    /**
     * Set lookupKey value
     * @param string $lookupKey
     * @return \eBizCharge\StructType\GetApplicationData
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        $this->lookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get applicationDataInternalId value
     * @return string|null
     */
    public function getApplicationDataInternalId()
    {
        return $this->applicationDataInternalId;
    }
    /**
     * Set applicationDataInternalId value
     * @param string $applicationDataInternalId
     * @return \eBizCharge\StructType\GetApplicationData
     */
    public function setApplicationDataInternalId($applicationDataInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationDataInternalId) && !is_string($applicationDataInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationDataInternalId, true), gettype($applicationDataInternalId)), __LINE__);
        }
        $this->applicationDataInternalId = $applicationDataInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GetApplicationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
