<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resend ServiceType
 * @subpackage Services
 */
class Resend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResendPaymentFormEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\ResendPaymentFormEmail $parameters
     * @return \eBizCharge\StructType\ResendPaymentFormEmailResponse|bool
     */
    public function ResendPaymentFormEmail(\eBizCharge\StructType\ResendPaymentFormEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResendPaymentFormEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ResendEbizWebFormEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\ResendEbizWebFormEmail $parameters
     * @return \eBizCharge\StructType\ResendEbizWebFormEmailResponse|bool
     */
    public function ResendEbizWebFormEmail(\eBizCharge\StructType\ResendEbizWebFormEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResendEbizWebFormEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\ResendEbizWebFormEmailResponse|\eBizCharge\StructType\ResendPaymentFormEmailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
