<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMerchantData StructType
 * @subpackage Structs
 */
class UpdateMerchantData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The merchantInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $merchantInternalId;
    /**
     * The merchantData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\MerchantData
     */
    public $merchantData;
    /**
     * Constructor method for UpdateMerchantData
     * @uses UpdateMerchantData::setSecurityToken()
     * @uses UpdateMerchantData::setMerchantInternalId()
     * @uses UpdateMerchantData::setMerchantData()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $merchantInternalId
     * @param \eBizCharge\StructType\MerchantData $merchantData
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $merchantInternalId = null, \eBizCharge\StructType\MerchantData $merchantData = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setMerchantInternalId($merchantInternalId)
            ->setMerchantData($merchantData);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateMerchantData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get merchantInternalId value
     * @return string|null
     */
    public function getMerchantInternalId()
    {
        return $this->merchantInternalId;
    }
    /**
     * Set merchantInternalId value
     * @param string $merchantInternalId
     * @return \eBizCharge\StructType\UpdateMerchantData
     */
    public function setMerchantInternalId($merchantInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantInternalId) && !is_string($merchantInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantInternalId, true), gettype($merchantInternalId)), __LINE__);
        }
        $this->merchantInternalId = $merchantInternalId;
        return $this;
    }
    /**
     * Get merchantData value
     * @return \eBizCharge\StructType\MerchantData|null
     */
    public function getMerchantData()
    {
        return $this->merchantData;
    }
    /**
     * Set merchantData value
     * @param \eBizCharge\StructType\MerchantData $merchantData
     * @return \eBizCharge\StructType\UpdateMerchantData
     */
    public function setMerchantData(\eBizCharge\StructType\MerchantData $merchantData = null)
    {
        $this->merchantData = $merchantData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\UpdateMerchantData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
