<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantSettings StructType
 * @subpackage Structs
 */
class MerchantSettings extends AbstractStructBase
{
    /**
     * The AllowedPayByType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AllowedPayByType;
    /**
     * The AllowPartialPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowPartialPayment;
    /**
     * The AllowOverPaymentOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AllowOverPaymentOptions;
    /**
     * The ShowCreditTab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowCreditTab;
    /**
     * The ReceieveNotificationEmailWhenPaymentMethodAddedOrModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReceieveNotificationEmailWhenPaymentMethodAddedOrModified;
    /**
     * The SendNotificationEmailToCustomersWhenInvoiceAddedOrModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendNotificationEmailToCustomersWhenInvoiceAddedOrModified;
    /**
     * The SendNotificationEmailToCustomersWhenInvoiceModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendNotificationEmailToCustomersWhenInvoiceModified;
    /**
     * The SendNotificationEmailToCustomersWhenInvoiceAdded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendNotificationEmailToCustomersWhenInvoiceAdded;
    /**
     * The SendNotificationEmailToCustomersWhenPMExpired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendNotificationEmailToCustomersWhenPMExpired;
    /**
     * The AllowPayByCreditOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowPayByCreditOnly;
    /**
     * The SendNotificationEmailToCustomersForPastDueInvoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendNotificationEmailToCustomersForPastDueInvoices;
    /**
     * The SendEmailFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendEmailFrom;
    /**
     * The SendEmailFromDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendEmailFromDisplayName;
    /**
     * The ReplyToEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToEmail;
    /**
     * The CustomerEmailSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerEmailSubject;
    /**
     * The MerchantEmailSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantEmailSubject;
    /**
     * Constructor method for MerchantSettings
     * @uses MerchantSettings::setAllowedPayByType()
     * @uses MerchantSettings::setAllowPartialPayment()
     * @uses MerchantSettings::setAllowOverPaymentOptions()
     * @uses MerchantSettings::setShowCreditTab()
     * @uses MerchantSettings::setReceieveNotificationEmailWhenPaymentMethodAddedOrModified()
     * @uses MerchantSettings::setSendNotificationEmailToCustomersWhenInvoiceAddedOrModified()
     * @uses MerchantSettings::setSendNotificationEmailToCustomersWhenInvoiceModified()
     * @uses MerchantSettings::setSendNotificationEmailToCustomersWhenInvoiceAdded()
     * @uses MerchantSettings::setSendNotificationEmailToCustomersWhenPMExpired()
     * @uses MerchantSettings::setAllowPayByCreditOnly()
     * @uses MerchantSettings::setSendNotificationEmailToCustomersForPastDueInvoices()
     * @uses MerchantSettings::setSendEmailFrom()
     * @uses MerchantSettings::setSendEmailFromDisplayName()
     * @uses MerchantSettings::setReplyToEmail()
     * @uses MerchantSettings::setCustomerEmailSubject()
     * @uses MerchantSettings::setMerchantEmailSubject()
     * @param int $allowedPayByType
     * @param bool $allowPartialPayment
     * @param int $allowOverPaymentOptions
     * @param bool $showCreditTab
     * @param bool $receieveNotificationEmailWhenPaymentMethodAddedOrModified
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceAddedOrModified
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceModified
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceAdded
     * @param bool $sendNotificationEmailToCustomersWhenPMExpired
     * @param bool $allowPayByCreditOnly
     * @param bool $sendNotificationEmailToCustomersForPastDueInvoices
     * @param string $sendEmailFrom
     * @param string $sendEmailFromDisplayName
     * @param string $replyToEmail
     * @param string $customerEmailSubject
     * @param string $merchantEmailSubject
     */
    public function __construct($allowedPayByType = null, $allowPartialPayment = null, $allowOverPaymentOptions = null, $showCreditTab = null, $receieveNotificationEmailWhenPaymentMethodAddedOrModified = null, $sendNotificationEmailToCustomersWhenInvoiceAddedOrModified = null, $sendNotificationEmailToCustomersWhenInvoiceModified = null, $sendNotificationEmailToCustomersWhenInvoiceAdded = null, $sendNotificationEmailToCustomersWhenPMExpired = null, $allowPayByCreditOnly = null, $sendNotificationEmailToCustomersForPastDueInvoices = null, $sendEmailFrom = null, $sendEmailFromDisplayName = null, $replyToEmail = null, $customerEmailSubject = null, $merchantEmailSubject = null)
    {
        $this
            ->setAllowedPayByType($allowedPayByType)
            ->setAllowPartialPayment($allowPartialPayment)
            ->setAllowOverPaymentOptions($allowOverPaymentOptions)
            ->setShowCreditTab($showCreditTab)
            ->setReceieveNotificationEmailWhenPaymentMethodAddedOrModified($receieveNotificationEmailWhenPaymentMethodAddedOrModified)
            ->setSendNotificationEmailToCustomersWhenInvoiceAddedOrModified($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified)
            ->setSendNotificationEmailToCustomersWhenInvoiceModified($sendNotificationEmailToCustomersWhenInvoiceModified)
            ->setSendNotificationEmailToCustomersWhenInvoiceAdded($sendNotificationEmailToCustomersWhenInvoiceAdded)
            ->setSendNotificationEmailToCustomersWhenPMExpired($sendNotificationEmailToCustomersWhenPMExpired)
            ->setAllowPayByCreditOnly($allowPayByCreditOnly)
            ->setSendNotificationEmailToCustomersForPastDueInvoices($sendNotificationEmailToCustomersForPastDueInvoices)
            ->setSendEmailFrom($sendEmailFrom)
            ->setSendEmailFromDisplayName($sendEmailFromDisplayName)
            ->setReplyToEmail($replyToEmail)
            ->setCustomerEmailSubject($customerEmailSubject)
            ->setMerchantEmailSubject($merchantEmailSubject);
    }
    /**
     * Get AllowedPayByType value
     * @return int
     */
    public function getAllowedPayByType()
    {
        return $this->AllowedPayByType;
    }
    /**
     * Set AllowedPayByType value
     * @param int $allowedPayByType
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setAllowedPayByType($allowedPayByType = null)
    {
        // validation for constraint: int
        if (!is_null($allowedPayByType) && !(is_int($allowedPayByType) || ctype_digit($allowedPayByType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowedPayByType, true), gettype($allowedPayByType)), __LINE__);
        }
        $this->AllowedPayByType = $allowedPayByType;
        return $this;
    }
    /**
     * Get AllowPartialPayment value
     * @return bool
     */
    public function getAllowPartialPayment()
    {
        return $this->AllowPartialPayment;
    }
    /**
     * Set AllowPartialPayment value
     * @param bool $allowPartialPayment
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setAllowPartialPayment($allowPartialPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialPayment) && !is_bool($allowPartialPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialPayment, true), gettype($allowPartialPayment)), __LINE__);
        }
        $this->AllowPartialPayment = $allowPartialPayment;
        return $this;
    }
    /**
     * Get AllowOverPaymentOptions value
     * @return int
     */
    public function getAllowOverPaymentOptions()
    {
        return $this->AllowOverPaymentOptions;
    }
    /**
     * Set AllowOverPaymentOptions value
     * @param int $allowOverPaymentOptions
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setAllowOverPaymentOptions($allowOverPaymentOptions = null)
    {
        // validation for constraint: int
        if (!is_null($allowOverPaymentOptions) && !(is_int($allowOverPaymentOptions) || ctype_digit($allowOverPaymentOptions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowOverPaymentOptions, true), gettype($allowOverPaymentOptions)), __LINE__);
        }
        $this->AllowOverPaymentOptions = $allowOverPaymentOptions;
        return $this;
    }
    /**
     * Get ShowCreditTab value
     * @return bool
     */
    public function getShowCreditTab()
    {
        return $this->ShowCreditTab;
    }
    /**
     * Set ShowCreditTab value
     * @param bool $showCreditTab
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setShowCreditTab($showCreditTab = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCreditTab) && !is_bool($showCreditTab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCreditTab, true), gettype($showCreditTab)), __LINE__);
        }
        $this->ShowCreditTab = $showCreditTab;
        return $this;
    }
    /**
     * Get ReceieveNotificationEmailWhenPaymentMethodAddedOrModified value
     * @return bool
     */
    public function getReceieveNotificationEmailWhenPaymentMethodAddedOrModified()
    {
        return $this->ReceieveNotificationEmailWhenPaymentMethodAddedOrModified;
    }
    /**
     * Set ReceieveNotificationEmailWhenPaymentMethodAddedOrModified value
     * @param bool $receieveNotificationEmailWhenPaymentMethodAddedOrModified
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setReceieveNotificationEmailWhenPaymentMethodAddedOrModified($receieveNotificationEmailWhenPaymentMethodAddedOrModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($receieveNotificationEmailWhenPaymentMethodAddedOrModified) && !is_bool($receieveNotificationEmailWhenPaymentMethodAddedOrModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receieveNotificationEmailWhenPaymentMethodAddedOrModified, true), gettype($receieveNotificationEmailWhenPaymentMethodAddedOrModified)), __LINE__);
        }
        $this->ReceieveNotificationEmailWhenPaymentMethodAddedOrModified = $receieveNotificationEmailWhenPaymentMethodAddedOrModified;
        return $this;
    }
    /**
     * Get SendNotificationEmailToCustomersWhenInvoiceAddedOrModified value
     * @return bool
     */
    public function getSendNotificationEmailToCustomersWhenInvoiceAddedOrModified()
    {
        return $this->SendNotificationEmailToCustomersWhenInvoiceAddedOrModified;
    }
    /**
     * Set SendNotificationEmailToCustomersWhenInvoiceAddedOrModified value
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceAddedOrModified
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendNotificationEmailToCustomersWhenInvoiceAddedOrModified($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified) && !is_bool($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified, true), gettype($sendNotificationEmailToCustomersWhenInvoiceAddedOrModified)), __LINE__);
        }
        $this->SendNotificationEmailToCustomersWhenInvoiceAddedOrModified = $sendNotificationEmailToCustomersWhenInvoiceAddedOrModified;
        return $this;
    }
    /**
     * Get SendNotificationEmailToCustomersWhenInvoiceModified value
     * @return bool
     */
    public function getSendNotificationEmailToCustomersWhenInvoiceModified()
    {
        return $this->SendNotificationEmailToCustomersWhenInvoiceModified;
    }
    /**
     * Set SendNotificationEmailToCustomersWhenInvoiceModified value
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceModified
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendNotificationEmailToCustomersWhenInvoiceModified($sendNotificationEmailToCustomersWhenInvoiceModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotificationEmailToCustomersWhenInvoiceModified) && !is_bool($sendNotificationEmailToCustomersWhenInvoiceModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotificationEmailToCustomersWhenInvoiceModified, true), gettype($sendNotificationEmailToCustomersWhenInvoiceModified)), __LINE__);
        }
        $this->SendNotificationEmailToCustomersWhenInvoiceModified = $sendNotificationEmailToCustomersWhenInvoiceModified;
        return $this;
    }
    /**
     * Get SendNotificationEmailToCustomersWhenInvoiceAdded value
     * @return bool
     */
    public function getSendNotificationEmailToCustomersWhenInvoiceAdded()
    {
        return $this->SendNotificationEmailToCustomersWhenInvoiceAdded;
    }
    /**
     * Set SendNotificationEmailToCustomersWhenInvoiceAdded value
     * @param bool $sendNotificationEmailToCustomersWhenInvoiceAdded
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendNotificationEmailToCustomersWhenInvoiceAdded($sendNotificationEmailToCustomersWhenInvoiceAdded = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotificationEmailToCustomersWhenInvoiceAdded) && !is_bool($sendNotificationEmailToCustomersWhenInvoiceAdded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotificationEmailToCustomersWhenInvoiceAdded, true), gettype($sendNotificationEmailToCustomersWhenInvoiceAdded)), __LINE__);
        }
        $this->SendNotificationEmailToCustomersWhenInvoiceAdded = $sendNotificationEmailToCustomersWhenInvoiceAdded;
        return $this;
    }
    /**
     * Get SendNotificationEmailToCustomersWhenPMExpired value
     * @return bool
     */
    public function getSendNotificationEmailToCustomersWhenPMExpired()
    {
        return $this->SendNotificationEmailToCustomersWhenPMExpired;
    }
    /**
     * Set SendNotificationEmailToCustomersWhenPMExpired value
     * @param bool $sendNotificationEmailToCustomersWhenPMExpired
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendNotificationEmailToCustomersWhenPMExpired($sendNotificationEmailToCustomersWhenPMExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotificationEmailToCustomersWhenPMExpired) && !is_bool($sendNotificationEmailToCustomersWhenPMExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotificationEmailToCustomersWhenPMExpired, true), gettype($sendNotificationEmailToCustomersWhenPMExpired)), __LINE__);
        }
        $this->SendNotificationEmailToCustomersWhenPMExpired = $sendNotificationEmailToCustomersWhenPMExpired;
        return $this;
    }
    /**
     * Get AllowPayByCreditOnly value
     * @return bool
     */
    public function getAllowPayByCreditOnly()
    {
        return $this->AllowPayByCreditOnly;
    }
    /**
     * Set AllowPayByCreditOnly value
     * @param bool $allowPayByCreditOnly
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setAllowPayByCreditOnly($allowPayByCreditOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPayByCreditOnly) && !is_bool($allowPayByCreditOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPayByCreditOnly, true), gettype($allowPayByCreditOnly)), __LINE__);
        }
        $this->AllowPayByCreditOnly = $allowPayByCreditOnly;
        return $this;
    }
    /**
     * Get SendNotificationEmailToCustomersForPastDueInvoices value
     * @return bool
     */
    public function getSendNotificationEmailToCustomersForPastDueInvoices()
    {
        return $this->SendNotificationEmailToCustomersForPastDueInvoices;
    }
    /**
     * Set SendNotificationEmailToCustomersForPastDueInvoices value
     * @param bool $sendNotificationEmailToCustomersForPastDueInvoices
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendNotificationEmailToCustomersForPastDueInvoices($sendNotificationEmailToCustomersForPastDueInvoices = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotificationEmailToCustomersForPastDueInvoices) && !is_bool($sendNotificationEmailToCustomersForPastDueInvoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotificationEmailToCustomersForPastDueInvoices, true), gettype($sendNotificationEmailToCustomersForPastDueInvoices)), __LINE__);
        }
        $this->SendNotificationEmailToCustomersForPastDueInvoices = $sendNotificationEmailToCustomersForPastDueInvoices;
        return $this;
    }
    /**
     * Get SendEmailFrom value
     * @return string|null
     */
    public function getSendEmailFrom()
    {
        return $this->SendEmailFrom;
    }
    /**
     * Set SendEmailFrom value
     * @param string $sendEmailFrom
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendEmailFrom($sendEmailFrom = null)
    {
        // validation for constraint: string
        if (!is_null($sendEmailFrom) && !is_string($sendEmailFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendEmailFrom, true), gettype($sendEmailFrom)), __LINE__);
        }
        $this->SendEmailFrom = $sendEmailFrom;
        return $this;
    }
    /**
     * Get SendEmailFromDisplayName value
     * @return string|null
     */
    public function getSendEmailFromDisplayName()
    {
        return $this->SendEmailFromDisplayName;
    }
    /**
     * Set SendEmailFromDisplayName value
     * @param string $sendEmailFromDisplayName
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setSendEmailFromDisplayName($sendEmailFromDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($sendEmailFromDisplayName) && !is_string($sendEmailFromDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendEmailFromDisplayName, true), gettype($sendEmailFromDisplayName)), __LINE__);
        }
        $this->SendEmailFromDisplayName = $sendEmailFromDisplayName;
        return $this;
    }
    /**
     * Get ReplyToEmail value
     * @return string|null
     */
    public function getReplyToEmail()
    {
        return $this->ReplyToEmail;
    }
    /**
     * Set ReplyToEmail value
     * @param string $replyToEmail
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setReplyToEmail($replyToEmail = null)
    {
        // validation for constraint: string
        if (!is_null($replyToEmail) && !is_string($replyToEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyToEmail, true), gettype($replyToEmail)), __LINE__);
        }
        $this->ReplyToEmail = $replyToEmail;
        return $this;
    }
    /**
     * Get CustomerEmailSubject value
     * @return string|null
     */
    public function getCustomerEmailSubject()
    {
        return $this->CustomerEmailSubject;
    }
    /**
     * Set CustomerEmailSubject value
     * @param string $customerEmailSubject
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setCustomerEmailSubject($customerEmailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($customerEmailSubject) && !is_string($customerEmailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerEmailSubject, true), gettype($customerEmailSubject)), __LINE__);
        }
        $this->CustomerEmailSubject = $customerEmailSubject;
        return $this;
    }
    /**
     * Get MerchantEmailSubject value
     * @return string|null
     */
    public function getMerchantEmailSubject()
    {
        return $this->MerchantEmailSubject;
    }
    /**
     * Set MerchantEmailSubject value
     * @param string $merchantEmailSubject
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public function setMerchantEmailSubject($merchantEmailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($merchantEmailSubject) && !is_string($merchantEmailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantEmailSubject, true), gettype($merchantEmailSubject)), __LINE__);
        }
        $this->MerchantEmailSubject = $merchantEmailSubject;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\MerchantSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
