<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCardInfo StructType
 * @subpackage Structs
 */
class GetCardInfo extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The cardBIN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardBIN;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The paymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethodId;
    /**
     * Constructor method for GetCardInfo
     * @uses GetCardInfo::setSecurityToken()
     * @uses GetCardInfo::setCardBIN()
     * @uses GetCardInfo::setCustomerInternalId()
     * @uses GetCardInfo::setPaymentMethodId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $cardBIN
     * @param string $customerInternalId
     * @param string $paymentMethodId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $cardBIN = null, $customerInternalId = null, $paymentMethodId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCardBIN($cardBIN)
            ->setCustomerInternalId($customerInternalId)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetCardInfo
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get cardBIN value
     * @return string|null
     */
    public function getCardBIN()
    {
        return $this->cardBIN;
    }
    /**
     * Set cardBIN value
     * @param string $cardBIN
     * @return \eBizCharge\StructType\GetCardInfo
     */
    public function setCardBIN($cardBIN = null)
    {
        // validation for constraint: string
        if (!is_null($cardBIN) && !is_string($cardBIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBIN, true), gettype($cardBIN)), __LINE__);
        }
        $this->cardBIN = $cardBIN;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\GetCardInfo
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get paymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->paymentMethodId;
    }
    /**
     * Set paymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\GetCardInfo
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->paymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GetCardInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
