<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSearchResult StructType
 * @subpackage Structs
 */
class TransactionSearchResult extends AbstractStructBase
{
    /**
     * The SalesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesAmount;
    /**
     * The ErrorsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ErrorsAmount;
    /**
     * The DeclinesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeclinesAmount;
    /**
     * The CreditsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CreditsAmount;
    /**
     * The AuthOnlyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AuthOnlyAmount;
    /**
     * The VoidsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VoidsAmount;
    /**
     * The ErrorsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorsCount;
    /**
     * The TransactionsMatched
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionsMatched;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfTransactionObject
     */
    public $Transactions;
    /**
     * The StartIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartIndex;
    /**
     * The SalesCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesCount;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Limit;
    /**
     * The VoidsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoidsCount;
    /**
     * The DeclinesCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeclinesCount;
    /**
     * The CreditsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditsCount;
    /**
     * The AuthOnlyCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthOnlyCount;
    /**
     * The TransactionsReturned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionsReturned;
    /**
     * Constructor method for TransactionSearchResult
     * @uses TransactionSearchResult::setSalesAmount()
     * @uses TransactionSearchResult::setErrorsAmount()
     * @uses TransactionSearchResult::setDeclinesAmount()
     * @uses TransactionSearchResult::setCreditsAmount()
     * @uses TransactionSearchResult::setAuthOnlyAmount()
     * @uses TransactionSearchResult::setVoidsAmount()
     * @uses TransactionSearchResult::setErrorsCount()
     * @uses TransactionSearchResult::setTransactionsMatched()
     * @uses TransactionSearchResult::setTransactions()
     * @uses TransactionSearchResult::setStartIndex()
     * @uses TransactionSearchResult::setSalesCount()
     * @uses TransactionSearchResult::setLimit()
     * @uses TransactionSearchResult::setVoidsCount()
     * @uses TransactionSearchResult::setDeclinesCount()
     * @uses TransactionSearchResult::setCreditsCount()
     * @uses TransactionSearchResult::setAuthOnlyCount()
     * @uses TransactionSearchResult::setTransactionsReturned()
     * @param float $salesAmount
     * @param float $errorsAmount
     * @param float $declinesAmount
     * @param float $creditsAmount
     * @param float $authOnlyAmount
     * @param float $voidsAmount
     * @param string $errorsCount
     * @param string $transactionsMatched
     * @param \eBizCharge\ArrayType\ArrayOfTransactionObject $transactions
     * @param string $startIndex
     * @param string $salesCount
     * @param string $limit
     * @param string $voidsCount
     * @param string $declinesCount
     * @param string $creditsCount
     * @param string $authOnlyCount
     * @param string $transactionsReturned
     */
    public function __construct($salesAmount = null, $errorsAmount = null, $declinesAmount = null, $creditsAmount = null, $authOnlyAmount = null, $voidsAmount = null, $errorsCount = null, $transactionsMatched = null, \eBizCharge\ArrayType\ArrayOfTransactionObject $transactions = null, $startIndex = null, $salesCount = null, $limit = null, $voidsCount = null, $declinesCount = null, $creditsCount = null, $authOnlyCount = null, $transactionsReturned = null)
    {
        $this
            ->setSalesAmount($salesAmount)
            ->setErrorsAmount($errorsAmount)
            ->setDeclinesAmount($declinesAmount)
            ->setCreditsAmount($creditsAmount)
            ->setAuthOnlyAmount($authOnlyAmount)
            ->setVoidsAmount($voidsAmount)
            ->setErrorsCount($errorsCount)
            ->setTransactionsMatched($transactionsMatched)
            ->setTransactions($transactions)
            ->setStartIndex($startIndex)
            ->setSalesCount($salesCount)
            ->setLimit($limit)
            ->setVoidsCount($voidsCount)
            ->setDeclinesCount($declinesCount)
            ->setCreditsCount($creditsCount)
            ->setAuthOnlyCount($authOnlyCount)
            ->setTransactionsReturned($transactionsReturned);
    }
    /**
     * Get SalesAmount value
     * @return float
     */
    public function getSalesAmount()
    {
        return $this->SalesAmount;
    }
    /**
     * Set SalesAmount value
     * @param float $salesAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setSalesAmount($salesAmount = null)
    {
        // validation for constraint: float
        if (!is_null($salesAmount) && !(is_float($salesAmount) || is_numeric($salesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesAmount, true), gettype($salesAmount)), __LINE__);
        }
        $this->SalesAmount = $salesAmount;
        return $this;
    }
    /**
     * Get ErrorsAmount value
     * @return float
     */
    public function getErrorsAmount()
    {
        return $this->ErrorsAmount;
    }
    /**
     * Set ErrorsAmount value
     * @param float $errorsAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setErrorsAmount($errorsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($errorsAmount) && !(is_float($errorsAmount) || is_numeric($errorsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($errorsAmount, true), gettype($errorsAmount)), __LINE__);
        }
        $this->ErrorsAmount = $errorsAmount;
        return $this;
    }
    /**
     * Get DeclinesAmount value
     * @return float
     */
    public function getDeclinesAmount()
    {
        return $this->DeclinesAmount;
    }
    /**
     * Set DeclinesAmount value
     * @param float $declinesAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setDeclinesAmount($declinesAmount = null)
    {
        // validation for constraint: float
        if (!is_null($declinesAmount) && !(is_float($declinesAmount) || is_numeric($declinesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($declinesAmount, true), gettype($declinesAmount)), __LINE__);
        }
        $this->DeclinesAmount = $declinesAmount;
        return $this;
    }
    /**
     * Get CreditsAmount value
     * @return float
     */
    public function getCreditsAmount()
    {
        return $this->CreditsAmount;
    }
    /**
     * Set CreditsAmount value
     * @param float $creditsAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setCreditsAmount($creditsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($creditsAmount) && !(is_float($creditsAmount) || is_numeric($creditsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditsAmount, true), gettype($creditsAmount)), __LINE__);
        }
        $this->CreditsAmount = $creditsAmount;
        return $this;
    }
    /**
     * Get AuthOnlyAmount value
     * @return float
     */
    public function getAuthOnlyAmount()
    {
        return $this->AuthOnlyAmount;
    }
    /**
     * Set AuthOnlyAmount value
     * @param float $authOnlyAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setAuthOnlyAmount($authOnlyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($authOnlyAmount) && !(is_float($authOnlyAmount) || is_numeric($authOnlyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authOnlyAmount, true), gettype($authOnlyAmount)), __LINE__);
        }
        $this->AuthOnlyAmount = $authOnlyAmount;
        return $this;
    }
    /**
     * Get VoidsAmount value
     * @return float
     */
    public function getVoidsAmount()
    {
        return $this->VoidsAmount;
    }
    /**
     * Set VoidsAmount value
     * @param float $voidsAmount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setVoidsAmount($voidsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($voidsAmount) && !(is_float($voidsAmount) || is_numeric($voidsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voidsAmount, true), gettype($voidsAmount)), __LINE__);
        }
        $this->VoidsAmount = $voidsAmount;
        return $this;
    }
    /**
     * Get ErrorsCount value
     * @return string|null
     */
    public function getErrorsCount()
    {
        return $this->ErrorsCount;
    }
    /**
     * Set ErrorsCount value
     * @param string $errorsCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setErrorsCount($errorsCount = null)
    {
        // validation for constraint: string
        if (!is_null($errorsCount) && !is_string($errorsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorsCount, true), gettype($errorsCount)), __LINE__);
        }
        $this->ErrorsCount = $errorsCount;
        return $this;
    }
    /**
     * Get TransactionsMatched value
     * @return string|null
     */
    public function getTransactionsMatched()
    {
        return $this->TransactionsMatched;
    }
    /**
     * Set TransactionsMatched value
     * @param string $transactionsMatched
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setTransactionsMatched($transactionsMatched = null)
    {
        // validation for constraint: string
        if (!is_null($transactionsMatched) && !is_string($transactionsMatched)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionsMatched, true), gettype($transactionsMatched)), __LINE__);
        }
        $this->TransactionsMatched = $transactionsMatched;
        return $this;
    }
    /**
     * Get Transactions value
     * @return \eBizCharge\ArrayType\ArrayOfTransactionObject|null
     */
    public function getTransactions()
    {
        return $this->Transactions;
    }
    /**
     * Set Transactions value
     * @param \eBizCharge\ArrayType\ArrayOfTransactionObject $transactions
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setTransactions(\eBizCharge\ArrayType\ArrayOfTransactionObject $transactions = null)
    {
        $this->Transactions = $transactions;
        return $this;
    }
    /**
     * Get StartIndex value
     * @return string|null
     */
    public function getStartIndex()
    {
        return $this->StartIndex;
    }
    /**
     * Set StartIndex value
     * @param string $startIndex
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setStartIndex($startIndex = null)
    {
        // validation for constraint: string
        if (!is_null($startIndex) && !is_string($startIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startIndex, true), gettype($startIndex)), __LINE__);
        }
        $this->StartIndex = $startIndex;
        return $this;
    }
    /**
     * Get SalesCount value
     * @return string|null
     */
    public function getSalesCount()
    {
        return $this->SalesCount;
    }
    /**
     * Set SalesCount value
     * @param string $salesCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setSalesCount($salesCount = null)
    {
        // validation for constraint: string
        if (!is_null($salesCount) && !is_string($salesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesCount, true), gettype($salesCount)), __LINE__);
        }
        $this->SalesCount = $salesCount;
        return $this;
    }
    /**
     * Get Limit value
     * @return string|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param string $limit
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: string
        if (!is_null($limit) && !is_string($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get VoidsCount value
     * @return string|null
     */
    public function getVoidsCount()
    {
        return $this->VoidsCount;
    }
    /**
     * Set VoidsCount value
     * @param string $voidsCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setVoidsCount($voidsCount = null)
    {
        // validation for constraint: string
        if (!is_null($voidsCount) && !is_string($voidsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voidsCount, true), gettype($voidsCount)), __LINE__);
        }
        $this->VoidsCount = $voidsCount;
        return $this;
    }
    /**
     * Get DeclinesCount value
     * @return string|null
     */
    public function getDeclinesCount()
    {
        return $this->DeclinesCount;
    }
    /**
     * Set DeclinesCount value
     * @param string $declinesCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setDeclinesCount($declinesCount = null)
    {
        // validation for constraint: string
        if (!is_null($declinesCount) && !is_string($declinesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declinesCount, true), gettype($declinesCount)), __LINE__);
        }
        $this->DeclinesCount = $declinesCount;
        return $this;
    }
    /**
     * Get CreditsCount value
     * @return string|null
     */
    public function getCreditsCount()
    {
        return $this->CreditsCount;
    }
    /**
     * Set CreditsCount value
     * @param string $creditsCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setCreditsCount($creditsCount = null)
    {
        // validation for constraint: string
        if (!is_null($creditsCount) && !is_string($creditsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditsCount, true), gettype($creditsCount)), __LINE__);
        }
        $this->CreditsCount = $creditsCount;
        return $this;
    }
    /**
     * Get AuthOnlyCount value
     * @return string|null
     */
    public function getAuthOnlyCount()
    {
        return $this->AuthOnlyCount;
    }
    /**
     * Set AuthOnlyCount value
     * @param string $authOnlyCount
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setAuthOnlyCount($authOnlyCount = null)
    {
        // validation for constraint: string
        if (!is_null($authOnlyCount) && !is_string($authOnlyCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authOnlyCount, true), gettype($authOnlyCount)), __LINE__);
        }
        $this->AuthOnlyCount = $authOnlyCount;
        return $this;
    }
    /**
     * Get TransactionsReturned value
     * @return string|null
     */
    public function getTransactionsReturned()
    {
        return $this->TransactionsReturned;
    }
    /**
     * Set TransactionsReturned value
     * @param string $transactionsReturned
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public function setTransactionsReturned($transactionsReturned = null)
    {
        // validation for constraint: string
        if (!is_null($transactionsReturned) && !is_string($transactionsReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionsReturned, true), gettype($transactionsReturned)), __LINE__);
        }
        $this->TransactionsReturned = $transactionsReturned;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\TransactionSearchResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
