<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalBINData StructType
 * @subpackage Structs
 */
class GlobalBINData extends AbstractStructBase
{
    /**
     * The LowBin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowBin;
    /**
     * The HighBin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HighBin;
    /**
     * The BinLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BinLength;
    /**
     * The CardProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductId;
    /**
     * The CardProductIdDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductIdDescription;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeId;
    /**
     * The CardTypeIdDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeIdDescription;
    /**
     * The IssuerBankName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuerBankName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The DetailCardProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DetailCardProduct;
    /**
     * The VisaLargeTicketIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisaLargeTicketIndicator;
    /**
     * The CardClassId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardClassId;
    /**
     * The CardClassIdDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardClassIdDescription;
    /**
     * Constructor method for GlobalBINData
     * @uses GlobalBINData::setLowBin()
     * @uses GlobalBINData::setHighBin()
     * @uses GlobalBINData::setBinLength()
     * @uses GlobalBINData::setCardProductId()
     * @uses GlobalBINData::setCardProductIdDescription()
     * @uses GlobalBINData::setCardTypeId()
     * @uses GlobalBINData::setCardTypeIdDescription()
     * @uses GlobalBINData::setIssuerBankName()
     * @uses GlobalBINData::setCountryCode()
     * @uses GlobalBINData::setDetailCardProduct()
     * @uses GlobalBINData::setVisaLargeTicketIndicator()
     * @uses GlobalBINData::setCardClassId()
     * @uses GlobalBINData::setCardClassIdDescription()
     * @param string $lowBin
     * @param string $highBin
     * @param string $binLength
     * @param string $cardProductId
     * @param string $cardProductIdDescription
     * @param string $cardTypeId
     * @param string $cardTypeIdDescription
     * @param string $issuerBankName
     * @param string $countryCode
     * @param string $detailCardProduct
     * @param string $visaLargeTicketIndicator
     * @param string $cardClassId
     * @param string $cardClassIdDescription
     */
    public function __construct($lowBin = null, $highBin = null, $binLength = null, $cardProductId = null, $cardProductIdDescription = null, $cardTypeId = null, $cardTypeIdDescription = null, $issuerBankName = null, $countryCode = null, $detailCardProduct = null, $visaLargeTicketIndicator = null, $cardClassId = null, $cardClassIdDescription = null)
    {
        $this
            ->setLowBin($lowBin)
            ->setHighBin($highBin)
            ->setBinLength($binLength)
            ->setCardProductId($cardProductId)
            ->setCardProductIdDescription($cardProductIdDescription)
            ->setCardTypeId($cardTypeId)
            ->setCardTypeIdDescription($cardTypeIdDescription)
            ->setIssuerBankName($issuerBankName)
            ->setCountryCode($countryCode)
            ->setDetailCardProduct($detailCardProduct)
            ->setVisaLargeTicketIndicator($visaLargeTicketIndicator)
            ->setCardClassId($cardClassId)
            ->setCardClassIdDescription($cardClassIdDescription);
    }
    /**
     * Get LowBin value
     * @return string|null
     */
    public function getLowBin()
    {
        return $this->LowBin;
    }
    /**
     * Set LowBin value
     * @param string $lowBin
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setLowBin($lowBin = null)
    {
        // validation for constraint: string
        if (!is_null($lowBin) && !is_string($lowBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowBin, true), gettype($lowBin)), __LINE__);
        }
        $this->LowBin = $lowBin;
        return $this;
    }
    /**
     * Get HighBin value
     * @return string|null
     */
    public function getHighBin()
    {
        return $this->HighBin;
    }
    /**
     * Set HighBin value
     * @param string $highBin
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setHighBin($highBin = null)
    {
        // validation for constraint: string
        if (!is_null($highBin) && !is_string($highBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($highBin, true), gettype($highBin)), __LINE__);
        }
        $this->HighBin = $highBin;
        return $this;
    }
    /**
     * Get BinLength value
     * @return string|null
     */
    public function getBinLength()
    {
        return $this->BinLength;
    }
    /**
     * Set BinLength value
     * @param string $binLength
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setBinLength($binLength = null)
    {
        // validation for constraint: string
        if (!is_null($binLength) && !is_string($binLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binLength, true), gettype($binLength)), __LINE__);
        }
        $this->BinLength = $binLength;
        return $this;
    }
    /**
     * Get CardProductId value
     * @return string|null
     */
    public function getCardProductId()
    {
        return $this->CardProductId;
    }
    /**
     * Set CardProductId value
     * @param string $cardProductId
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardProductId($cardProductId = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductId) && !is_string($cardProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductId, true), gettype($cardProductId)), __LINE__);
        }
        $this->CardProductId = $cardProductId;
        return $this;
    }
    /**
     * Get CardProductIdDescription value
     * @return string|null
     */
    public function getCardProductIdDescription()
    {
        return $this->CardProductIdDescription;
    }
    /**
     * Set CardProductIdDescription value
     * @param string $cardProductIdDescription
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardProductIdDescription($cardProductIdDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductIdDescription) && !is_string($cardProductIdDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductIdDescription, true), gettype($cardProductIdDescription)), __LINE__);
        }
        $this->CardProductIdDescription = $cardProductIdDescription;
        return $this;
    }
    /**
     * Get CardTypeId value
     * @return string|null
     */
    public function getCardTypeId()
    {
        return $this->CardTypeId;
    }
    /**
     * Set CardTypeId value
     * @param string $cardTypeId
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        $this->CardTypeId = $cardTypeId;
        return $this;
    }
    /**
     * Get CardTypeIdDescription value
     * @return string|null
     */
    public function getCardTypeIdDescription()
    {
        return $this->CardTypeIdDescription;
    }
    /**
     * Set CardTypeIdDescription value
     * @param string $cardTypeIdDescription
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardTypeIdDescription($cardTypeIdDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeIdDescription) && !is_string($cardTypeIdDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeIdDescription, true), gettype($cardTypeIdDescription)), __LINE__);
        }
        $this->CardTypeIdDescription = $cardTypeIdDescription;
        return $this;
    }
    /**
     * Get IssuerBankName value
     * @return string|null
     */
    public function getIssuerBankName()
    {
        return $this->IssuerBankName;
    }
    /**
     * Set IssuerBankName value
     * @param string $issuerBankName
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setIssuerBankName($issuerBankName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerBankName) && !is_string($issuerBankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerBankName, true), gettype($issuerBankName)), __LINE__);
        }
        $this->IssuerBankName = $issuerBankName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get DetailCardProduct value
     * @return string|null
     */
    public function getDetailCardProduct()
    {
        return $this->DetailCardProduct;
    }
    /**
     * Set DetailCardProduct value
     * @param string $detailCardProduct
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setDetailCardProduct($detailCardProduct = null)
    {
        // validation for constraint: string
        if (!is_null($detailCardProduct) && !is_string($detailCardProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailCardProduct, true), gettype($detailCardProduct)), __LINE__);
        }
        $this->DetailCardProduct = $detailCardProduct;
        return $this;
    }
    /**
     * Get VisaLargeTicketIndicator value
     * @return string|null
     */
    public function getVisaLargeTicketIndicator()
    {
        return $this->VisaLargeTicketIndicator;
    }
    /**
     * Set VisaLargeTicketIndicator value
     * @param string $visaLargeTicketIndicator
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setVisaLargeTicketIndicator($visaLargeTicketIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($visaLargeTicketIndicator) && !is_string($visaLargeTicketIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaLargeTicketIndicator, true), gettype($visaLargeTicketIndicator)), __LINE__);
        }
        $this->VisaLargeTicketIndicator = $visaLargeTicketIndicator;
        return $this;
    }
    /**
     * Get CardClassId value
     * @return string|null
     */
    public function getCardClassId()
    {
        return $this->CardClassId;
    }
    /**
     * Set CardClassId value
     * @param string $cardClassId
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardClassId($cardClassId = null)
    {
        // validation for constraint: string
        if (!is_null($cardClassId) && !is_string($cardClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardClassId, true), gettype($cardClassId)), __LINE__);
        }
        $this->CardClassId = $cardClassId;
        return $this;
    }
    /**
     * Get CardClassIdDescription value
     * @return string|null
     */
    public function getCardClassIdDescription()
    {
        return $this->CardClassIdDescription;
    }
    /**
     * Set CardClassIdDescription value
     * @param string $cardClassIdDescription
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public function setCardClassIdDescription($cardClassIdDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardClassIdDescription) && !is_string($cardClassIdDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardClassIdDescription, true), gettype($cardClassIdDescription)), __LINE__);
        }
        $this->CardClassIdDescription = $cardClassIdDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GlobalBINData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
