<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationTransactionSearchResult StructType
 * @subpackage Structs
 */
class ApplicationTransactionSearchResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Start;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Limit;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The ApplicationTransactions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails
     */
    public $ApplicationTransactions;
    /**
     * Constructor method for ApplicationTransactionSearchResult
     * @uses ApplicationTransactionSearchResult::setStart()
     * @uses ApplicationTransactionSearchResult::setLimit()
     * @uses ApplicationTransactionSearchResult::setCount()
     * @uses ApplicationTransactionSearchResult::setApplicationTransactions()
     * @param int $start
     * @param int $limit
     * @param int $count
     * @param \eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails $applicationTransactions
     */
    public function __construct($start = null, $limit = null, $count = null, \eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails $applicationTransactions = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setCount($count)
            ->setApplicationTransactions($applicationTransactions);
    }
    /**
     * Get Start value
     * @return int
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param int $start
     * @return \eBizCharge\StructType\ApplicationTransactionSearchResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \eBizCharge\StructType\ApplicationTransactionSearchResult
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \eBizCharge\StructType\ApplicationTransactionSearchResult
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get ApplicationTransactions value
     * @return \eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails|null
     */
    public function getApplicationTransactions()
    {
        return $this->ApplicationTransactions;
    }
    /**
     * Set ApplicationTransactions value
     * @param \eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails $applicationTransactions
     * @return \eBizCharge\StructType\ApplicationTransactionSearchResult
     */
    public function setApplicationTransactions(\eBizCharge\ArrayType\ArrayOfApplicationTransactionDetails $applicationTransactions = null)
    {
        $this->ApplicationTransactions = $applicationTransactions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\ApplicationTransactionSearchResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
