<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrder StructType
 * @subpackage Structs
 */
class SalesOrder extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountDue;
    /**
     * The NotifyCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyCustomer;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalTaxAmount;
    /**
     * The IsToBeEmailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsToBeEmailed;
    /**
     * The IsToBePrinted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsToBePrinted;
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SubCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCustomerId;
    /**
     * The SalesOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesOrderNumber;
    /**
     * The SalesOrderInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesOrderInternalId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DueDate;
    /**
     * The PoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNum;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeId;
    /**
     * The UploadedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UploadedBy;
    /**
     * The UpdatedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedBy;
    /**
     * The DateUploaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateUploaded;
    /**
     * The DateUpdated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateUpdated;
    /**
     * The isDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isDeleted;
    /**
     * The DeletedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeletedBy;
    /**
     * The DateDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateDeleted;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfItem
     */
    public $Items;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * The EmailTemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTemplateID;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The UniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The CustomerMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerMessage;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The ShipDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipDate;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipVia;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesRepId;
    /**
     * The TermsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsId;
    /**
     * The SalesOrderLastSyncDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesOrderLastSyncDateTime;
    /**
     * The SalesOrderCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $SalesOrderCustomFields;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationId;
    /**
     * Constructor method for SalesOrder
     * @uses SalesOrder::setAmount()
     * @uses SalesOrder::setAmountDue()
     * @uses SalesOrder::setNotifyCustomer()
     * @uses SalesOrder::setTotalTaxAmount()
     * @uses SalesOrder::setIsToBeEmailed()
     * @uses SalesOrder::setIsToBePrinted()
     * @uses SalesOrder::setMerchantId()
     * @uses SalesOrder::setCustomerId()
     * @uses SalesOrder::setSubCustomerId()
     * @uses SalesOrder::setSalesOrderNumber()
     * @uses SalesOrder::setSalesOrderInternalId()
     * @uses SalesOrder::setDate()
     * @uses SalesOrder::setCurrency()
     * @uses SalesOrder::setDueDate()
     * @uses SalesOrder::setPoNum()
     * @uses SalesOrder::setDivisionId()
     * @uses SalesOrder::setTypeId()
     * @uses SalesOrder::setUploadedBy()
     * @uses SalesOrder::setUpdatedBy()
     * @uses SalesOrder::setDateUploaded()
     * @uses SalesOrder::setDateUpdated()
     * @uses SalesOrder::setIsDeleted()
     * @uses SalesOrder::setDeletedBy()
     * @uses SalesOrder::setDateDeleted()
     * @uses SalesOrder::setItems()
     * @uses SalesOrder::setSoftware()
     * @uses SalesOrder::setEmailTemplateID()
     * @uses SalesOrder::setURL()
     * @uses SalesOrder::setUniqueId()
     * @uses SalesOrder::setDescription()
     * @uses SalesOrder::setBillingAddress()
     * @uses SalesOrder::setShippingAddress()
     * @uses SalesOrder::setCustomerMessage()
     * @uses SalesOrder::setMemo()
     * @uses SalesOrder::setShipDate()
     * @uses SalesOrder::setShipVia()
     * @uses SalesOrder::setSalesRepId()
     * @uses SalesOrder::setTermsId()
     * @uses SalesOrder::setSalesOrderLastSyncDateTime()
     * @uses SalesOrder::setSalesOrderCustomFields()
     * @uses SalesOrder::setLocationId()
     * @param float $amount
     * @param float $amountDue
     * @param bool $notifyCustomer
     * @param float $totalTaxAmount
     * @param bool $isToBeEmailed
     * @param bool $isToBePrinted
     * @param string $merchantId
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $salesOrderNumber
     * @param string $salesOrderInternalId
     * @param string $date
     * @param string $currency
     * @param string $dueDate
     * @param string $poNum
     * @param string $divisionId
     * @param string $typeId
     * @param string $uploadedBy
     * @param string $updatedBy
     * @param string $dateUploaded
     * @param string $dateUpdated
     * @param string $isDeleted
     * @param string $deletedBy
     * @param string $dateDeleted
     * @param \eBizCharge\ArrayType\ArrayOfItem $items
     * @param string $software
     * @param string $emailTemplateID
     * @param string $uRL
     * @param string $uniqueId
     * @param string $description
     * @param \eBizCharge\StructType\Address $billingAddress
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @param string $customerMessage
     * @param string $memo
     * @param string $shipDate
     * @param string $shipVia
     * @param string $salesRepId
     * @param string $termsId
     * @param string $salesOrderLastSyncDateTime
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $salesOrderCustomFields
     * @param string $locationId
     */
    public function __construct($amount = null, $amountDue = null, $notifyCustomer = null, $totalTaxAmount = null, $isToBeEmailed = null, $isToBePrinted = null, $merchantId = null, $customerId = null, $subCustomerId = null, $salesOrderNumber = null, $salesOrderInternalId = null, $date = null, $currency = null, $dueDate = null, $poNum = null, $divisionId = null, $typeId = null, $uploadedBy = null, $updatedBy = null, $dateUploaded = null, $dateUpdated = null, $isDeleted = null, $deletedBy = null, $dateDeleted = null, \eBizCharge\ArrayType\ArrayOfItem $items = null, $software = null, $emailTemplateID = null, $uRL = null, $uniqueId = null, $description = null, \eBizCharge\StructType\Address $billingAddress = null, \eBizCharge\StructType\Address $shippingAddress = null, $customerMessage = null, $memo = null, $shipDate = null, $shipVia = null, $salesRepId = null, $termsId = null, $salesOrderLastSyncDateTime = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $salesOrderCustomFields = null, $locationId = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountDue($amountDue)
            ->setNotifyCustomer($notifyCustomer)
            ->setTotalTaxAmount($totalTaxAmount)
            ->setIsToBeEmailed($isToBeEmailed)
            ->setIsToBePrinted($isToBePrinted)
            ->setMerchantId($merchantId)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setSalesOrderNumber($salesOrderNumber)
            ->setSalesOrderInternalId($salesOrderInternalId)
            ->setDate($date)
            ->setCurrency($currency)
            ->setDueDate($dueDate)
            ->setPoNum($poNum)
            ->setDivisionId($divisionId)
            ->setTypeId($typeId)
            ->setUploadedBy($uploadedBy)
            ->setUpdatedBy($updatedBy)
            ->setDateUploaded($dateUploaded)
            ->setDateUpdated($dateUpdated)
            ->setIsDeleted($isDeleted)
            ->setDeletedBy($deletedBy)
            ->setDateDeleted($dateDeleted)
            ->setItems($items)
            ->setSoftware($software)
            ->setEmailTemplateID($emailTemplateID)
            ->setURL($uRL)
            ->setUniqueId($uniqueId)
            ->setDescription($description)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress)
            ->setCustomerMessage($customerMessage)
            ->setMemo($memo)
            ->setShipDate($shipDate)
            ->setShipVia($shipVia)
            ->setSalesRepId($salesRepId)
            ->setTermsId($termsId)
            ->setSalesOrderLastSyncDateTime($salesOrderLastSyncDateTime)
            ->setSalesOrderCustomFields($salesOrderCustomFields)
            ->setLocationId($locationId);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get NotifyCustomer value
     * @return bool
     */
    public function getNotifyCustomer()
    {
        return $this->NotifyCustomer;
    }
    /**
     * Set NotifyCustomer value
     * @param bool $notifyCustomer
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setNotifyCustomer($notifyCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyCustomer) && !is_bool($notifyCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notifyCustomer, true), gettype($notifyCustomer)), __LINE__);
        }
        $this->NotifyCustomer = $notifyCustomer;
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * @return float
     */
    public function getTotalTaxAmount()
    {
        return $this->TotalTaxAmount;
    }
    /**
     * Set TotalTaxAmount value
     * @param float $totalTaxAmount
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setTotalTaxAmount($totalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxAmount) && !(is_float($totalTaxAmount) || is_numeric($totalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxAmount, true), gettype($totalTaxAmount)), __LINE__);
        }
        $this->TotalTaxAmount = $totalTaxAmount;
        return $this;
    }
    /**
     * Get IsToBeEmailed value
     * @return bool
     */
    public function getIsToBeEmailed()
    {
        return $this->IsToBeEmailed;
    }
    /**
     * Set IsToBeEmailed value
     * @param bool $isToBeEmailed
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setIsToBeEmailed($isToBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isToBeEmailed) && !is_bool($isToBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isToBeEmailed, true), gettype($isToBeEmailed)), __LINE__);
        }
        $this->IsToBeEmailed = $isToBeEmailed;
        return $this;
    }
    /**
     * Get IsToBePrinted value
     * @return bool
     */
    public function getIsToBePrinted()
    {
        return $this->IsToBePrinted;
    }
    /**
     * Set IsToBePrinted value
     * @param bool $isToBePrinted
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setIsToBePrinted($isToBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isToBePrinted) && !is_bool($isToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isToBePrinted, true), gettype($isToBePrinted)), __LINE__);
        }
        $this->IsToBePrinted = $isToBePrinted;
        return $this;
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SubCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->SubCustomerId;
    }
    /**
     * Set SubCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->SubCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get SalesOrderNumber value
     * @return string|null
     */
    public function getSalesOrderNumber()
    {
        return $this->SalesOrderNumber;
    }
    /**
     * Set SalesOrderNumber value
     * @param string $salesOrderNumber
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSalesOrderNumber($salesOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderNumber) && !is_string($salesOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderNumber, true), gettype($salesOrderNumber)), __LINE__);
        }
        $this->SalesOrderNumber = $salesOrderNumber;
        return $this;
    }
    /**
     * Get SalesOrderInternalId value
     * @return string|null
     */
    public function getSalesOrderInternalId()
    {
        return $this->SalesOrderInternalId;
    }
    /**
     * Set SalesOrderInternalId value
     * @param string $salesOrderInternalId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSalesOrderInternalId($salesOrderInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderInternalId) && !is_string($salesOrderInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderInternalId, true), gettype($salesOrderInternalId)), __LINE__);
        }
        $this->SalesOrderInternalId = $salesOrderInternalId;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get PoNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->PoNum;
    }
    /**
     * Set PoNum value
     * @param string $poNum
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->PoNum = $poNum;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
    /**
     * Get UploadedBy value
     * @return string|null
     */
    public function getUploadedBy()
    {
        return $this->UploadedBy;
    }
    /**
     * Set UploadedBy value
     * @param string $uploadedBy
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setUploadedBy($uploadedBy = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedBy) && !is_string($uploadedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedBy, true), gettype($uploadedBy)), __LINE__);
        }
        $this->UploadedBy = $uploadedBy;
        return $this;
    }
    /**
     * Get UpdatedBy value
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return $this->UpdatedBy;
    }
    /**
     * Set UpdatedBy value
     * @param string $updatedBy
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setUpdatedBy($updatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($updatedBy) && !is_string($updatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedBy, true), gettype($updatedBy)), __LINE__);
        }
        $this->UpdatedBy = $updatedBy;
        return $this;
    }
    /**
     * Get DateUploaded value
     * @return string|null
     */
    public function getDateUploaded()
    {
        return $this->DateUploaded;
    }
    /**
     * Set DateUploaded value
     * @param string $dateUploaded
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDateUploaded($dateUploaded = null)
    {
        // validation for constraint: string
        if (!is_null($dateUploaded) && !is_string($dateUploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUploaded, true), gettype($dateUploaded)), __LINE__);
        }
        $this->DateUploaded = $dateUploaded;
        return $this;
    }
    /**
     * Get DateUpdated value
     * @return string|null
     */
    public function getDateUpdated()
    {
        return $this->DateUpdated;
    }
    /**
     * Set DateUpdated value
     * @param string $dateUpdated
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDateUpdated($dateUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($dateUpdated) && !is_string($dateUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUpdated, true), gettype($dateUpdated)), __LINE__);
        }
        $this->DateUpdated = $dateUpdated;
        return $this;
    }
    /**
     * Get isDeleted value
     * @return string|null
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }
    /**
     * Set isDeleted value
     * @param string $isDeleted
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($isDeleted) && !is_string($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->isDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get DeletedBy value
     * @return string|null
     */
    public function getDeletedBy()
    {
        return $this->DeletedBy;
    }
    /**
     * Set DeletedBy value
     * @param string $deletedBy
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDeletedBy($deletedBy = null)
    {
        // validation for constraint: string
        if (!is_null($deletedBy) && !is_string($deletedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletedBy, true), gettype($deletedBy)), __LINE__);
        }
        $this->DeletedBy = $deletedBy;
        return $this;
    }
    /**
     * Get DateDeleted value
     * @return string|null
     */
    public function getDateDeleted()
    {
        return $this->DateDeleted;
    }
    /**
     * Set DateDeleted value
     * @param string $dateDeleted
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDateDeleted($dateDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($dateDeleted) && !is_string($dateDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDeleted, true), gettype($dateDeleted)), __LINE__);
        }
        $this->DateDeleted = $dateDeleted;
        return $this;
    }
    /**
     * Get Items value
     * @return \eBizCharge\ArrayType\ArrayOfItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \eBizCharge\ArrayType\ArrayOfItem $items
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setItems(\eBizCharge\ArrayType\ArrayOfItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
    /**
     * Get EmailTemplateID value
     * @return string|null
     */
    public function getEmailTemplateID()
    {
        return $this->EmailTemplateID;
    }
    /**
     * Set EmailTemplateID value
     * @param string $emailTemplateID
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setEmailTemplateID($emailTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateID) && !is_string($emailTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateID, true), gettype($emailTemplateID)), __LINE__);
        }
        $this->EmailTemplateID = $emailTemplateID;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get UniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->UniqueId;
    }
    /**
     * Set UniqueId value
     * @param string $uniqueId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->UniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\Address $billingAddress
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setBillingAddress(\eBizCharge\StructType\Address $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setShippingAddress(\eBizCharge\StructType\Address $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get CustomerMessage value
     * @return string|null
     */
    public function getCustomerMessage()
    {
        return $this->CustomerMessage;
    }
    /**
     * Set CustomerMessage value
     * @param string $customerMessage
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setCustomerMessage($customerMessage = null)
    {
        // validation for constraint: string
        if (!is_null($customerMessage) && !is_string($customerMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerMessage, true), gettype($customerMessage)), __LINE__);
        }
        $this->CustomerMessage = $customerMessage;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get ShipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->ShipDate;
    }
    /**
     * Set ShipDate value
     * @param string $shipDate
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->ShipDate = $shipDate;
        return $this;
    }
    /**
     * Get ShipVia value
     * @return string|null
     */
    public function getShipVia()
    {
        return $this->ShipVia;
    }
    /**
     * Set ShipVia value
     * @param string $shipVia
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setShipVia($shipVia = null)
    {
        // validation for constraint: string
        if (!is_null($shipVia) && !is_string($shipVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipVia, true), gettype($shipVia)), __LINE__);
        }
        $this->ShipVia = $shipVia;
        return $this;
    }
    /**
     * Get SalesRepId value
     * @return string|null
     */
    public function getSalesRepId()
    {
        return $this->SalesRepId;
    }
    /**
     * Set SalesRepId value
     * @param string $salesRepId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        $this->SalesRepId = $salesRepId;
        return $this;
    }
    /**
     * Get TermsId value
     * @return string|null
     */
    public function getTermsId()
    {
        return $this->TermsId;
    }
    /**
     * Set TermsId value
     * @param string $termsId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setTermsId($termsId = null)
    {
        // validation for constraint: string
        if (!is_null($termsId) && !is_string($termsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsId, true), gettype($termsId)), __LINE__);
        }
        $this->TermsId = $termsId;
        return $this;
    }
    /**
     * Get SalesOrderLastSyncDateTime value
     * @return string|null
     */
    public function getSalesOrderLastSyncDateTime()
    {
        return $this->SalesOrderLastSyncDateTime;
    }
    /**
     * Set SalesOrderLastSyncDateTime value
     * @param string $salesOrderLastSyncDateTime
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSalesOrderLastSyncDateTime($salesOrderLastSyncDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderLastSyncDateTime) && !is_string($salesOrderLastSyncDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderLastSyncDateTime, true), gettype($salesOrderLastSyncDateTime)), __LINE__);
        }
        $this->SalesOrderLastSyncDateTime = $salesOrderLastSyncDateTime;
        return $this;
    }
    /**
     * Get SalesOrderCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getSalesOrderCustomFields()
    {
        return $this->SalesOrderCustomFields;
    }
    /**
     * Set SalesOrderCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $salesOrderCustomFields
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setSalesOrderCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $salesOrderCustomFields = null)
    {
        $this->SalesOrderCustomFields = $salesOrderCustomFields;
        return $this;
    }
    /**
     * Get LocationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param string $locationId
     * @return \eBizCharge\StructType\SalesOrder
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\SalesOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
