<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkRecurringPaymentAsApplied StructType
 * @subpackage Structs
 */
class MarkRecurringPaymentAsApplied extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The paymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentInternalId;
    /**
     * Constructor method for MarkRecurringPaymentAsApplied
     * @uses MarkRecurringPaymentAsApplied::setSecurityToken()
     * @uses MarkRecurringPaymentAsApplied::setInvoiceNumber()
     * @uses MarkRecurringPaymentAsApplied::setPaymentInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $invoiceNumber
     * @param string $paymentInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $invoiceNumber = null, $paymentInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setInvoiceNumber($invoiceNumber)
            ->setPaymentInternalId($paymentInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\MarkRecurringPaymentAsApplied
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\MarkRecurringPaymentAsApplied
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get paymentInternalId value
     * @return string|null
     */
    public function getPaymentInternalId()
    {
        return $this->paymentInternalId;
    }
    /**
     * Set paymentInternalId value
     * @param string $paymentInternalId
     * @return \eBizCharge\StructType\MarkRecurringPaymentAsApplied
     */
    public function setPaymentInternalId($paymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInternalId) && !is_string($paymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInternalId, true), gettype($paymentInternalId)), __LINE__);
        }
        $this->paymentInternalId = $paymentInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\MarkRecurringPaymentAsApplied
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
