<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicePaymentDetails StructType
 * @subpackage Structs
 */
class InvoicePaymentDetails extends AbstractStructBase
{
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaidAmount;
    /**
     * The InvoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalId;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for InvoicePaymentDetails
     * @uses InvoicePaymentDetails::setPaidAmount()
     * @uses InvoicePaymentDetails::setInvoiceInternalId()
     * @uses InvoicePaymentDetails::setCurrency()
     * @param float $paidAmount
     * @param string $invoiceInternalId
     * @param string $currency
     */
    public function __construct($paidAmount = null, $invoiceInternalId = null, $currency = null)
    {
        $this
            ->setPaidAmount($paidAmount)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setCurrency($currency);
    }
    /**
     * Get PaidAmount value
     * @return float
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param float $paidAmount
     * @return \eBizCharge\StructType\InvoicePaymentDetails
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->PaidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get InvoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->InvoiceInternalId;
    }
    /**
     * Set InvoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\InvoicePaymentDetails
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->InvoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\InvoicePaymentDetails
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\InvoicePaymentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
