<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserData StructType
 * @subpackage Structs
 */
class GetUserData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The userInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInternalId;
    /**
     * Constructor method for GetUserData
     * @uses GetUserData::setSecurityToken()
     * @uses GetUserData::setUserInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $userInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $userInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setUserInternalId($userInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetUserData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get userInternalId value
     * @return string|null
     */
    public function getUserInternalId()
    {
        return $this->userInternalId;
    }
    /**
     * Set userInternalId value
     * @param string $userInternalId
     * @return \eBizCharge\StructType\GetUserData
     */
    public function setUserInternalId($userInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($userInternalId) && !is_string($userInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInternalId, true), gettype($userInternalId)), __LINE__);
        }
        $this->userInternalId = $userInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GetUserData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
