<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSchedule StructType
 * @subpackage Structs
 */
class CustomSchedule extends AbstractStructBase
{
    /**
     * The Interval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Interval;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Frequency;
    /**
     * Constructor method for CustomSchedule
     * @uses CustomSchedule::setInterval()
     * @uses CustomSchedule::setFrequency()
     * @param int $interval
     * @param string $frequency
     */
    public function __construct($interval = null, $frequency = null)
    {
        $this
            ->setInterval($interval)
            ->setFrequency($frequency);
    }
    /**
     * Get Interval value
     * @return int
     */
    public function getInterval()
    {
        return $this->Interval;
    }
    /**
     * Set Interval value
     * @param int $interval
     * @return \eBizCharge\StructType\CustomSchedule
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: int
        if (!is_null($interval) && !(is_int($interval) || ctype_digit($interval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interval, true), gettype($interval)), __LINE__);
        }
        $this->Interval = $interval;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \eBizCharge\StructType\CustomSchedule
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\CustomSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
