<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Schedule ServiceType
 * @subpackage Services
 */
class Schedule extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ScheduleRecurringPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\ScheduleRecurringPayment $parameters
     * @return \eBizCharge\StructType\ScheduleRecurringPaymentResponse|bool
     */
    public function ScheduleRecurringPayment(\eBizCharge\StructType\ScheduleRecurringPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ScheduleRecurringPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\ScheduleRecurringPaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
