<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInvoice StructType
 * @subpackage Structs
 */
class UpdateInvoice extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Invoice
     */
    public $invoice;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The subCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCustomerId;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The invoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceInternalId;
    /**
     * Constructor method for UpdateInvoice
     * @uses UpdateInvoice::setSecurityToken()
     * @uses UpdateInvoice::setInvoice()
     * @uses UpdateInvoice::setCustomerId()
     * @uses UpdateInvoice::setSubCustomerId()
     * @uses UpdateInvoice::setInvoiceNumber()
     * @uses UpdateInvoice::setInvoiceInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param \eBizCharge\StructType\Invoice $invoice
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $invoiceNumber
     * @param string $invoiceInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, \eBizCharge\StructType\Invoice $invoice = null, $customerId = null, $subCustomerId = null, $invoiceNumber = null, $invoiceInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setInvoice($invoice)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceInternalId($invoiceInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get invoice value
     * @return \eBizCharge\StructType\Invoice|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \eBizCharge\StructType\Invoice $invoice
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setInvoice(\eBizCharge\StructType\Invoice $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get subCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->subCustomerId;
    }
    /**
     * Set subCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->subCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get invoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->invoiceInternalId;
    }
    /**
     * Set invoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->invoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\UpdateInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
